/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.FileUtils;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public final class AtomicFile {
    private final File mBackupName;
    private final File mBaseName;

    public AtomicFile(File file) {
        this.mBaseName = file;
        this.mBackupName = new File(file.getPath() + ".bak");
    }

    public void delete() {
        this.mBaseName.delete();
        this.mBackupName.delete();
    }

    public boolean exists() {
        return this.mBaseName.exists() || this.mBackupName.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void failWrite(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) return;
        FileUtils.sync(fileOutputStream);
        try {
            fileOutputStream.close();
            this.mBaseName.delete();
            this.mBackupName.renameTo(this.mBaseName);
            return;
        }
        catch (IOException iOException) {
            Log.w("AtomicFile", "failWrite: Got exception:", iOException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finishWrite(FileOutputStream fileOutputStream) {
        if (fileOutputStream == null) return;
        FileUtils.sync(fileOutputStream);
        try {
            fileOutputStream.close();
            this.mBackupName.delete();
            return;
        }
        catch (IOException iOException) {
            Log.w("AtomicFile", "finishWrite: Got exception:", iOException);
            return;
        }
    }

    public File getBaseFile() {
        return this.mBaseName;
    }

    public FileOutputStream openAppend() throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mBaseName, true);
            return fileOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("Couldn't append " + this.mBaseName);
        }
    }

    public FileInputStream openRead() throws FileNotFoundException {
        if (this.mBackupName.exists()) {
            this.mBaseName.delete();
            this.mBackupName.renameTo(this.mBaseName);
        }
        return new FileInputStream(this.mBaseName);
    }

    public byte[] readFully() throws IOException {
        int n;
        byte[] byArray;
        FileInputStream fileInputStream = this.openRead();
        int n2 = 0;
        try {
            byArray = new byte[fileInputStream.available()];
            while (true) {
                if ((n = fileInputStream.read(byArray, n2, byArray.length - n2)) > 0) break block4;
                break;
            }
        }
        catch (Throwable throwable) {
            fileInputStream.close();
            throw throwable;
        }
        {
            block4: {
                fileInputStream.close();
                return byArray;
            }
            n2 += n;
            int n3 = fileInputStream.available();
            if (n3 <= byArray.length - n2) continue;
            byte[] byArray2 = new byte[n2 + n3];
            System.arraycopy((byte[])byArray, (int)0, (byte[])byArray2, (int)0, (int)n2);
            byArray = byArray2;
            continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileOutputStream startWrite() throws IOException {
        if (this.mBaseName.exists()) {
            if (!this.mBackupName.exists()) {
                if (!this.mBaseName.renameTo(this.mBackupName)) {
                    Log.w("AtomicFile", "Couldn't rename file " + this.mBaseName + " to backup file " + this.mBackupName);
                }
            } else {
                this.mBaseName.delete();
            }
        }
        try {
            return new FileOutputStream(this.mBaseName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            File file = this.mBaseName.getParentFile();
            if (!file.mkdir()) {
                throw new IOException("Couldn't create directory " + this.mBaseName);
            }
            FileUtils.setPermissions(file.getPath(), 505, -1, -1);
            try {
                return new FileOutputStream(this.mBaseName);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                throw new IOException("Couldn't create " + this.mBaseName);
            }
        }
    }

    public void truncate() throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.mBaseName);
            FileUtils.sync(fileOutputStream);
            fileOutputStream.close();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("Couldn't append " + this.mBaseName);
        }
        catch (IOException iOException) {
            return;
        }
    }
}

