/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.FileUtils;
import android.os.Process;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.Slog;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.util.FastPrintWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;

public class ProcessCpuTracker {
    private static final boolean DEBUG = false;
    private static final int[] LOAD_AVERAGE_FORMAT;
    private static final int[] PROCESS_FULL_STATS_FORMAT;
    static final int PROCESS_FULL_STAT_BLOCKIO = 6;
    static final int PROCESS_FULL_STAT_MAJOR_FAULTS = 2;
    static final int PROCESS_FULL_STAT_MINOR_FAULTS = 1;
    static final int PROCESS_FULL_STAT_STIME = 4;
    static final int PROCESS_FULL_STAT_UTIME = 3;
    static final int PROCESS_FULL_STAT_VSIZE = 5;
    private static final int[] PROCESS_STATS_FORMAT;
    static final int PROCESS_STAT_BLOCKIO = 4;
    static final int PROCESS_STAT_MAJOR_FAULTS = 1;
    static final int PROCESS_STAT_MINOR_FAULTS = 0;
    static final int PROCESS_STAT_STIME = 3;
    static final int PROCESS_STAT_UTIME = 2;
    private static final int[] SYSTEM_CPU_FORMAT;
    private static final String TAG = "ProcessCpuTracker";
    private static final boolean localLOGV;
    private static final Comparator<Stats> sLoadComparator;
    private long mBaseIdleTime;
    private long mBaseIoWaitTime;
    private long mBaseIrqTime;
    private long mBaseSoftIrqTime;
    private long mBaseSystemTime;
    private long mBaseUserTime;
    private byte[] mBuffer;
    private long[] mCpuSpeedTimes;
    private long[] mCpuSpeeds;
    private int[] mCurPids;
    private int[] mCurThreadPids;
    private long mCurrentSampleRealTime;
    private long mCurrentSampleTime;
    private boolean mFirst = true;
    private final boolean mIncludeThreads;
    private long mLastSampleRealTime;
    private long mLastSampleTime;
    private float mLoad1 = 0.0f;
    private float mLoad15 = 0.0f;
    private float mLoad5 = 0.0f;
    private final float[] mLoadAverageData;
    private final ArrayList<Stats> mProcStats;
    private final long[] mProcessFullStatsData;
    private final String[] mProcessFullStatsStringData;
    private final long[] mProcessStatsData = new long[5];
    private long[] mRelCpuSpeedTimes;
    private int mRelIdleTime;
    private int mRelIoWaitTime;
    private int mRelIrqTime;
    private int mRelSoftIrqTime;
    private int mRelSystemTime;
    private int mRelUserTime;
    private final long[] mSinglePidStatsData = new long[5];
    private final long[] mSystemCpuData;
    private final ArrayList<Stats> mWorkingProcs;
    private boolean mWorkingProcsSorted;

    static {
        PROCESS_STATS_FORMAT = new int[]{32, 544, 32, 32, 32, 32, 32, 32, 32, 8224, 32, 8224, 32, 8224, 8224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 8224};
        PROCESS_FULL_STATS_FORMAT = new int[]{32, 4640, 32, 32, 32, 32, 32, 32, 32, 8224, 32, 8224, 32, 8224, 8224, 32, 32, 32, 32, 32, 32, 32, 8224, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 8224};
        SYSTEM_CPU_FORMAT = new int[]{288, 8224, 8224, 8224, 8224, 8224, 8224, 8224};
        LOAD_AVERAGE_FORMAT = new int[]{16416, 16416, 16416};
        sLoadComparator = new Comparator<Stats>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public final int compare(Stats stats, Stats stats2) {
                int n = stats.rel_utime + stats.rel_stime + stats.rel_iowait;
                int n2 = stats2.rel_utime + stats2.rel_stime + stats2.rel_iowait;
                if (n != n2) {
                    if (n > n2) return -1;
                    return 1;
                }
                if (stats.added != stats2.added) {
                    if (stats.added) return -1;
                    return 1;
                }
                if (stats.removed == stats2.removed) {
                    return 0;
                }
                if (!stats.added) return 1;
                return -1;
            }
        };
    }

    public ProcessCpuTracker(boolean bl) {
        this.mProcessFullStatsStringData = new String[7];
        this.mProcessFullStatsData = new long[7];
        this.mSystemCpuData = new long[7];
        this.mLoadAverageData = new float[3];
        this.mProcStats = new ArrayList();
        this.mWorkingProcs = new ArrayList();
        this.mBuffer = new byte[4096];
        this.mIncludeThreads = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] collectStats(String string2, int n, boolean bl, int[] nArray, ArrayList<Stats> arrayList) {
        int[] nArray2 = Process.getPids(string2, nArray);
        int n2 = nArray2 == null ? 0 : nArray2.length;
        int n3 = arrayList.size();
        int n4 = 0;
        int n5 = 0;
        while (true) {
            block20: {
                Stats stats;
                int n6;
                block19: {
                    if (n5 >= n2 || (n6 = nArray2[n5]) < 0) {
                        while (true) {
                            if (n4 >= n3) {
                                return nArray2;
                            }
                            Stats stats2 = arrayList.get(n4);
                            stats2.rel_utime = 0;
                            stats2.rel_stime = 0;
                            stats2.rel_minfaults = 0;
                            stats2.rel_majfaults = 0;
                            stats2.rel_iowait = 0;
                            stats2.removed = true;
                            stats2.working = true;
                            arrayList.remove(n4);
                            --n3;
                        }
                    }
                    stats = n4 < n3 ? arrayList.get(n4) : null;
                    if (stats == null || stats.pid != n6) break block19;
                    stats.added = false;
                    stats.working = false;
                    ++n4;
                    if (!stats.interesting) break block20;
                    long l = SystemClock.uptimeMillis();
                    long[] lArray = this.mProcessStatsData;
                    if (!Process.readProcFile(stats.statFile.toString(), PROCESS_STATS_FORMAT, null, lArray, null)) break block20;
                    long l2 = lArray[0];
                    long l3 = lArray[1];
                    long l4 = lArray[2];
                    long l5 = lArray[3];
                    long l6 = lArray[4];
                    if (l4 == stats.base_utime && l5 == stats.base_stime) {
                        stats.rel_utime = 0;
                        stats.rel_stime = 0;
                        stats.rel_minfaults = 0;
                        stats.rel_majfaults = 0;
                        stats.rel_iowait = 0;
                        if (stats.active) {
                            stats.active = false;
                        }
                        break block20;
                    } else {
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        int n11;
                        long l7;
                        if (!stats.active) {
                            stats.active = true;
                        }
                        if (n < 0) {
                            String string3 = stats.cmdlineFile;
                            this.getName(stats, string3);
                            if (stats.threadStats != null) {
                                this.mCurThreadPids = this.collectStats(stats.threadsDir, n6, false, this.mCurThreadPids, stats.threadStats);
                            }
                        }
                        stats.rel_uptime = l7 = l - stats.base_uptime;
                        stats.base_uptime = l;
                        stats.rel_utime = n11 = (int)(l4 - stats.base_utime);
                        stats.rel_stime = n10 = (int)(l5 - stats.base_stime);
                        stats.base_utime = l4;
                        stats.base_stime = l5;
                        stats.rel_minfaults = n9 = (int)(l2 - stats.base_minfaults);
                        stats.rel_majfaults = n8 = (int)(l3 - stats.base_majfaults);
                        stats.base_minfaults = l2;
                        stats.base_majfaults = l3;
                        stats.rel_iowait = n7 = (int)(l6 - stats.base_iowait);
                        stats.base_iowait = l6;
                        stats.working = true;
                    }
                    break block20;
                }
                if (stats == null || stats.pid > n6) {
                    Stats stats3 = new Stats(n6, n, this.mIncludeThreads);
                    arrayList.add(n4, stats3);
                    ++n4;
                    ++n3;
                    String[] stringArray = this.mProcessFullStatsStringData;
                    long[] lArray = this.mProcessFullStatsData;
                    stats3.base_uptime = SystemClock.uptimeMillis();
                    if (Process.readProcFile(stats3.statFile.toString(), PROCESS_FULL_STATS_FORMAT, stringArray, lArray, null)) {
                        stats3.vsize = lArray[5];
                        stats3.interesting = true;
                        stats3.baseName = stringArray[0];
                        stats3.base_minfaults = lArray[1];
                        stats3.base_majfaults = lArray[2];
                        stats3.base_utime = lArray[3];
                        stats3.base_stime = lArray[4];
                        stats3.base_iowait = lArray[6];
                    } else {
                        Slog.w(TAG, "Skipping unknown process pid " + n6);
                        stats3.baseName = "<unknown>";
                        stats3.base_stime = 0L;
                        stats3.base_utime = 0L;
                        stats3.base_majfaults = 0L;
                        stats3.base_minfaults = 0L;
                        stats3.base_iowait = 0L;
                    }
                    if (n < 0) {
                        this.getName(stats3, stats3.cmdlineFile);
                        if (stats3.threadStats != null) {
                            this.mCurThreadPids = this.collectStats(stats3.threadsDir, n6, true, this.mCurThreadPids, stats3.threadStats);
                        }
                    } else if (stats3.interesting) {
                        stats3.name = stats3.baseName;
                        stats3.nameWidth = this.onMeasureProcessName(stats3.name);
                    }
                    stats3.rel_utime = 0;
                    stats3.rel_stime = 0;
                    stats3.rel_minfaults = 0;
                    stats3.rel_majfaults = 0;
                    stats3.rel_iowait = 0;
                    stats3.added = true;
                    if (!bl && stats3.interesting) {
                        stats3.working = true;
                    }
                } else {
                    stats.rel_utime = 0;
                    stats.rel_stime = 0;
                    stats.rel_minfaults = 0;
                    stats.rel_majfaults = 0;
                    stats.rel_iowait = 0;
                    stats.removed = true;
                    stats.working = true;
                    arrayList.remove(n4);
                    --n3;
                    --n5;
                }
            }
            ++n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] getCpuSpeedTimes(long[] lArray) {
        long[] lArray2 = lArray;
        long[] lArray3 = this.mCpuSpeeds;
        if (lArray == null) {
            lArray2 = new long[60];
            lArray3 = new long[60];
        }
        String string2 = this.readFile("/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state", '\u0000');
        int n = 0;
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n ");
            while (stringTokenizer.hasMoreElements()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    lArray3[n] = Long.parseLong(string3);
                    lArray2[n] = Long.parseLong(stringTokenizer.nextToken());
                    if (++n != 60) continue;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    Slog.i(TAG, "Unable to parse time_in_state");
                }
            }
        }
        if (lArray == null) {
            lArray = new long[n];
            this.mCpuSpeeds = new long[n];
            System.arraycopy((long[])lArray3, (int)0, (long[])this.mCpuSpeeds, (int)0, (int)n);
            System.arraycopy((long[])lArray2, (int)0, (long[])lArray, (int)0, (int)n);
        }
        return lArray;
    }

    private void getName(Stats stats, String string2) {
        String string3 = stats.name;
        if (stats.name == null || stats.name.equals("app_process") || stats.name.equals("<pre-initialized>")) {
            int n;
            String string4 = this.readFile(string2, '\u0000');
            if (string4 != null && string4.length() > 1 && (n = (string3 = string4).lastIndexOf("/")) > 0 && n < -1 + string3.length()) {
                string3 = string3.substring(n + 1);
            }
            if (string3 == null) {
                string3 = stats.baseName;
            }
        }
        if (stats.name == null || !string3.equals(stats.name)) {
            stats.name = string3;
            stats.nameWidth = this.onMeasureProcessName(stats.name);
        }
    }

    private void printProcessCPU(PrintWriter printWriter, String string2, int n, String string3, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        printWriter.print(string2);
        if (n2 == 0) {
            n2 = 1;
        }
        this.printRatio(printWriter, n7 + (n6 + (n5 + (n3 + n4))), n2);
        printWriter.print("% ");
        if (n >= 0) {
            printWriter.print(n);
            printWriter.print("/");
        }
        printWriter.print(string3);
        printWriter.print(": ");
        this.printRatio(printWriter, n3, n2);
        printWriter.print("% user + ");
        this.printRatio(printWriter, n4, n2);
        printWriter.print("% kernel");
        if (n5 > 0) {
            printWriter.print(" + ");
            this.printRatio(printWriter, n5, n2);
            printWriter.print("% iowait");
        }
        if (n6 > 0) {
            printWriter.print(" + ");
            this.printRatio(printWriter, n6, n2);
            printWriter.print("% irq");
        }
        if (n7 > 0) {
            printWriter.print(" + ");
            this.printRatio(printWriter, n7, n2);
            printWriter.print("% softirq");
        }
        if (n8 > 0 || n9 > 0) {
            printWriter.print(" / faults:");
            if (n8 > 0) {
                printWriter.print(" ");
                printWriter.print(n8);
                printWriter.print(" minor");
            }
            if (n9 > 0) {
                printWriter.print(" ");
                printWriter.print(n9);
                printWriter.print(" major");
            }
        }
        printWriter.println();
    }

    private void printRatio(PrintWriter printWriter, long l, long l2) {
        long l3;
        long l4 = 1000L * l / l2;
        long l5 = l4 / 10L;
        printWriter.print(l5);
        if (l5 < 10L && (l3 = l4 - l5 * 10L) != 0L) {
            printWriter.print('.');
            printWriter.print(l3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String readFile(String var1_1, char var2_2) {
        block33: {
            var3_3 = StrictMode.allowThreadDiskReads();
            var4_4 = null;
            var5_5 = new FileInputStream(var1_1);
            try {
                var12_6 = var5_5.read(this.mBuffer);
                var5_5.close();
                if (var12_6 <= 0) break block33;
                var14_7 = 0;
            }
            catch (Throwable var10_13) {
                var4_4 = var5_5;
                ** continue;
            }
            catch (IOException var8_19) {
                var4_4 = var5_5;
                ** continue;
            }
            catch (FileNotFoundException var6_20) {
                var4_4 = var5_5;
                ** continue;
            }
            while (true) {
                block34: {
                    block35: {
                        if (var14_7 >= var12_6) ** GOTO lbl14
                        if (this.mBuffer[var14_7] != var2_2) break block34;
lbl14:
                        // 2 sources

                        var15_8 = new String(this.mBuffer, 0, var14_7);
                        if (var5_5 == null) break block35;
                        var5_5.close();
                    }
lbl19:
                    // 2 sources

                    while (true) {
                        StrictMode.setThreadPolicy(var3_3);
                        return var15_8;
                    }
                }
                ++var14_7;
            }
        }
        if (var5_5 != null) {
            var5_5.close();
        }
lbl29:
        // 4 sources

        while (true) {
            StrictMode.setThreadPolicy(var3_3);
lbl31:
            // 3 sources

            return null;
        }
        catch (FileNotFoundException var18_9) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var4_4 != null) {
                    var4_4.close();
                }
lbl38:
                // 4 sources

                while (true) {
                    StrictMode.setThreadPolicy(var3_3);
                    ** GOTO lbl31
                    break;
                }
                break;
            }
        }
        catch (IOException var17_10) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var4_4 != null) {
                    var4_4.close();
                }
lbl46:
                // 4 sources

                while (true) {
                    StrictMode.setThreadPolicy(var3_3);
                    ** continue;
                    break;
                }
                break;
            }
        }
        catch (Throwable var10_11) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var4_4 != null) {
                    var4_4.close();
                }
lbl54:
                // 4 sources

                while (true) {
                    StrictMode.setThreadPolicy(var3_3);
                    throw var10_12;
                }
                break;
            }
        }
        catch (IOException var16_14) {
            ** continue;
        }
        catch (IOException var13_15) {
            ** continue;
        }
        {
            catch (IOException var7_16) {
                ** continue;
            }
        }
        {
            catch (IOException var9_17) {
                ** continue;
            }
        }
        {
            catch (IOException var11_18) {
                ** continue;
            }
        }
    }

    final void buildWorkingProcs() {
        if (!this.mWorkingProcsSorted) {
            this.mWorkingProcs.clear();
            int n = this.mProcStats.size();
            for (int i = 0; i < n; ++i) {
                Stats stats = this.mProcStats.get(i);
                if (!stats.working) continue;
                this.mWorkingProcs.add(stats);
                if (stats.threadStats == null || stats.threadStats.size() <= 1) continue;
                stats.workingThreads.clear();
                int n2 = stats.threadStats.size();
                for (int j = 0; j < n2; ++j) {
                    Stats stats2 = stats.threadStats.get(j);
                    if (!stats2.working) continue;
                    stats.workingThreads.add(stats2);
                }
                Collections.sort(stats.workingThreads, sLoadComparator);
            }
            Collections.sort(this.mWorkingProcs, sLoadComparator);
            this.mWorkingProcsSorted = true;
        }
    }

    public final int countStats() {
        return this.mProcStats.size();
    }

    public final int countWorkingStats() {
        this.buildWorkingProcs();
        return this.mWorkingProcs.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getCpuTimeForPid(int n) {
        long[] lArray = this.mSinglePidStatsData;
        synchronized (lArray) {
            String string2 = "/proc/" + n + "/stat";
            long[] lArray2 = this.mSinglePidStatsData;
            if (!Process.readProcFile(string2, PROCESS_STATS_FORMAT, null, lArray2, null)) return 0L;
            return lArray2[2] + lArray2[3];
        }
    }

    public long[] getLastCpuSpeedTimes() {
        if (this.mCpuSpeedTimes == null) {
            this.mCpuSpeedTimes = this.getCpuSpeedTimes(null);
            this.mRelCpuSpeedTimes = new long[this.mCpuSpeedTimes.length];
            for (int i = 0; i < this.mCpuSpeedTimes.length; ++i) {
                this.mRelCpuSpeedTimes[i] = 1L;
            }
        } else {
            this.getCpuSpeedTimes(this.mRelCpuSpeedTimes);
            for (int i = 0; i < this.mCpuSpeedTimes.length; ++i) {
                long l = this.mRelCpuSpeedTimes[i];
                long[] lArray = this.mRelCpuSpeedTimes;
                lArray[i] = lArray[i] - this.mCpuSpeedTimes[i];
                this.mCpuSpeedTimes[i] = l;
            }
        }
        return this.mRelCpuSpeedTimes;
    }

    public final int getLastIdleTime() {
        return this.mRelIdleTime;
    }

    public final int getLastIoWaitTime() {
        return this.mRelIoWaitTime;
    }

    public final int getLastIrqTime() {
        return this.mRelIrqTime;
    }

    public final int getLastSoftIrqTime() {
        return this.mRelSoftIrqTime;
    }

    public final int getLastSystemTime() {
        return this.mRelSystemTime;
    }

    public final int getLastUserTime() {
        return this.mRelUserTime;
    }

    public final Stats getStats(int n) {
        return this.mProcStats.get(n);
    }

    public final float getTotalCpuPercent() {
        int n = this.mRelUserTime + this.mRelSystemTime + this.mRelIrqTime + this.mRelIdleTime;
        if (n <= 0) {
            return 0.0f;
        }
        return 100.0f * (float)(this.mRelUserTime + this.mRelSystemTime + this.mRelIrqTime) / (float)n;
    }

    public final Stats getWorkingStats(int n) {
        return this.mWorkingProcs.get(n);
    }

    public void init() {
        this.mFirst = true;
        this.update();
    }

    public void onLoadChanged(float f, float f2, float f3) {
    }

    public int onMeasureProcessName(String string2) {
        return 0;
    }

    public final String printCurrentLoad() {
        StringWriter stringWriter = new StringWriter();
        FastPrintWriter fastPrintWriter = new FastPrintWriter(stringWriter, false, 128);
        ((PrintWriter)fastPrintWriter).print("Load: ");
        fastPrintWriter.print(this.mLoad1);
        ((PrintWriter)fastPrintWriter).print(" / ");
        fastPrintWriter.print(this.mLoad5);
        ((PrintWriter)fastPrintWriter).print(" / ");
        fastPrintWriter.println(this.mLoad15);
        ((PrintWriter)fastPrintWriter).flush();
        return stringWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String printCurrentState(long l) {
        this.buildWorkingProcs();
        StringWriter stringWriter = new StringWriter();
        FastPrintWriter fastPrintWriter = new FastPrintWriter(stringWriter, false, 1024);
        ((PrintWriter)fastPrintWriter).print("CPU usage from ");
        if (l > this.mLastSampleTime) {
            ((PrintWriter)fastPrintWriter).print(l - this.mLastSampleTime);
            ((PrintWriter)fastPrintWriter).print("ms to ");
            ((PrintWriter)fastPrintWriter).print(l - this.mCurrentSampleTime);
            ((PrintWriter)fastPrintWriter).print("ms ago");
        } else {
            ((PrintWriter)fastPrintWriter).print(this.mLastSampleTime - l);
            ((PrintWriter)fastPrintWriter).print("ms to ");
            ((PrintWriter)fastPrintWriter).print(this.mCurrentSampleTime - l);
            ((PrintWriter)fastPrintWriter).print("ms later");
        }
        long l2 = this.mCurrentSampleTime - this.mLastSampleTime;
        long l3 = this.mCurrentSampleRealTime - this.mLastSampleRealTime;
        long l4 = l3 > 0L ? 100L * l2 / l3 : 0L;
        if (l4 != 100L) {
            ((PrintWriter)fastPrintWriter).print(" with ");
            ((PrintWriter)fastPrintWriter).print(l4);
            ((PrintWriter)fastPrintWriter).print("% awake");
        }
        fastPrintWriter.println(":");
        int n = this.mRelUserTime + this.mRelSystemTime + this.mRelIoWaitTime + this.mRelIrqTime + this.mRelSoftIrqTime + this.mRelIdleTime;
        int n2 = this.mWorkingProcs.size();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.printProcessCPU(fastPrintWriter, "", -1, "TOTAL", n, this.mRelUserTime, this.mRelSystemTime, this.mRelIoWaitTime, this.mRelIrqTime, this.mRelSoftIrqTime, 0, 0);
                ((PrintWriter)fastPrintWriter).flush();
                return stringWriter.toString();
            }
            Stats stats = this.mWorkingProcs.get(n3);
            String string2 = stats.added ? " +" : (stats.removed ? " -" : "  ");
            this.printProcessCPU(fastPrintWriter, string2, stats.pid, stats.name, (int)(5L + (stats.rel_uptime + (long)stats.rel_iowait)) / 10, stats.rel_utime, stats.rel_stime, stats.rel_iowait, 0, 0, stats.rel_minfaults, stats.rel_majfaults);
            if (!stats.removed && stats.workingThreads != null) {
                int n4 = stats.workingThreads.size();
                for (int i = 0; i < n4; ++i) {
                    Stats stats2 = stats.workingThreads.get(i);
                    String string3 = stats2.added ? "   +" : (stats2.removed ? "   -" : "    ");
                    this.printProcessCPU(fastPrintWriter, string3, stats2.pid, stats2.name, (int)(5L + (stats.rel_uptime + (long)stats.rel_iowait)) / 10, stats2.rel_utime, stats2.rel_stime, stats2.rel_iowait, 0, 0, 0, 0);
                }
            }
            ++n3;
        }
    }

    public void update() {
        this.mLastSampleTime = this.mCurrentSampleTime;
        this.mCurrentSampleTime = SystemClock.uptimeMillis();
        this.mLastSampleRealTime = this.mCurrentSampleRealTime;
        this.mCurrentSampleRealTime = SystemClock.elapsedRealtime();
        long[] lArray = this.mSystemCpuData;
        if (Process.readProcFile("/proc/stat", SYSTEM_CPU_FORMAT, null, lArray, null)) {
            long l = lArray[0] + lArray[1];
            long l2 = lArray[2];
            long l3 = lArray[3];
            long l4 = lArray[4];
            long l5 = lArray[5];
            long l6 = lArray[6];
            this.mRelUserTime = (int)(l - this.mBaseUserTime);
            this.mRelSystemTime = (int)(l2 - this.mBaseSystemTime);
            this.mRelIoWaitTime = (int)(l4 - this.mBaseIoWaitTime);
            this.mRelIrqTime = (int)(l5 - this.mBaseIrqTime);
            this.mRelSoftIrqTime = (int)(l6 - this.mBaseSoftIrqTime);
            this.mRelIdleTime = (int)(l3 - this.mBaseIdleTime);
            this.mBaseUserTime = l;
            this.mBaseSystemTime = l2;
            this.mBaseIoWaitTime = l4;
            this.mBaseIrqTime = l5;
            this.mBaseSoftIrqTime = l6;
            this.mBaseIdleTime = l3;
        }
        this.mCurPids = this.collectStats("/proc", -1, this.mFirst, this.mCurPids, this.mProcStats);
        float[] fArray = this.mLoadAverageData;
        if (Process.readProcFile("/proc/loadavg", LOAD_AVERAGE_FORMAT, null, null, fArray)) {
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            if (f != this.mLoad1 || f2 != this.mLoad5 || f3 != this.mLoad15) {
                this.mLoad1 = f;
                this.mLoad5 = f2;
                this.mLoad15 = f3;
                this.onLoadChanged(f, f2, f3);
            }
        }
        this.mWorkingProcsSorted = false;
        this.mFirst = false;
    }

    public static class Stats {
        public boolean active;
        public boolean added;
        public String baseName;
        public long base_iowait;
        public long base_majfaults;
        public long base_minfaults;
        public long base_stime;
        public long base_uptime;
        public long base_utime;
        public BatteryStatsImpl.Uid.Proc batteryStats;
        final String cmdlineFile;
        public boolean interesting;
        public String name;
        public int nameWidth;
        public final int pid;
        public int rel_iowait;
        public int rel_majfaults;
        public int rel_minfaults;
        public int rel_stime;
        public long rel_uptime;
        public int rel_utime;
        public boolean removed;
        final String statFile;
        final ArrayList<Stats> threadStats;
        final String threadsDir;
        public final int uid;
        public long vsize;
        public boolean working;
        final ArrayList<Stats> workingThreads;

        /*
         * Enabled aggressive block sorting
         */
        Stats(int n, int n2, boolean bl) {
            this.pid = n;
            if (n2 < 0) {
                File file = new File("/proc", Integer.toString(this.pid));
                this.statFile = new File(file, "stat").toString();
                this.cmdlineFile = new File(file, "cmdline").toString();
                this.threadsDir = new File(file, "task").toString();
                if (bl) {
                    this.threadStats = new ArrayList();
                    this.workingThreads = new ArrayList();
                } else {
                    this.threadStats = null;
                    this.workingThreads = null;
                }
            } else {
                this.statFile = new File(new File(new File(new File("/proc", Integer.toString(n2)), "task"), Integer.toString(this.pid)), "stat").toString();
                this.cmdlineFile = null;
                this.threadsDir = null;
                this.threadStats = null;
                this.workingThreads = null;
            }
            this.uid = FileUtils.getUid(this.statFile.toString());
        }
    }
}

