/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.PhoneAccountHandle;

public interface IInCallAdapter
extends IInterface {
    public void answerCall(String var1, int var2) throws RemoteException;

    public void conference(String var1, String var2) throws RemoteException;

    public void deflectCall(String var1, String var2) throws RemoteException;

    public void disconnectCall(String var1) throws RemoteException;

    public void holdCall(String var1) throws RemoteException;

    public void mergeConference(String var1) throws RemoteException;

    public void mute(boolean var1) throws RemoteException;

    public void phoneAccountSelected(String var1, PhoneAccountHandle var2) throws RemoteException;

    public void playDtmfTone(String var1, char var2) throws RemoteException;

    public void pokeUserActivity() throws RemoteException;

    public void postDialContinue(String var1, boolean var2) throws RemoteException;

    public void rejectCall(String var1, boolean var2, String var3) throws RemoteException;

    public void restartRing() throws RemoteException;

    public void setAudioRoute(int var1) throws RemoteException;

    public void silenceRing() throws RemoteException;

    public void splitFromConference(String var1) throws RemoteException;

    public void startOrUpdateInCallTimeout() throws RemoteException;

    public void stopDtmfTone(String var1) throws RemoteException;

    public void swapConference(String var1) throws RemoteException;

    public void switchToOtherActiveSub(String var1, boolean var2) throws RemoteException;

    public void turnOffProximitySensor(boolean var1) throws RemoteException;

    public void turnOnProximitySensor() throws RemoteException;

    public void unholdCall(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IInCallAdapter {
        private static final String DESCRIPTOR = "com.android.internal.telecom.IInCallAdapter";
        static final int TRANSACTION_answerCall = 1;
        static final int TRANSACTION_conference = 13;
        static final int TRANSACTION_deflectCall = 2;
        static final int TRANSACTION_disconnectCall = 4;
        static final int TRANSACTION_holdCall = 5;
        static final int TRANSACTION_mergeConference = 15;
        static final int TRANSACTION_mute = 7;
        static final int TRANSACTION_phoneAccountSelected = 12;
        static final int TRANSACTION_playDtmfTone = 9;
        static final int TRANSACTION_pokeUserActivity = 22;
        static final int TRANSACTION_postDialContinue = 11;
        static final int TRANSACTION_rejectCall = 3;
        static final int TRANSACTION_restartRing = 20;
        static final int TRANSACTION_setAudioRoute = 8;
        static final int TRANSACTION_silenceRing = 21;
        static final int TRANSACTION_splitFromConference = 14;
        static final int TRANSACTION_startOrUpdateInCallTimeout = 23;
        static final int TRANSACTION_stopDtmfTone = 10;
        static final int TRANSACTION_swapConference = 16;
        static final int TRANSACTION_switchToOtherActiveSub = 19;
        static final int TRANSACTION_turnOffProximitySensor = 18;
        static final int TRANSACTION_turnOnProximitySensor = 17;
        static final int TRANSACTION_unholdCall = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IInCallAdapter asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IInCallAdapter) {
                return (IInCallAdapter)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.answerCall(parcel.readString(), parcel.readInt());
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deflectCall(parcel.readString(), parcel.readString());
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    int n3 = parcel.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    this.rejectCall(string2, bl, parcel.readString());
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.disconnectCall(parcel.readString());
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.holdCall(parcel.readString());
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unholdCall(parcel.readString());
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.mute(bl);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAudioRoute(parcel.readInt());
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.playDtmfTone(parcel.readString(), (char)parcel.readInt());
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.stopDtmfTone(parcel.readString());
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    int n4 = parcel.readInt();
                    boolean bl = false;
                    if (n4 != 0) {
                        bl = true;
                    }
                    this.postDialContinue(string3, bl);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string4 = parcel.readString();
                    PhoneAccountHandle phoneAccountHandle = parcel.readInt() != 0 ? PhoneAccountHandle.CREATOR.createFromParcel(parcel) : null;
                    this.phoneAccountSelected(string4, phoneAccountHandle);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.conference(parcel.readString(), parcel.readString());
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.splitFromConference(parcel.readString());
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.mergeConference(parcel.readString());
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.swapConference(parcel.readString());
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.turnOnProximitySensor();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.turnOffProximitySensor(bl);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    int n5 = parcel.readInt();
                    boolean bl = false;
                    if (n5 != 0) {
                        bl = true;
                    }
                    this.switchToOtherActiveSub(string5, bl);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.restartRing();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.silenceRing();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.pokeUserActivity();
                    return true;
                }
                case 23: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            this.startOrUpdateInCallTimeout();
            return true;
        }

        private static class Proxy
        implements IInCallAdapter {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public void answerCall(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void conference(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(13, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void deflectCall(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void disconnectCall(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void holdCall(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(5, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void mergeConference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(15, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void mute(boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void phoneAccountSelected(String string2, PhoneAccountHandle phoneAccountHandle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (phoneAccountHandle != null) {
                        parcel.writeInt(1);
                        phoneAccountHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(12, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void playDtmfTone(String string2, char c) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(c);
                    this.mRemote.transact(9, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void pokeUserActivity() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void postDialContinue(String string2, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(11, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void rejectCall(String string2, boolean bl, String string3) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    this.mRemote.transact(3, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void restartRing() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setAudioRoute(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void silenceRing() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(21, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void splitFromConference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(14, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void startOrUpdateInCallTimeout() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(23, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void stopDtmfTone(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(10, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void swapConference(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(16, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void switchToOtherActiveSub(String string2, boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void turnOffProximitySensor(boolean bl) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (!bl) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, null, 1);
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void turnOnProximitySensor() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void unholdCall(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(6, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

