/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class Tweener {
    private static final boolean DEBUG = false;
    private static final String TAG = "Tweener";
    private static Animator.AnimatorListener mCleanupListener;
    private static HashMap<Object, Tweener> sTweens;
    ObjectAnimator animator;

    static {
        sTweens = new HashMap();
        mCleanupListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationCancel(Animator animator2) {
                Tweener.remove(animator2);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                Tweener.remove(animator2);
            }
        };
    }

    public Tweener(ObjectAnimator objectAnimator) {
        this.animator = objectAnimator;
    }

    private static void remove(Animator animator2) {
        Iterator<Map.Entry<Object, Tweener>> iterator = sTweens.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue().animator != animator2) continue;
            iterator.remove();
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void replace(ArrayList<PropertyValuesHolder> arrayList, Object ... objectArray) {
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            Tweener tweener = sTweens.get(object);
            if (tweener != null) {
                tweener.animator.cancel();
                if (arrayList != null) {
                    tweener.animator.setValues(arrayList.toArray(new PropertyValuesHolder[arrayList.size()]));
                } else {
                    sTweens.remove(tweener);
                }
            }
            ++n2;
        }
        return;
    }

    public static void reset() {
        sTweens.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Tweener to(Object object, long l, Object ... objectArray) {
        ObjectAnimator objectAnimator;
        long l2 = 0L;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = null;
        Animator.AnimatorListener animatorListener = null;
        TimeInterpolator timeInterpolator = null;
        ArrayList<PropertyValuesHolder> arrayList = new ArrayList<PropertyValuesHolder>(objectArray.length / 2);
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                throw new IllegalArgumentException("Key must be a string: " + objectArray[i]);
            }
            String string2 = (String)objectArray[i];
            Object object2 = objectArray[i + 1];
            if ("simultaneousTween".equals(string2)) continue;
            if ("ease".equals(string2)) {
                timeInterpolator = (TimeInterpolator)object2;
                continue;
            }
            if ("onUpdate".equals(string2) || "onUpdateListener".equals(string2)) {
                animatorUpdateListener = (ValueAnimator.AnimatorUpdateListener)object2;
                continue;
            }
            if ("onComplete".equals(string2) || "onCompleteListener".equals(string2)) {
                animatorListener = (Animator.AnimatorListener)object2;
                continue;
            }
            if ("delay".equals(string2)) {
                l2 = ((Number)object2).longValue();
                continue;
            }
            if ("syncWith".equals(string2)) continue;
            if (object2 instanceof float[]) {
                float[] fArray = new float[]{((float[])object2)[0], ((float[])object2)[1]};
                arrayList.add(PropertyValuesHolder.ofFloat(string2, fArray));
                continue;
            }
            if (object2 instanceof int[]) {
                int[] nArray = new int[]{((int[])object2)[0], ((int[])object2)[1]};
                arrayList.add(PropertyValuesHolder.ofInt(string2, nArray));
                continue;
            }
            if (!(object2 instanceof Number)) {
                throw new IllegalArgumentException("Bad argument for key \"" + string2 + "\" with value " + object2.getClass());
            }
            arrayList.add(PropertyValuesHolder.ofFloat(string2, ((Number)object2).floatValue()));
        }
        Tweener tweener = sTweens.get(object);
        if (tweener == null) {
            objectAnimator = ObjectAnimator.ofPropertyValuesHolder(object, arrayList.toArray(new PropertyValuesHolder[arrayList.size()]));
            tweener = new Tweener(objectAnimator);
            sTweens.put(object, tweener);
        } else {
            objectAnimator = Tweener.sTweens.get((Object)object).animator;
            Tweener.replace(arrayList, object);
        }
        if (timeInterpolator != null) {
            objectAnimator.setInterpolator(timeInterpolator);
        }
        objectAnimator.setStartDelay(l2);
        objectAnimator.setDuration(l);
        if (animatorUpdateListener != null) {
            objectAnimator.removeAllUpdateListeners();
            objectAnimator.addUpdateListener(animatorUpdateListener);
        }
        if (animatorListener != null) {
            objectAnimator.removeAllListeners();
            objectAnimator.addListener(animatorListener);
        }
        objectAnimator.addListener(mCleanupListener);
        return tweener;
    }

    Tweener from(Object object, long l, Object ... objectArray) {
        return Tweener.to(object, l, objectArray);
    }
}

