/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.util.ArrayMap;

public final class LocalServices {
    private static final ArrayMap<Class<?>, Object> sLocalServiceObjects = new ArrayMap();

    private LocalServices() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> void addService(Class<T> clazz, T t) {
        ArrayMap<Class<?>, Object> arrayMap = sLocalServiceObjects;
        synchronized (arrayMap) {
            if (sLocalServiceObjects.containsKey(clazz)) {
                throw new IllegalStateException("Overriding service registration");
            }
            sLocalServiceObjects.put(clazz, t);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getService(Class<T> clazz) {
        ArrayMap<Class<?>, Object> arrayMap = sLocalServiceObjects;
        synchronized (arrayMap) {
            Object object = sLocalServiceObjects.get(clazz);
            return (T)object;
        }
    }
}

