/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractMessageParser {
    public static final String musicNote = "\u266b ";
    private HashMap<Character, Format> formatStart;
    private int nextChar;
    private int nextClass;
    private boolean parseAcronyms;
    private boolean parseFormatting;
    private boolean parseMeText;
    private boolean parseMusic;
    private boolean parseSmilies;
    private boolean parseUrls;
    private ArrayList<Part> parts;
    private String text;
    private ArrayList<Token> tokens;

    public AbstractMessageParser(String string2) {
        this(string2, true, true, true, true, true, true);
    }

    public AbstractMessageParser(String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.text = string2;
        this.nextChar = 0;
        this.nextClass = 10;
        this.parts = new ArrayList();
        this.tokens = new ArrayList();
        this.formatStart = new HashMap();
        this.parseSmilies = bl;
        this.parseAcronyms = bl2;
        this.parseFormatting = bl3;
        this.parseUrls = bl4;
        this.parseMusic = bl5;
        this.parseMeText = bl6;
    }

    private void addToken(Token token) {
        this.tokens.add(token);
    }

    private void addURLToken(String string2, String string3) {
        this.addToken(AbstractMessageParser.tokenForUrl(string2, string3));
    }

    private void buildParts(String string2) {
        for (int i = 0; i < this.tokens.size(); ++i) {
            Token token = this.tokens.get(i);
            if (token.isMedia() || this.parts.size() == 0 || this.lastPart().isMedia()) {
                this.parts.add(new Part());
            }
            this.lastPart().add(token);
        }
        if (this.parts.size() > 0) {
            this.parts.get(0).setMeText(string2);
        }
    }

    private int getCharClass(int n) {
        if (n < 0 || this.text.length() <= n) {
            return 0;
        }
        char c = this.text.charAt(n);
        if (Character.isWhitespace(c)) {
            return 1;
        }
        if (Character.isLetter(c)) {
            return 2;
        }
        if (Character.isDigit(c)) {
            return 3;
        }
        if (AbstractMessageParser.isPunctuation(c)) {
            int n2;
            this.nextClass = n2 = 1 + this.nextClass;
            return n2;
        }
        return 4;
    }

    private boolean isDomainChar(char c) {
        return c == '-' || Character.isLetter(c) || Character.isDigit(c);
    }

    private static boolean isFormatChar(char c) {
        switch (c) {
            default: {
                return false;
            }
            case '*': 
            case '^': 
            case '_': 
        }
        return true;
    }

    private static boolean isPunctuation(char c) {
        switch (c) {
            default: {
                return false;
            }
            case '!': 
            case '\"': 
            case '(': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '?': 
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSmileyBreak(char c, char c2) {
        switch (c) {
            default: {
                return false;
            }
            case '$': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '|': 
            case '}': 
            case '~': 
        }
        switch (c2) {
            default: {
                return false;
            }
            case '#': 
            case '$': 
            case '%': 
            case '*': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '@': 
            case '[': 
            case '\\': 
            case '^': 
            case '~': 
        }
        return true;
    }

    private boolean isSmileyBreak(int n) {
        return n > 0 && n < this.text.length() && AbstractMessageParser.isSmileyBreak(this.text.charAt(n - 1), this.text.charAt(n));
    }

    private boolean isURLBreak(int n) {
        switch (this.getCharClass(n - 1)) {
            default: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
        }
        return false;
    }

    private boolean isValidDomain(String string2) {
        return AbstractMessageParser.matches(this.getResources().getDomainSuffixes(), AbstractMessageParser.reverse(string2));
    }

    private boolean isWordBreak(int n) {
        return this.getCharClass(n - 1) != this.getCharClass(n);
    }

    private Part lastPart() {
        return this.parts.get(-1 + this.parts.size());
    }

    private static TrieNode longestMatch(TrieNode trieNode, AbstractMessageParser abstractMessageParser, int n) {
        return AbstractMessageParser.longestMatch(trieNode, abstractMessageParser, n, false);
    }

    private static TrieNode longestMatch(TrieNode trieNode, AbstractMessageParser abstractMessageParser, int n, boolean bl) {
        int n2 = n;
        TrieNode trieNode2 = null;
        while (true) {
            int n3;
            block8: {
                block7: {
                    if (n2 >= abstractMessageParser.getRawText().length()) break block7;
                    String string2 = abstractMessageParser.getRawText();
                    n3 = n2 + 1;
                    if ((trieNode = trieNode.getChild(string2.charAt(n2))) != null) break block8;
                }
                return trieNode2;
            }
            if (trieNode.exists()) {
                if (abstractMessageParser.isWordBreak(n3)) {
                    trieNode2 = trieNode;
                    n2 = n3;
                    continue;
                }
                if (bl && abstractMessageParser.isSmileyBreak(n3)) {
                    trieNode2 = trieNode;
                    n2 = n3;
                    continue;
                }
            }
            n2 = n3;
        }
    }

    private static boolean matches(TrieNode trieNode, String string2) {
        int n = 0;
        while (true) {
            int n2;
            block6: {
                block5: {
                    if (n >= string2.length()) break block5;
                    n2 = n + 1;
                    if ((trieNode = trieNode.getChild(string2.charAt(n))) != null) break block6;
                }
                return false;
            }
            if (trieNode.exists()) {
                return true;
            }
            n = n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseAcronym() {
        TrieNode trieNode;
        if (!this.parseAcronyms || (trieNode = AbstractMessageParser.longestMatch(this.getResources().getAcronyms(), this, this.nextChar)) == null) {
            return false;
        }
        this.addToken(new Acronym(trieNode.getText(), trieNode.getValue()));
        this.nextChar += trieNode.getText().length();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseFormatting() {
        int n;
        block10: {
            block9: {
                if (!this.parseFormatting) break block9;
                for (n = this.nextChar; n < this.text.length() && AbstractMessageParser.isFormatChar(this.text.charAt(n)); ++n) {
                }
                if (n != this.nextChar && this.isWordBreak(n)) break block10;
            }
            return false;
        }
        LinkedHashMap<Character, Boolean> linkedHashMap = new LinkedHashMap<Character, Boolean>();
        for (int i = this.nextChar; i < n; ++i) {
            char c = this.text.charAt(i);
            Character c2 = Character.valueOf(c);
            if (linkedHashMap.containsKey(c2)) {
                this.addToken(new Format(c, false));
                continue;
            }
            Format format = this.formatStart.get(c2);
            if (format != null) {
                format.setMatched(true);
                this.formatStart.remove(c2);
                linkedHashMap.put(c2, Boolean.TRUE);
                continue;
            }
            Format format2 = new Format(c, true);
            this.formatStart.put(c2, format2);
            this.addToken(format2);
            linkedHashMap.put(c2, Boolean.FALSE);
        }
        Iterator iterator = linkedHashMap.keySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.nextChar = n;
                return true;
            }
            Character c = (Character)iterator.next();
            if (linkedHashMap.get(c) != Boolean.TRUE) continue;
            Format format = new Format(c.charValue(), false);
            format.setMatched(true);
            this.addToken(format);
        }
    }

    private boolean parseMusicTrack() {
        if (this.parseMusic && this.text.startsWith(musicNote)) {
            this.addToken(new MusicTrack(this.text.substring(musicNote.length())));
            this.nextChar = this.text.length();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseSmiley() {
        TrieNode trieNode;
        block3: {
            block2: {
                if (!this.parseSmilies || (trieNode = AbstractMessageParser.longestMatch(this.getResources().getSmileys(), this, this.nextChar, true)) == null) break block2;
                int n = this.getCharClass(-1 + this.nextChar);
                int n2 = this.getCharClass(this.nextChar + trieNode.getText().length());
                if (n != 2 && n != 3 || n2 != 2 && n2 != 3) break block3;
            }
            return false;
        }
        this.addToken(new Smiley(trieNode.getText()));
        this.nextChar += trieNode.getText().length();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parseText() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.nextChar;
        do {
            String string2 = this.text;
            int n2 = this.nextChar;
            this.nextChar = n2 + 1;
            char c = string2.charAt(n2);
            switch (c) {
                default: {
                    stringBuilder.append(c);
                    break;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    break;
                }
                case '\n': {
                    stringBuilder.append("<br>");
                }
            }
        } while (!this.isWordBreak(this.nextChar));
        this.addToken(new Html(this.text.substring(n, this.nextChar), stringBuilder.toString()));
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseURL() {
        block8: {
            block16: {
                block15: {
                    block12: {
                        block14: {
                            block13: {
                                block11: {
                                    block9: {
                                        if (!this.parseUrls || !this.isURLBreak(this.nextChar)) lbl-1000:
                                        // 6 sources

                                        {
                                            return false;
                                        }
                                        for (var2_2 = var1_1 = this.nextChar; var2_2 < this.text.length() && this.isDomainChar(this.text.charAt(var2_2)); ++var2_2) {
                                        }
                                        var3_3 = "";
                                        if (var2_2 == this.text.length()) ** GOTO lbl-1000
                                        if (this.text.charAt(var2_2) != ':') break block9;
                                        var10_4 = this.text.substring(this.nextChar, var2_2);
                                        var11_5 = this.getResources().getSchemes().contains(var10_4);
                                        var5_6 = false;
                                        if (!var11_5) ** GOTO lbl-1000
lbl13:
                                        // 2 sources

                                        while (!var5_6) {
                                            while (var2_2 < this.text.length() && !Character.isWhitespace(this.text.charAt(var2_2))) {
                                                ++var2_2;
                                            }
                                            break block8;
                                        }
                                        break block8;
                                    }
                                    if (this.text.charAt(var2_2) != '.') ** GOTO lbl-1000
                                    while (true) {
                                        block10: {
                                            if (var2_2 < this.text.length() && ((var9_10 = this.text.charAt(var2_2)) == '.' || this.isDomainChar(var9_10))) break block10;
                                            if (!this.isValidDomain(this.text.substring(this.nextChar, var2_2))) ** GOTO lbl-1000
                                            if (var2_2 + 1 >= this.text.length() || this.text.charAt(var2_2) != ':' || !Character.isDigit(this.text.charAt(var2_2 + 1))) break;
                                            ++var2_2;
                                            while (var2_2 < this.text.length() && Character.isDigit(this.text.charAt(var2_2))) {
                                                ++var2_2;
                                            }
                                            break;
                                        }
                                        ++var2_2;
                                    }
                                    if (var2_2 != this.text.length()) break block11;
                                    var5_6 = true;
lbl35:
                                    // 8 sources

                                    while (true) {
                                        var3_3 = "http://";
                                        ** GOTO lbl13
                                        break;
                                    }
                                }
                                var4_7 = this.text.charAt(var2_2);
                                if (var4_7 != '?') break block12;
                                if (var2_2 + 1 != this.text.length()) break block13;
                                var5_6 = true;
                                ** GOTO lbl35
                            }
                            var7_8 = this.text.charAt(var2_2 + 1);
                            if (Character.isWhitespace(var7_8)) break block14;
                            var8_9 = AbstractMessageParser.isPunctuation(var7_8);
                            var5_6 = false;
                            if (!var8_9) ** GOTO lbl35
                        }
                        var5_6 = true;
                        ** GOTO lbl35
                    }
                    if (!AbstractMessageParser.isPunctuation(var4_7)) break block15;
                    var5_6 = true;
                    ** GOTO lbl35
                }
                if (!Character.isWhitespace(var4_7)) break block16;
                var5_6 = true;
                ** GOTO lbl35
            }
            var5_6 = false;
            if (var4_7 == '/') ** GOTO lbl35
            if (var4_7 == '#') ** break;
            ** while (true)
            var5_6 = false;
            ** while (true)
        }
        var6_11 = this.text.substring(var1_1, var2_2);
        this.addURLToken(var3_3 + var6_11, var6_11);
        this.nextChar = var2_2;
        return true;
    }

    protected static String reverse(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = -1 + string2.length(); i >= 0; --i) {
            stringBuilder.append(string2.charAt(i));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Token tokenForUrl(String string2, String string3) {
        if (string2 == null) {
            return null;
        }
        Video video = Video.matchURL(string2, string3);
        if (video != null) return video;
        YouTubeVideo youTubeVideo = YouTubeVideo.matchURL(string2, string3);
        if (youTubeVideo != null) {
            return youTubeVideo;
        }
        Photo photo = Photo.matchURL(string2, string3);
        if (photo != null) {
            return photo;
        }
        FlickrPhoto flickrPhoto = FlickrPhoto.matchURL(string2, string3);
        if (flickrPhoto == null) return new Link(string2, string3);
        return flickrPhoto;
    }

    public final Part getPart(int n) {
        return this.parts.get(n);
    }

    public final int getPartCount() {
        return this.parts.size();
    }

    public final List<Part> getParts() {
        return this.parts;
    }

    public final String getRawText() {
        return this.text;
    }

    protected abstract Resources getResources();

    public void parse() {
        if (this.parseMusicTrack()) {
            this.buildParts(null);
            return;
        }
        boolean bl = this.parseMeText;
        String string2 = null;
        if (bl) {
            boolean bl2 = this.text.startsWith("/me");
            string2 = null;
            if (bl2) {
                int n = this.text.length();
                string2 = null;
                if (n > 3) {
                    boolean bl3 = Character.isWhitespace(this.text.charAt(3));
                    string2 = null;
                    if (bl3) {
                        string2 = this.text.substring(0, 4);
                        this.text = this.text.substring(4);
                    }
                }
            }
        }
        boolean bl4 = false;
        while (this.nextChar < this.text.length()) {
            if (!(this.isWordBreak(this.nextChar) || bl4 && this.isSmileyBreak(this.nextChar))) {
                throw new AssertionError((Object)"last chunk did not end at word break");
            }
            if (this.parseSmiley()) {
                bl4 = true;
                continue;
            }
            boolean bl5 = this.parseAcronym();
            bl4 = false;
            if (bl5) continue;
            boolean bl6 = this.parseURL();
            bl4 = false;
            if (bl6) continue;
            boolean bl7 = this.parseFormatting();
            bl4 = false;
            if (bl7) continue;
            this.parseText();
            bl4 = false;
        }
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (!this.tokens.get(i).isMedia()) continue;
            if (i > 0 && this.tokens.get(i - 1) instanceof Html) {
                ((Html)this.tokens.get(i - 1)).trimLeadingWhitespace();
            }
            if (i + 1 >= this.tokens.size() || !(this.tokens.get(i + 1) instanceof Html)) continue;
            ((Html)this.tokens.get(i + 1)).trimTrailingWhitespace();
        }
        for (int i = 0; i < this.tokens.size(); ++i) {
            if (!this.tokens.get(i).isHtml() || this.tokens.get(i).toHtml(true).length() != 0) continue;
            this.tokens.remove(i);
            --i;
        }
        this.buildParts(string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Part> iterator = this.parts.iterator();
        while (iterator.hasNext()) {
            Part part = iterator.next();
            boolean bl = false;
            stringBuilder.append("<p>");
            for (Token token : part.getTokens()) {
                if (token.isHtml()) {
                    stringBuilder.append(token.toHtml(bl));
                } else {
                    switch (1.$SwitchMap$com$google$android$util$AbstractMessageParser$Token$Type[token.getType().ordinal()]) {
                        default: {
                            throw new AssertionError((Object)("unknown token type: " + (Object)((Object)token.getType())));
                        }
                        case 1: {
                            stringBuilder.append("<a href=\"");
                            stringBuilder.append(((Link)token).getURL());
                            stringBuilder.append("\">");
                            stringBuilder.append(token.getRawText());
                            stringBuilder.append("</a>");
                            break;
                        }
                        case 2: {
                            stringBuilder.append(token.getRawText());
                            break;
                        }
                        case 3: {
                            stringBuilder.append(token.getRawText());
                            break;
                        }
                        case 4: {
                            stringBuilder.append(((MusicTrack)token).getTrack());
                            break;
                        }
                        case 5: {
                            stringBuilder.append("<a href=\"");
                            Video cfr_ignored_0 = (Video)token;
                            stringBuilder.append(Video.getURL(((Video)token).getDocID()));
                            stringBuilder.append("\">");
                            stringBuilder.append(token.getRawText());
                            stringBuilder.append("</a>");
                            break;
                        }
                        case 6: {
                            stringBuilder.append("<a href=\"");
                            YouTubeVideo cfr_ignored_1 = (YouTubeVideo)token;
                            stringBuilder.append(YouTubeVideo.getURL(((YouTubeVideo)token).getDocID()));
                            stringBuilder.append("\">");
                            stringBuilder.append(token.getRawText());
                            stringBuilder.append("</a>");
                            break;
                        }
                        case 7: {
                            stringBuilder.append("<a href=\"");
                            stringBuilder.append(Photo.getAlbumURL(((Photo)token).getUser(), ((Photo)token).getAlbum()));
                            stringBuilder.append("\">");
                            stringBuilder.append(token.getRawText());
                            stringBuilder.append("</a>");
                            break;
                        }
                        case 8: {
                            Photo cfr_ignored_2 = (Photo)token;
                            stringBuilder.append("<a href=\"");
                            stringBuilder.append(((FlickrPhoto)token).getUrl());
                            stringBuilder.append("\">");
                            stringBuilder.append(token.getRawText());
                            stringBuilder.append("</a>");
                        }
                    }
                }
                if (!token.controlCaps()) continue;
                bl = token.setCaps();
            }
            stringBuilder.append("</p>\n");
        }
        return stringBuilder.toString();
    }

    public static class Acronym
    extends Token {
        private String value;

        public Acronym(String string2, String string3) {
            super(Token.Type.ACRONYM, string2);
            this.value = string3;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(this.getRawText());
            list.add(this.getValue());
            return list;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class FlickrPhoto
    extends Token {
        private static final Pattern GROUPING_PATTERN;
        private static final String SETS = "sets";
        private static final String TAGS = "tags";
        private static final Pattern URL_PATTERN;
        private String grouping;
        private String groupingId;
        private String photo;
        private String user;

        static {
            URL_PATTERN = Pattern.compile("http://(?:www.)?flickr.com/photos/([^/?#&]+)/?([^/?#&]+)?/?.*");
            GROUPING_PATTERN = Pattern.compile("http://(?:www.)?flickr.com/photos/([^/?#&]+)/(tags|sets)/([^/?#&]+)/?");
        }

        /*
         * Enabled aggressive block sorting
         */
        public FlickrPhoto(String string2, String string3, String string4, String string5, String string6) {
            super(Token.Type.FLICKR, string6);
            if (TAGS.equals(string2)) {
                this.user = null;
                this.photo = null;
                this.grouping = TAGS;
                this.groupingId = string3;
                return;
            }
            this.user = string2;
            if ("show".equals(string3)) {
                string3 = null;
            }
            this.photo = string3;
            this.grouping = string4;
            this.groupingId = string5;
        }

        public static String getPhotoURL(String string2, String string3) {
            return "http://flickr.com/photos/" + string2 + "/" + string3;
        }

        public static String getRssUrl(String string2) {
            return null;
        }

        public static String getTagsURL(String string2) {
            return "http://flickr.com/photos/tags/" + string2;
        }

        public static String getUserSetsURL(String string2, String string3) {
            return "http://flickr.com/photos/" + string2 + "/sets/" + string3;
        }

        public static String getUserTagsURL(String string2, String string3) {
            return "http://flickr.com/photos/" + string2 + "/tags/" + string3;
        }

        public static String getUserURL(String string2) {
            return "http://flickr.com/photos/" + string2;
        }

        public static FlickrPhoto matchURL(String string2, String string3) {
            Matcher matcher = GROUPING_PATTERN.matcher(string2);
            if (matcher.matches()) {
                return new FlickrPhoto(matcher.group(1), null, matcher.group(2), matcher.group(3), string3);
            }
            Matcher matcher2 = URL_PATTERN.matcher(string2);
            if (matcher2.matches()) {
                return new FlickrPhoto(matcher2.group(1), matcher2.group(2), null, null, string3);
            }
            return null;
        }

        public String getGrouping() {
            return this.grouping;
        }

        public String getGroupingId() {
            return this.groupingId;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(this.getUrl());
            String string2 = this.getUser() != null ? this.getUser() : "";
            list.add(string2);
            String string3 = this.getPhoto() != null ? this.getPhoto() : "";
            list.add(string3);
            String string4 = this.getGrouping() != null ? this.getGrouping() : "";
            list.add(string4);
            String string5 = this.getGroupingId() != null ? this.getGroupingId() : "";
            list.add(string5);
            return list;
        }

        public String getPhoto() {
            return this.photo;
        }

        public String getUrl() {
            if (SETS.equals(this.grouping)) {
                return FlickrPhoto.getUserSetsURL(this.user, this.groupingId);
            }
            if (TAGS.equals(this.grouping)) {
                if (this.user != null) {
                    return FlickrPhoto.getUserTagsURL(this.user, this.groupingId);
                }
                return FlickrPhoto.getTagsURL(this.groupingId);
            }
            if (this.photo != null) {
                return FlickrPhoto.getPhotoURL(this.user, this.photo);
            }
            return FlickrPhoto.getUserURL(this.user);
        }

        public String getUser() {
            return this.user;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static class Format
    extends Token {
        private char ch;
        private boolean matched;
        private boolean start;

        public Format(char c, boolean bl) {
            super(Token.Type.FORMAT, String.valueOf(c));
            this.ch = c;
            this.start = bl;
        }

        private String getFormatEnd(char c) {
            switch (c) {
                default: {
                    throw new AssertionError((Object)("unknown format '" + c + "'"));
                }
                case '*': {
                    return "</b>";
                }
                case '_': {
                    return "</i>";
                }
                case '^': {
                    return "</font></b>";
                }
                case '\"': 
            }
            return "\u201d</font>";
        }

        private String getFormatStart(char c) {
            switch (c) {
                default: {
                    throw new AssertionError((Object)("unknown format '" + c + "'"));
                }
                case '*': {
                    return "<b>";
                }
                case '_': {
                    return "<i>";
                }
                case '^': {
                    return "<b><font color=\"#005FFF\">";
                }
                case '\"': 
            }
            return "<font color=\"#999999\">\u201c";
        }

        @Override
        public boolean controlCaps() {
            return this.ch == '^';
        }

        @Override
        public List<String> getInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHtml() {
            return true;
        }

        @Override
        public boolean setCaps() {
            return this.start;
        }

        public void setMatched(boolean bl) {
            this.matched = bl;
        }

        @Override
        public String toHtml(boolean bl) {
            if (this.matched) {
                if (this.start) {
                    return this.getFormatStart(this.ch);
                }
                return this.getFormatEnd(this.ch);
            }
            if (this.ch == '\"') {
                return "&quot;";
            }
            return String.valueOf(this.ch);
        }
    }

    public static class Html
    extends Token {
        private String html;

        public Html(String string2, String string3) {
            super(Token.Type.HTML, string2);
            this.html = string3;
        }

        private static String trimLeadingWhitespace(String string2) {
            int n;
            for (n = 0; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
            }
            return string2.substring(n);
        }

        public static String trimTrailingWhitespace(String string2) {
            int n;
            for (n = string2.length(); n > 0 && Character.isWhitespace(string2.charAt(n - 1)); --n) {
            }
            return string2.substring(0, n);
        }

        @Override
        public List<String> getInfo() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHtml() {
            return true;
        }

        @Override
        public String toHtml(boolean bl) {
            if (bl) {
                return this.html.toUpperCase();
            }
            return this.html;
        }

        public void trimLeadingWhitespace() {
            this.text = Html.trimLeadingWhitespace(this.text);
            this.html = Html.trimLeadingWhitespace(this.html);
        }

        public void trimTrailingWhitespace() {
            this.text = Html.trimTrailingWhitespace(this.text);
            this.html = Html.trimTrailingWhitespace(this.html);
        }
    }

    public static class Link
    extends Token {
        private String url;

        public Link(String string2, String string3) {
            super(Token.Type.LINK, string3);
            this.url = string2;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(this.getURL());
            list.add(this.getRawText());
            return list;
        }

        public String getURL() {
            return this.url;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class MusicTrack
    extends Token {
        private String track;

        public MusicTrack(String string2) {
            super(Token.Type.MUSIC, string2);
            this.track = string2;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(this.getTrack());
            return list;
        }

        public String getTrack() {
            return this.track;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static class Part {
        private String meText;
        private ArrayList<Token> tokens = new ArrayList();

        private String getPartType() {
            if (this.isMedia()) {
                return "d";
            }
            if (this.meText != null) {
                return "m";
            }
            return "";
        }

        public void add(Token token) {
            if (this.isMedia()) {
                throw new AssertionError((Object)"media ");
            }
            this.tokens.add(token);
        }

        public Token getMediaToken() {
            if (this.isMedia()) {
                return this.tokens.get(0);
            }
            return null;
        }

        public String getRawText() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.meText != null) {
                stringBuilder.append(this.meText);
            }
            for (int i = 0; i < this.tokens.size(); ++i) {
                stringBuilder.append(this.tokens.get(i).getRawText());
            }
            return stringBuilder.toString();
        }

        public ArrayList<Token> getTokens() {
            return this.tokens;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getType(boolean bl) {
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            if (bl) {
                string2 = "s";
                return stringBuilder.append(string2).append(this.getPartType()).toString();
            }
            string2 = "r";
            return stringBuilder.append(string2).append(this.getPartType()).toString();
        }

        public boolean isMedia() {
            return this.tokens.size() == 1 && this.tokens.get(0).isMedia();
        }

        public void setMeText(String string2) {
            this.meText = string2;
        }
    }

    public static class Photo
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("http://picasaweb.google.com/([^/?#&]+)/+((?!searchbrowse)[^/?#&]+)(?:/|/photo)?(?:\\?[^#]*)?(?:#(.*))?");
        private String album;
        private String photo;
        private String user;

        public Photo(String string2, String string3, String string4, String string5) {
            super(Token.Type.PHOTO, string5);
            this.user = string2;
            this.album = string3;
            this.photo = string4;
        }

        public static String getAlbumURL(String string2, String string3) {
            return "http://picasaweb.google.com/" + string2 + "/" + string3;
        }

        public static String getPhotoURL(String string2, String string3, String string4) {
            return "http://picasaweb.google.com/" + string2 + "/" + string3 + "/photo#" + string4;
        }

        public static String getRssUrl(String string2) {
            return "http://picasaweb.google.com/data/feed/api/user/" + string2 + "?category=album&alt=rss";
        }

        public static Photo matchURL(String string2, String string3) {
            Matcher matcher = URL_PATTERN.matcher(string2);
            if (matcher.matches()) {
                return new Photo(matcher.group(1), matcher.group(2), matcher.group(3), string3);
            }
            return null;
        }

        public String getAlbum() {
            return this.album;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(Photo.getRssUrl(this.getUser()));
            list.add(Photo.getAlbumURL(this.getUser(), this.getAlbum()));
            if (this.getPhoto() != null) {
                list.add(Photo.getPhotoURL(this.getUser(), this.getAlbum(), this.getPhoto()));
                return list;
            }
            list.add(null);
            return list;
        }

        public String getPhoto() {
            return this.photo;
        }

        public String getUser() {
            return this.user;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static interface Resources {
        public TrieNode getAcronyms();

        public TrieNode getDomainSuffixes();

        public Set<String> getSchemes();

        public TrieNode getSmileys();
    }

    public static class Smiley
    extends Token {
        public Smiley(String string2) {
            super(Token.Type.SMILEY, string2);
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(this.getRawText());
            return list;
        }

        @Override
        public boolean isHtml() {
            return false;
        }
    }

    public static abstract class Token {
        protected String text;
        protected Type type;

        protected Token(Type type, String string2) {
            this.type = type;
            this.text = string2;
        }

        public boolean controlCaps() {
            return false;
        }

        public List<String> getInfo() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.getType().toString());
            return arrayList;
        }

        public String getRawText() {
            return this.text;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isArray() {
            return !this.isHtml();
        }

        public abstract boolean isHtml();

        public boolean isMedia() {
            return false;
        }

        public boolean setCaps() {
            return false;
        }

        public String toHtml(boolean bl) {
            throw new AssertionError((Object)"not html");
        }

        public static final class Type
        extends Enum<Type> {
            private static final /* synthetic */ Type[] $VALUES;
            public static final /* enum */ Type ACRONYM;
            public static final /* enum */ Type FLICKR;
            public static final /* enum */ Type FORMAT;
            public static final /* enum */ Type GOOGLE_VIDEO;
            public static final /* enum */ Type HTML;
            public static final /* enum */ Type LINK;
            public static final /* enum */ Type MUSIC;
            public static final /* enum */ Type PHOTO;
            public static final /* enum */ Type SMILEY;
            public static final /* enum */ Type YOUTUBE_VIDEO;
            private String stringRep;

            static {
                HTML = new Type("html");
                FORMAT = new Type("format");
                LINK = new Type("l");
                SMILEY = new Type("e");
                ACRONYM = new Type("a");
                MUSIC = new Type("m");
                GOOGLE_VIDEO = new Type("v");
                YOUTUBE_VIDEO = new Type("yt");
                PHOTO = new Type("p");
                FLICKR = new Type("f");
                Type[] typeArray = new Type[]{HTML, FORMAT, LINK, SMILEY, ACRONYM, MUSIC, GOOGLE_VIDEO, YOUTUBE_VIDEO, PHOTO, FLICKR};
                $VALUES = typeArray;
            }

            private Type(String string3) {
                this.stringRep = string3;
            }

            public static Type valueOf(String string2) {
                return Enum.valueOf(Type.class, string2);
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public String toString() {
                return this.stringRep;
            }
        }
    }

    public static class TrieNode {
        private final HashMap<Character, TrieNode> children = new HashMap();
        private String text;
        private String value;

        public TrieNode() {
            this("");
        }

        public TrieNode(String string2) {
            this.text = string2;
        }

        public static void addToTrie(TrieNode trieNode, String string2, String string3) {
            int n = 0;
            while (n < string2.length()) {
                int n2 = n + 1;
                trieNode = trieNode.getOrCreateChild(string2.charAt(n));
                n = n2;
            }
            trieNode.setValue(string3);
        }

        public final boolean exists() {
            return this.value != null;
        }

        public TrieNode getChild(char c) {
            return this.children.get(Character.valueOf(c));
        }

        public TrieNode getOrCreateChild(char c) {
            Character c2 = Character.valueOf(c);
            TrieNode trieNode = this.children.get(c2);
            if (trieNode == null) {
                trieNode = new TrieNode(this.text + String.valueOf(c));
                this.children.put(c2, trieNode);
            }
            return trieNode;
        }

        public final String getText() {
            return this.text;
        }

        public final String getValue() {
            return this.value;
        }

        public void setValue(String string2) {
            this.value = string2;
        }
    }

    public static class Video
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("(?i)http://video\\.google\\.[a-z0-9]+(?:\\.[a-z0-9]+)?/videoplay\\?.*?\\bdocid=(-?\\d+).*");
        private String docid;

        public Video(String string2, String string3) {
            super(Token.Type.GOOGLE_VIDEO, string3);
            this.docid = string2;
        }

        public static String getRssUrl(String string2) {
            return "http://video.google.com/videofeed?type=docid&output=rss&sourceid=gtalk&docid=" + string2;
        }

        public static String getURL(String string2) {
            return Video.getURL(string2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static String getURL(String string2, String string3) {
            if (string3 == null) {
                string3 = "";
                return "http://video.google.com/videoplay?" + string3 + "docid=" + string2;
            }
            if (string3.length() <= 0) return "http://video.google.com/videoplay?" + string3 + "docid=" + string2;
            string3 = string3 + "&";
            return "http://video.google.com/videoplay?" + string3 + "docid=" + string2;
        }

        public static Video matchURL(String string2, String string3) {
            Matcher matcher = URL_PATTERN.matcher(string2);
            if (matcher.matches()) {
                return new Video(matcher.group(1), string3);
            }
            return null;
        }

        public String getDocID() {
            return this.docid;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(Video.getRssUrl(this.docid));
            list.add(Video.getURL(this.docid));
            return list;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }

    public static class YouTubeVideo
    extends Token {
        private static final Pattern URL_PATTERN = Pattern.compile("(?i)http://(?:[a-z0-9]+\\.)?youtube\\.[a-z0-9]+(?:\\.[a-z0-9]+)?/watch\\?.*\\bv=([-_a-zA-Z0-9=]+).*");
        private String docid;

        public YouTubeVideo(String string2, String string3) {
            super(Token.Type.YOUTUBE_VIDEO, string3);
            this.docid = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static String getPrefixedURL(boolean bl, String string2, String string3, String string4) {
            String string5 = "";
            if (bl) {
                string5 = "http://";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (string4 == null) {
                string4 = "";
                return string5 + string2 + "youtube.com/watch?" + string4 + "v=" + string3;
            }
            if (string4.length() <= 0) return string5 + string2 + "youtube.com/watch?" + string4 + "v=" + string3;
            string4 = string4 + "&";
            return string5 + string2 + "youtube.com/watch?" + string4 + "v=" + string3;
        }

        public static String getRssUrl(String string2) {
            return "http://youtube.com/watch?v=" + string2;
        }

        public static String getURL(String string2) {
            return YouTubeVideo.getURL(string2, null);
        }

        /*
         * Enabled aggressive block sorting
         */
        public static String getURL(String string2, String string3) {
            if (string3 == null) {
                string3 = "";
                return "http://youtube.com/watch?" + string3 + "v=" + string2;
            }
            if (string3.length() <= 0) return "http://youtube.com/watch?" + string3 + "v=" + string2;
            string3 = string3 + "&";
            return "http://youtube.com/watch?" + string3 + "v=" + string2;
        }

        public static YouTubeVideo matchURL(String string2, String string3) {
            Matcher matcher = URL_PATTERN.matcher(string2);
            if (matcher.matches()) {
                return new YouTubeVideo(matcher.group(1), string3);
            }
            return null;
        }

        public String getDocID() {
            return this.docid;
        }

        @Override
        public List<String> getInfo() {
            List<String> list = super.getInfo();
            list.add(YouTubeVideo.getRssUrl(this.docid));
            list.add(YouTubeVideo.getURL(this.docid));
            return list;
        }

        @Override
        public boolean isHtml() {
            return false;
        }

        @Override
        public boolean isMedia() {
            return true;
        }
    }
}

