/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.gui;

import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import de.upb.pga3.panda2.client.core.ResultLoader;
import de.upb.pga3.panda2.client.core.ResultStorer;
import de.upb.pga3.panda2.client.gui.GUIHelper;
import de.upb.pga3.panda2.client.gui.GUIView;
import de.upb.pga3.panda2.client.gui.GuiConfig;
import de.upb.pga3.panda2.client.gui.Model;
import de.upb.pga3.panda2.client.gui.Wizard;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import netscape.javascript.JSObject;

public class Controller {
    GUIView view;
    Model model;
    private final FileChooser chooserDialog;
    private static final String JS_DEV_PX_RATIO = "devicePixelRatio";
    private static final String JS_WINDOW = "window";

    Controller(GUIView view, Model model) {
        this.model = model;
        this.view = view;
        this.chooserDialog = new FileChooser();
        FileChooser.ExtensionFilter apkFilter = new FileChooser.ExtensionFilter("*.pa2 - Panda2 Analysis Result File", new String[]{"*.pa2"});
        FileChooser.ExtensionFilter allFilesFilter = new FileChooser.ExtensionFilter("*.* - All files", new String[]{"*.*"});
        this.chooserDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{apkFilter, allFilesFilter});
    }

    Model getModel() {
        return this.model;
    }

    GUIView getView() {
        return this.view;
    }

    public void newClicked() {
        if (Wizard.getInstance() == null) {
            Stage subStage = new Stage();
            subStage.initOwner((Window)this.getView().stage);
            subStage.initModality(Modality.WINDOW_MODAL);
            new Wizard(this.getModel()).start(subStage);
        } else {
            Wizard.getInstance().show();
        }
    }

    public void openClicked() {
        this.chooserDialog.setInitialDirectory(GuiConfig.getInstance().getOpenFolder());
        File file = this.chooserDialog.showOpenDialog((Window)this.getView().stage);
        if (file != null && file.getParentFile().exists()) {
            GuiConfig.getInstance().setOpenFolder(file.getParentFile());
            AnalysisResult loadedResult = ResultLoader.loadPreviousAnalysisResult(file.toString());
            this.getModel().lastSetup = new ArrayList<String>();
            this.getModel().lastSetup.add(AnalysisRegistry.getInstance().getName(loadedResult));
            ++this.getModel().loadedCounter;
            this.getModel().lastSetup.add("Loaded previous result (" + this.getModel().loadedCounter + ")");
            this.getModel().mapAnalysisResults.put(loadedResult, this.getModel().lastSetup);
            GUIView.log("Analysis result loaded");
            this.getView().loadAnalysisResult(loadedResult);
        }
    }

    public void saveClicked() {
        if (this.getModel().saveFile != null) {
            this.save();
        } else {
            this.saveAsClicked();
        }
    }

    public void saveAsClicked() {
        this.chooserDialog.setInitialDirectory(GuiConfig.getInstance().getSaveFolder());
        this.getModel().saveFile = this.chooserDialog.showSaveDialog((Window)this.getView().stage);
        if (this.getModel().saveFile != null) {
            GuiConfig.getInstance().setSaveFolder(this.getModel().saveFile.getParentFile());
            this.save();
        }
    }

    private void save() {
        if (this.getModel().saveFile != null) {
            if (this.getModel().saveFile.exists()) {
                Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
                GUIHelper.setPandaIcon(alertStage);
                alert.setTitle("Save");
                alert.setHeaderText("The file\n" + this.getModel().saveFile.getAbsolutePath() + "\nalready exists.");
                alert.setContentText("Overwrite it?");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    ResultStorer.storeResult(this.getModel().currentAnalysisResult, this.getModel().saveFile.toString());
                    this.getView();
                    GUIView.log("Result saved in file: " + this.getModel().saveFile);
                } else {
                    alert.hide();
                    this.getView().stage.show();
                }
            } else {
                ResultStorer.storeResult(this.getModel().currentAnalysisResult, this.getModel().saveFile.toString());
                this.getView();
                GUIView.log("Result saved in file: " + this.getModel().saveFile);
            }
        }
    }

    public void exitClicked() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        GUIHelper.setPandaIcon(alertStage);
        alert.setTitle("Exit");
        alert.setHeaderText("You will exit now.\nResults which are not saved will be discarded.");
        alert.setContentText("Proceed?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            Platform.exit();
        } else {
            alert.hide();
            this.getView().stage.show();
        }
    }

    public boolean removeFilter(String filter) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        GUIHelper.setPandaIcon(alertStage);
        alert.setTitle("Add filter");
        alert.setHeaderText(String.valueOf(filter) + " filter is already active.");
        alert.setContentText("Do you want to remove it instead?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            return true;
        }
        alert.hide();
        this.getView().stage.show();
        return false;
    }

    static double getDevPxRatio(WebEngine engine) {
        JSObject window = (JSObject)engine.executeScript(JS_WINDOW);
        return ((Number)window.getMember(JS_DEV_PX_RATIO)).doubleValue();
    }

    void zoomIn() {
        if (this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabTextual) {
            this.getModel().zoomTextual += 0.1;
            Controller.setZoom(this.getView().htmlTextual, this.getModel().initDevPxRatioTextual, this.getModel().zoomTextual);
        } else if (this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabGraphical) {
            this.getModel().zoomGrapical += 0.1;
            Controller.setZoom(this.getView().htmlGraphical, this.getModel().initDevPxRatioGraphical, this.getModel().zoomGrapical);
        }
    }

    void zoomOut() {
        if (this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabTextual) {
            this.getModel().zoomTextual -= 0.1;
            Controller.setZoom(this.getView().htmlTextual, this.getModel().initDevPxRatioTextual, this.getModel().zoomTextual);
        } else if (this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabGraphical) {
            this.getModel().zoomGrapical -= 0.1;
            Controller.setZoom(this.getView().htmlGraphical, this.getModel().initDevPxRatioGraphical, this.getModel().zoomGrapical);
        }
    }

    void zoomReset() {
        if (this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabTextual) {
            this.getModel().zoomTextual = 1.0;
            Controller.setZoom(this.getView().htmlTextual, this.getModel().initDevPxRatioTextual, this.getModel().zoomTextual);
        } else if (this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabGraphical) {
            this.getModel().zoomGrapical = 1.0;
            Controller.setZoom(this.getView().htmlGraphical, this.getModel().initDevPxRatioGraphical, this.getModel().zoomGrapical);
        }
    }

    private static void setZoom(WebView view, double initPxRatio, double zoom) {
        JSObject window = (JSObject)view.getEngine().executeScript(JS_WINDOW);
        window.setMember(JS_DEV_PX_RATIO, initPxRatio * zoom);
        view.setZoom(zoom);
    }

    public void loadMessages(int current) {
        this.getView().showNextMessages(current);
    }

    public void viewInBrowser(boolean generateFileFirst) {
        String content = this.getView().tabPane.getSelectionModel().getSelectedItem() == this.getView().tabTextual ? this.getView().htmlTextualStr : this.getView().htmlGraphicalStr;
        if (generateFileFirst) {
            try {
                Path tmp = Files.createTempFile("tmpResult", ".html", new FileAttribute[0]);
                Files.write(tmp, content.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
                content = tmp.toString();
            }
            catch (IOException e) {
                this.errorOpeningInBrowser();
                GUIView.LOGGER.debug("Write tmp file: {}", e.getMessage());
                return;
            }
        }
        this.getView().getHostServices().showDocument(content);
    }

    private void errorOpeningInBrowser() {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        GUIHelper.setPandaIcon(alertStage);
        alert.setTitle("Error");
        alert.setHeaderText("The Browser could not be accessed.");
        alert.showAndWait();
        alert.hide();
        this.getView().stage.show();
    }
}

