/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.client.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class GuiConfig
implements Serializable {
    private static final long serialVersionUID = -5891500918384508046L;
    private static final Logger LOGGER = LogManager.getLogger(GuiConfig.class);
    private static GuiConfig INSTANCE = new GuiConfig();
    private File openFolder = null;
    private File saveFolder = null;
    private File apkFolder = null;
    private File prevResultFolder = null;
    private File nnApkFolder = null;
    private final File configFile = new File("data/temp/guiconfig.cfg");

    public static GuiConfig getInstance() {
        return INSTANCE;
    }

    private GuiConfig() {
    }

    public void load() {
        try {
            if (this.configFile.exists()) {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.configFile));
                GuiConfig load = (GuiConfig)ois.readObject();
                ois.close();
                this.setOpenFolder(load.getOpenFolder());
                this.setSaveFolder(load.getSaveFolder());
                this.setApkFolder(load.getApkFolder());
                this.setPrevResultFolder(load.getPrevResultFolder());
                this.setNnApkFolder(load.getNnApkFolder());
            } else {
                this.configFile.createNewFile();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not access gui config file.");
        }
    }

    private void save() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.configFile));
            oos.writeObject(GuiConfig.getInstance());
            oos.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not access gui config file.");
        }
    }

    public File getOpenFolder() {
        return GuiConfig.checkIfExists(this.openFolder);
    }

    public void setOpenFolder(File openFolder) {
        this.openFolder = openFolder;
        this.save();
    }

    public File getSaveFolder() {
        return GuiConfig.checkIfExists(this.saveFolder);
    }

    public void setSaveFolder(File saveFolder) {
        this.saveFolder = saveFolder;
        this.save();
    }

    public File getApkFolder() {
        return GuiConfig.checkIfExists(this.apkFolder);
    }

    public void setApkFolder(File apkFolder) {
        this.apkFolder = apkFolder;
        this.save();
    }

    public File getPrevResultFolder() {
        return GuiConfig.checkIfExists(this.prevResultFolder);
    }

    public void setPrevResultFolder(File prevResultFolder) {
        this.prevResultFolder = prevResultFolder;
        this.save();
    }

    public File getNnApkFolder() {
        return GuiConfig.checkIfExists(this.nnApkFolder);
    }

    public void setNnApkFolder(File nnApkFolder) {
        this.nnApkFolder = nnApkFolder;
        this.save();
    }

    private static File checkIfExists(File file) {
        try {
            if (file.exists()) {
                return file;
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

