/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core;

import de.upb.pga3.panda2.core.services.ConfigManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.Scene;
import soot.SootMethod;
import soot.Transform;
import soot.options.Options;

public final class SootAdapter {
    private static final Logger LOGGER = LogManager.getLogger(SootAdapter.class);
    private PrintStream systemOut;
    private static SootAdapter instance;

    public static SootAdapter getInstance() {
        if (instance == null) {
            instance = new SootAdapter();
        }
        return instance;
    }

    private SootAdapter() {
    }

    public void setEntryPoint(SootMethod entryPoint) {
        Scene.v().setEntryPoints(Collections.singletonList(entryPoint));
        if (Scene.v().containsClass(entryPoint.getDeclaringClass().getName())) {
            Scene.v().removeClass(entryPoint.getDeclaringClass());
        }
        Scene.v().addClass(entryPoint.getDeclaringClass());
    }

    public void reinitSoot() {
        this.disableOutput();
        try {
            G.reset();
        }
        finally {
            this.enableOutput();
        }
    }

    public void init(Path apkFile) {
        this.disableOutput();
        try {
            Options.v().set_no_bodies_for_excluded(true);
            Options.v().set_allow_phantom_refs(true);
            Options.v().set_output_format(12);
            Options.v().set_whole_program(true);
            List<String> excludedPacks = ConfigManager.getInstance().getExcludedPackages();
            Options.v().set_exclude(excludedPacks);
            Options.v().set_process_dir(Collections.singletonList(apkFile.toString()));
            Options.v().set_force_android_jar(ConfigManager.getInstance().getAndroidJarPath());
            Options.v().set_src_prec(5);
            Main.v().autoSetOptions();
            Scene.v().loadNecessaryClasses();
        }
        finally {
            this.enableOutput();
        }
    }

    public void run(SootPhase phase) {
        if (phase == SootPhase.WJTP) {
            PackManager.v().getPack("wjpp").apply();
            PackManager.v().getPack("cg").apply();
            PackManager.v().getPack("wjtp").apply();
        } else if (phase == SootPhase.JTP) {
            PackManager.v().runPacks();
        } else {
            PackManager.v().runPacks();
        }
        LOGGER.info("Run " + phase.toString() + " phase");
    }

    public void addTransformer(Transform transformer, SootPhase phase) {
        if (phase == SootPhase.WJTP) {
            PackManager.v().getPack("wjtp").add(transformer);
        } else if (phase == SootPhase.JTP) {
            PackManager.v().getPack("jtp").add(transformer);
        } else {
            LOGGER.info("Not support this " + phase.toString() + " phase");
        }
    }

    private void disableOutput() {
        this.systemOut = System.out;
        System.setOut(new PrintStream(new OutputStream(){

            @Override
            public void write(int arg0) throws IOException {
            }
        }));
    }

    private void enableOutput() {
        System.setOut(this.systemOut);
    }

    public static enum SootPhase {
        WJTP,
        JTP;

    }
}

