/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.services.BinaryParser;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CertParser
extends BinaryParser {
    private static final Logger LOGGER = LogManager.getLogger(CertParser.class);
    private String mMD5Fingerprint;
    private String mSHA1Fingerprint;

    public CertParser(String inAPKFile) {
        super(inAPKFile);
    }

    @Override
    protected boolean parseData(String inAPKFile) {
        File f = new File(inAPKFile);
        this.mMD5Fingerprint = this.getSignaturFromAPL(f, "MD5");
        this.mSHA1Fingerprint = this.getSignaturFromAPL(f, "SHA1");
        return true;
    }

    public String getMd5Fingerprint() {
        return this.mMD5Fingerprint;
    }

    public String getSHA1FingerPrint() {
        return this.mSHA1Fingerprint;
    }

    private String getSignaturFromAPL(File apkFile, String inMode) {
        block6: {
            MessageDigest digest;
            String key = "";
            ZipFile file = new ZipFile(apkFile, 1);
            Enumeration<? extends ZipEntry> lstZipEntries = file.entries();
            boolean isRSAExisting = false;
            ZipEntry RSAZipEntry = new ZipEntry("");
            while (lstZipEntries.hasMoreElements()) {
                RSAZipEntry = lstZipEntries.nextElement();
                String RSAFileName = RSAZipEntry.getName();
                if (!RSAFileName.endsWith(".RSA")) continue;
                isRSAExisting = true;
                break;
            }
            if (!isRSAExisting) break block6;
            InputStream tream = file.getInputStream(RSAZipEntry);
            DataInputStream dis = new DataInputStream(tream);
            byte[] keyBytes = new byte[(int)RSAZipEntry.getSize()];
            dis.readFully(keyBytes);
            dis.close();
            try {
                digest = MessageDigest.getInstance(inMode);
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            try {
                byte[] buffer = new byte[8192];
                digest.update(keyBytes);
                byte[] md5sum = digest.digest();
                BigInteger bigInt = new BigInteger(1, md5sum);
                String output = bigInt.toString(16);
                output = String.format("%32s", output).replace(' ', '0');
                return output;
            }
            catch (Exception ex) {
                LOGGER.info("Exception: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return "";
    }
}

