/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.core.services;

import de.upb.pga3.panda2.core.services.LayoutBinaryParser;
import de.upb.pga3.panda2.core.services.XMLDocument;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class XMLHandler {
    public static final String ANDROID_NAMESPACE = "http://schemas.android.com/apk/res/android";
    protected byte[] xml;
    protected LayoutBinaryParser parser;

    public XMLHandler(InputStream xmlInput, LayoutBinaryParser parser) throws IOException {
        if (xmlInput == null) {
            throw new RuntimeException("NULL input stream for AXmlHandler");
        }
        BufferedInputStream buffer = new BufferedInputStream(xmlInput);
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int bytesRead = 0;
        while (xmlInput.available() > 0) {
            byte[] nextChunk = new byte[xmlInput.available()];
            int chunkSize = buffer.read(nextChunk);
            if (chunkSize < 0) break;
            chunks.add(nextChunk);
            bytesRead += chunkSize;
        }
        this.xml = new byte[bytesRead];
        int bytesCopied = 0;
        for (byte[] chunk : chunks) {
            int toCopy = Math.min(chunk.length, bytesRead - bytesCopied);
            System.arraycopy(chunk, 0, this.xml, bytesCopied, toCopy);
            bytesCopied += toCopy;
        }
        parser.parseFile(this.xml);
        this.parser = parser;
    }

    public XMLDocument getDocument() {
        return this.parser.getDocument();
    }
}

