/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension;

import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Input;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.GlobalVariable;
import de.upb.pga3.panda2.core.services.StatementAnalyzer;
import de.upb.pga3.panda2.core.services.XMLParser;
import de.upb.pga3.panda2.extension.PermissionMapper;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.Body;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class Enhancer {
    private static final Logger LOGGER = LogManager.getLogger(Enhancer.class);
    boolean librariesWarning = true;

    public Input enhance(Path apk) {
        SootClass c;
        SootClass[] classes;
        LOGGER.info("Enhancer started (" + apk.toString() + ")");
        SootAdapter.getInstance().init(apk);
        SootAdapter.getInstance().run(SootAdapter.SootPhase.WJTP);
        XMLParser xmlParser = CoreServices.getXMLParserInstance();
        xmlParser.fetchData(apk.toAbsolutePath().toString());
        String appName = xmlParser.getAppName();
        EnhancedInput ei = new EnhancedInput(appName, xmlParser.getManifestInformation());
        ei.setScene(Scene.v());
        PermissionMapper permMapper = new PermissionMapper(ei);
        boolean isAndroidComponent = false;
        StatementAnalyzer stmtAnalyzer = CoreServices.getStatementAnalyzerInstance();
        HashMap<String, GlobalVariable> mapGlobalVars = new HashMap<String, GlobalVariable>();
        SootClass[] sootClassArray = classes = ei.getAppClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            c = sootClassArray[n2];
            Enhancer.checkForComponent(ei, c, permMapper);
            ++n2;
        }
        sootClassArray = classes;
        n = classes.length;
        n2 = 0;
        while (n2 < n) {
            Body body;
            c = sootClassArray[n2];
            isAndroidComponent = ei.isAndroidComponent(c);
            List<SootMethod> methods = c.getMethods();
            if (isAndroidComponent) {
                for (SootMethod m : methods) {
                    try {
                        if (!Enhancer.isConstructor(m)) continue;
                        body = m.retrieveActiveBody();
                        stmtAnalyzer.extractGlobalVars(body, ei, mapGlobalVars);
                    }
                    catch (RuntimeException e) {
                        LOGGER.warn(e.getMessage());
                    }
                }
            }
            for (SootMethod m : methods) {
                try {
                    body = m.retrieveActiveBody();
                    PatchingChain<Unit> units = body.getUnits();
                    for (Unit u : units) {
                        ei.mapUnitToBody(u, body);
                        ei.mapUnitByStrToPkgStr(c.toString(), c.getJavaPackageName());
                        permMapper.mapPermissionsToStatement(u);
                    }
                    if (!isAndroidComponent) continue;
                    ei.addIntents(stmtAnalyzer.getAllIntents(body, ei, mapGlobalVars));
                }
                catch (RuntimeException e) {
                    if (e.getMessage().contains("No method source set for method")) {
                        if (!this.librariesWarning) continue;
                        this.librariesWarning = false;
                        LOGGER.warn("App contains external libraries. Library classes will be skipped.");
                        continue;
                    }
                    LOGGER.warn(e.getMessage());
                }
            }
            ++n2;
        }
        permMapper.mapPermissionsToApp();
        LOGGER.info("Enhancer finished (" + apk.toString() + ").");
        return ei;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkForComponent(EnhancedInput ei, SootClass c, PermissionMapper permMapper) {
        try {
            SootClass superClass = c.getSuperclass();
            while (true) {
                if (superClass == null) {
                    return false;
                }
                String superClassName = superClass.getName();
                if (superClassName.equals("android.app.Activity") || superClassName.equals("android.app.Service") || superClassName.equals("android.content.BroadcastReceiver") || superClassName.equals("android.content.ContentProvider")) {
                    HashSet<String> providerURLs;
                    if (superClassName.equals("android.content.ContentProvider")) {
                        providerURLs = new HashSet<String>(0);
                        providerURLs.add(CoreServices.getXMLParserInstance().getContentProviderURIs().get(c.getName()));
                    } else {
                        providerURLs = null;
                    }
                    ei.setAsAndroidComponent(c, providerURLs);
                    permMapper.mapPermissionsToComponent(c);
                    return true;
                }
                superClass = superClass.getSuperclass();
            }
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public Input collectResults(List<AnalysisResult> results) {
        LOGGER.info("Enhancer is collecting results for aggregation analysis.");
        return new ResultInput(results);
    }

    private static boolean isConstructor(SootMethod inSootMethod) {
        String signature;
        return inSootMethod != null && (signature = inSootMethod.getSignature()).contains(": void <init>");
    }
}

