/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.extension.lvl2a.HtmlTableBuilder;
import de.upb.pga3.panda2.extension.lvl2a.SVGGraphBuilder;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ClassElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.MethodElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.StatementElement;
import de.upb.pga3.panda2.utilities.HTMLFrameBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnalysisResultLvl2a
extends AnalysisResult {
    static final Logger LOGGER = LogManager.getLogger(AnalysisResultLvl2a.class);
    Map<ResourceElement, List<FlowPath>> mMapSources;
    Map<ResourceElement, List<FlowPath>> mMapSinks;
    Map<String, ResourceElement> mMapFilters = new TreeMap<String, ResourceElement>();

    public AnalysisResultLvl2a() {
        this.mMapSinks = new HashMap<ResourceElement, List<FlowPath>>();
        this.mMapSources = new HashMap<ResourceElement, List<FlowPath>>();
    }

    public boolean addPath(FlowPath inPath) {
        if (inPath != null && inPath.isComplete()) {
            List<FlowPath> lstFlowPaths = this.mMapSources.get(inPath.getSource());
            if (lstFlowPaths == null) {
                lstFlowPaths = new ArrayList<FlowPath>();
                lstFlowPaths.add(inPath);
                this.mMapSources.put(inPath.getSource(), lstFlowPaths);
            } else {
                lstFlowPaths.add(inPath);
            }
            List<FlowPath> lstFlowPaths2 = this.mMapSinks.get(inPath.getSink());
            if (lstFlowPaths2 == null) {
                lstFlowPaths2 = new ArrayList<FlowPath>();
                lstFlowPaths2.add(inPath);
                this.mMapSinks.put(inPath.getSink(), lstFlowPaths2);
            } else {
                lstFlowPaths2.add(inPath);
            }
            return true;
        }
        throw new IllegalArgumentException("The path to be added must not be null and must be complete!");
    }

    public List<FlowPath> getPathsForSource(ResourceElement srcPerm) {
        return this.mMapSources.get(srcPerm);
    }

    public List<FlowPath> getPathsForSink(ResourceElement sinkPerm) {
        return this.mMapSinks.get(sinkPerm);
    }

    public Set<FlowPath> getPaths() {
        Collection<List<FlowPath>> paths = this.mMapSources.values();
        HashSet<FlowPath> setFlowPaths = new HashSet<FlowPath>();
        for (List<FlowPath> lstFlowPaths : paths) {
            if (lstFlowPaths == null) continue;
            setFlowPaths.addAll(lstFlowPaths);
        }
        return setFlowPaths;
    }

    public void createFilters() {
        for (ResourceElement p : this.mMapSources.keySet()) {
            this.mMapFilters.put("Source:" + p.toString(), p);
        }
        for (ResourceElement p : this.mMapSinks.keySet()) {
            this.mMapFilters.put("Sink:" + p.toString(), p);
        }
    }

    public void addSources(Collection<ResourceElement> inSources) {
        if (inSources != null) {
            for (ResourceElement p : inSources) {
                if (this.mMapSources.containsKey(p)) continue;
                this.mMapSources.put(p, null);
            }
        }
    }

    public void addSinks(Collection<ResourceElement> inSinks) {
        if (inSinks != null) {
            for (ResourceElement p : inSinks) {
                if (this.mMapSinks.containsKey(p)) continue;
                this.mMapSinks.put(p, null);
            }
        }
    }

    private String createTextualResult(Collection<FlowPath> inPaths, DetailLevel inDetailLvl, boolean autoHideHeader) {
        StringBuilder sb = new StringBuilder();
        HTMLFrameBuilder fb = new HTMLFrameBuilder(sb, "Intra-App Information Flow Analysis");
        fb.setAppTrustworthy(inPaths.size() == 0);
        fb.addStaticticsRow("Number of source permission(s): ", "<font color=\"red\"><strong>" + this.mMapSources.size() + "</strong></font>");
        fb.addStaticticsRow("Number of sink permission(s): ", "<font color=\"blue\"><strong>" + this.mMapSinks.size() + "</strong></font>");
        fb.addStaticticsRow("Number of distinguish path(s): ", "<strong>" + inPaths.size() + "</strong>");
        fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff0000;\"></div>", "SOURCE PERMISSION");
        fb.addLegendEntry("<div class=\"icon\" style=\"background:#0006fd;\"></div>", "SINK PERMISSION");
        fb.setHeaderAutoHide(autoHideHeader);
        fb.setHintPersistent(false);
        fb.setCustomStyle(HtmlTableBuilder.cssStyle);
        HtmlTableBuilder tableBuilder = new HtmlTableBuilder(false, this.getAppName());
        tableBuilder.processResult(inPaths, inDetailLvl);
        try {
            fb.append(tableBuilder.toString());
            fb.complete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private String createGraphicalResult(Collection<FlowPath> inPaths, DetailLevelLvl2a inDetailLvl, boolean autoHideHeader) {
        StringBuilder sb = new StringBuilder();
        HTMLFrameBuilder fb = new HTMLFrameBuilder(sb, "Intra-App Information Flow Analysis");
        fb.setAppTrustworthy(this.mMapSources.size() == 0);
        fb.addStaticticsRow("Number of source permission(s): ", "<strong>" + this.mMapSources.size() + "</strong>");
        fb.addStaticticsRow("Number of sink permission(s): ", "<strong>" + this.mMapSinks.size() + "</strong>");
        fb.addStaticticsRow("Number of distinguish path(s): ", "<strong>" + inPaths.size() + "</strong>");
        AnalysisResultLvl2a.createLegend(inDetailLvl, fb);
        fb.addLegendEntry("<div style=\"background:#203A57;\"></div>", "Information Flow Edge");
        fb.setHeaderAutoHide(autoHideHeader);
        fb.setHintPersistent(false);
        fb.setCustomStyle("svg {font-size: 80%;} svg g.edge > path {stroke-width: .3em;transition: .2s ease-in-out;} svg g.cluster > text, svg g.node > text {fill: white;stroke: black;stroke-width: .015em;font-weight: bold;} svg g.edge > text {transition: .2s ease-in-out;} svg g.edge.highlighted > polygon, svg g.edge.highlighted > path {stroke-width: .4em;stroke: #F09514;filter: url(#drop-shadow);} svg g.edge.highlighted > text {fill: #F09514;filter: url(#drop-shadow);} ");
        fb.setCustomScript("var edges;function stylePath(edge) {var edgeText = edge.parentNode.getElementsByTagName('text')[0];var pathIdx = edgeText.innerHTML;var newPathIdx;for (i = 0; i < edges.length; i++) {edgeText = edges[i].parentNode.getElementsByTagName('text')[0];newPathIdx = edgeText.innerHTML;if(newPathIdx===pathIdx) {edges[i].parentNode.classList.toggle('highlighted');} } } function edgeClicked(event) {stylePath(event.target);} function setMousePathListener() {edges = document.querySelectorAll('svg g.edge > path');console.log('Found edges: '+edges.length);for (i = 0; i < edges.length; i++) {edges[i].addEventListener('click', edgeClicked, false);} } window.addEventListener('DOMContentLoaded', setMousePathListener, false);");
        SVGGraphBuilder builder = new SVGGraphBuilder();
        for (FlowPath path : inPaths) {
            builder.addPath(path, "#203A57");
        }
        try {
            fb.append("<svg height=\"0\" width=\"0\" xmlns=\"http://www.w3.org/2000/svg\"><filter id=\"drop-shadow\"><feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"2.2\"/><feOffset dx=\"0\" dy=\"0\" result=\"offsetblur\"/><feFlood flood-color=\"white\"/><feComposite in2=\"offsetblur\" operator=\"in\"/><feMerge><feMergeNode/><feMergeNode in=\"SourceGraphic\"/></feMerge></filter></svg>");
            fb.append(builder.buildGraph());
            fb.complete();
        }
        catch (IOException e) {
            LOGGER.error("Error when creating graphical result: {}", e.getMessage());
            LOGGER.debug(e);
        }
        return sb.toString();
    }

    static void createLegend(DetailLevelLvl2a inDetailLvl, HTMLFrameBuilder fb) {
        fb.addLegendEntry("<div style=\"background:#EDC010;\"></div>", "Resource");
        if (inDetailLvl.compareTo(DetailLevelLvl2a.COMPONENT) >= 0) {
            fb.addLegendEntry("<div style=\"background:#2691DE;\"></div>", "Class");
        }
        if (inDetailLvl.compareTo(DetailLevelLvl2a.METHOD) >= 0) {
            fb.addLegendEntry("<div style=\"background:#1E77BF;\"></div>", "Method");
        }
        if (inDetailLvl.compareTo(DetailLevelLvl2a.STATEMENT) >= 0) {
            fb.addLegendEntry("<div style=\"background:#0766B7;\"></div>", "Statement");
        }
        if (inDetailLvl.equals(DetailLevelLvl2a.METHOD)) {
            fb.addLegendEntry("<svg viewBox=\"0 0 100 100\"><circle style=\"fill:#000000;stroke:none\" cx=\"50\" cy=\"50\" r=\"50\" /></svg>", "Class node");
        } else if (inDetailLvl.equals(DetailLevelLvl2a.STATEMENT)) {
            fb.addLegendEntry("<svg viewBox=\"0 0 100 100\"><circle style=\"fill:#000000;stroke:none\" cx=\"50\" cy=\"50\" r=\"50\" /></svg>", "Class/method node");
        }
    }

    @Override
    public String getGraphicalResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        Collection<FlowPath> pathsForRep = this.preprocess(inDetailLvl, inFilters);
        return this.createGraphicalResult(pathsForRep, (DetailLevelLvl2a)inDetailLvl, inShowStats);
    }

    private Collection<FlowPath> preprocess(DetailLevel inDetailLvl, List<String> inFilters) {
        RepresentationPreprocessor rp;
        if (inDetailLvl == null || !(inDetailLvl instanceof DetailLevelLvl2a)) {
            LOGGER.warn("No detail level is specified. Use default!");
            rp = new RepresentationPreprocessor(this.mMapSources, this.mMapSinks, this.mMapFilters, inFilters, DetailLevelLvl2a.RES_TO_RES);
        } else {
            rp = new RepresentationPreprocessor(this.mMapSources, this.mMapSinks, this.mMapFilters, inFilters, (DetailLevelLvl2a)inDetailLvl);
        }
        return rp.preprocess();
    }

    @Override
    public String getTextualResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        Collection<FlowPath> pathsForRep = this.preprocess(inDetailLvl, inFilters);
        return this.createTextualResult(pathsForRep, inDetailLvl, inShowStats);
    }

    @Override
    public List<DetailLevel> getDetailLevels() {
        ArrayList<DetailLevel> levels = new ArrayList<DetailLevel>(DetailLevelLvl2a.values().length);
        levels.addAll(Arrays.asList(DetailLevelLvl2a.values()));
        return levels;
    }

    @Override
    public List<String> getFilters() {
        ArrayList<String> filters = new ArrayList<String>();
        filters.addAll(this.mMapFilters.keySet());
        return filters;
    }

    public static enum DetailLevelLvl2a implements DetailLevel
    {
        RES_TO_RES,
        COMPONENT,
        METHOD,
        STATEMENT;

    }

    static class RepresentationPreprocessor {
        private final List<String> mFilters;
        private final DetailLevelLvl2a mDetailLvl;
        private final Map<ResourceElement, List<FlowPath>> mMapSources;
        private final Map<ResourceElement, List<FlowPath>> mMapSinks;
        private final Map<String, ResourceElement> mMapFilters;

        RepresentationPreprocessor(Map<ResourceElement, List<FlowPath>> mapSources, Map<ResourceElement, List<FlowPath>> mapSinks, Map<String, ResourceElement> mapFilters, List<String> filters, DetailLevelLvl2a detailLvl) {
            this.mMapSources = mapSources;
            this.mMapSinks = mapSinks;
            this.mMapFilters = mapFilters;
            this.mFilters = filters;
            this.mDetailLvl = detailLvl;
        }

        Collection<FlowPath> preprocess() {
            Collection<FlowPath> filteredPaths = this.filterPaths();
            LOGGER.debug("Selected {} paths after applying filters", filteredPaths.size());
            LinkedHashSet<FlowPath> preprocessedPaths = new LinkedHashSet<FlowPath>(filteredPaths.size());
            for (FlowPath p : filteredPaths) {
                preprocessedPaths.add(this.fitToDetailLvl(p));
            }
            LOGGER.debug("Selected {} paths after applying detail level {}", preprocessedPaths.size(), this.mDetailLvl.name());
            return preprocessedPaths;
        }

        private Collection<FlowPath> filterPaths() {
            if (this.mFilters == null || this.mFilters.isEmpty() || this.mMapFilters.keySet().equals(new HashSet<String>(this.mFilters))) {
                LinkedHashSet<FlowPath> setFlowPaths = new LinkedHashSet<FlowPath>();
                Collection<List<FlowPath>> colLstFlowPaths = this.mMapSinks.values();
                for (List<FlowPath> lstFlowPaths : colLstFlowPaths) {
                    if (lstFlowPaths == null) continue;
                    setFlowPaths.addAll(lstFlowPaths);
                }
                return setFlowPaths;
            }
            ResourceElement perm = null;
            LinkedHashSet setFlowPaths = new LinkedHashSet();
            for (String filPerm : this.mFilters) {
                perm = this.mMapFilters.get(filPerm);
                if (perm != null) {
                    if (filPerm.startsWith("Sink:")) {
                        setFlowPaths.addAll(this.mMapSinks.get(perm));
                        continue;
                    }
                    if (filPerm.startsWith("Source:")) {
                        setFlowPaths.addAll(this.mMapSources.get(perm));
                        continue;
                    }
                    LOGGER.warn("Filter string '{}' is invalid! Skipping...", filPerm);
                    continue;
                }
                LOGGER.warn("Filter string '{}' is invalid! Skipping...", filPerm);
            }
            return new ArrayList<FlowPath>(setFlowPaths);
        }

        private FlowPath fitToDetailLvl(FlowPath path) {
            if (this.mDetailLvl == null || this.mDetailLvl.equals(DetailLevelLvl2a.STATEMENT)) {
                return path;
            }
            if (this.mDetailLvl.equals(DetailLevelLvl2a.RES_TO_RES)) {
                FlowPath newPath = new FlowPath();
                newPath.addElement(path.getSource());
                newPath.addElement(path.getSink());
                return newPath;
            }
            FlowPath newPath = new FlowPath();
            PathElement ele1 = this.convertToLvl(path.getElement(0));
            newPath.addElement(ele1);
            int i = 1;
            while (i < path.getLength()) {
                PathElement ele2 = this.convertToLvl(path.getElement(i));
                if (ele2 != null && !ele2.equals(ele1)) {
                    newPath.addElement(ele2);
                    ele1 = ele2;
                }
                ++i;
            }
            return newPath;
        }

        private PathElement convertToLvl(PathElement ele) {
            if (this.mDetailLvl.equals(DetailLevelLvl2a.COMPONENT)) {
                return RepresentationPreprocessor.convertToLvlComponent(ele);
            }
            if (this.mDetailLvl.equals(DetailLevelLvl2a.METHOD)) {
                return RepresentationPreprocessor.convertToLvlMethod(ele);
            }
            return ele;
        }

        private static PathElement convertToLvlMethod(PathElement ele) {
            if (ele instanceof ResourceElement || ele instanceof ClassElement || ele instanceof MethodElement) {
                return ele;
            }
            if (ele instanceof StatementElement) {
                return ((StatementElement)ele).getMethodElement();
            }
            throw new IllegalArgumentException("Did not expect vertex of type " + ele.getClass());
        }

        private static PathElement convertToLvlComponent(PathElement ele) {
            if (ele instanceof ResourceElement) {
                return ele;
            }
            if (ele instanceof ClassElement) {
                if (((ClassElement)ele).isAndroidComponent()) {
                    return ele;
                }
                return null;
            }
            if (ele instanceof MethodElement) {
                return RepresentationPreprocessor.convertToLvlComponent(((MethodElement)ele).getClassElement());
            }
            if (ele instanceof StatementElement) {
                return RepresentationPreprocessor.convertToLvlComponent(((StatementElement)ele).getMethodElement());
            }
            throw new IllegalArgumentException("Did not expect vertex of type " + ele.getClass());
        }
    }
}

