/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a;

import com.mxgraph.canvas.mxICanvas;
import com.mxgraph.canvas.mxSvgCanvas;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.layout.mxOrganicLayout;
import com.mxgraph.model.mxCell;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxXmlUtils;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import de.upb.pga3.panda2.extension.lvl2a.GroupedLayout;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ClassElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.MethodElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.StatementElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import soot.toolkits.scalar.Pair;

public class SVGGraphBuilder {
    private static final Logger LOGGER = LogManager.getLogger(SVGGraphBuilder.class);
    private static final String GRAPH_STYLE_NAME = "GRAPH_STYLE";
    public static final String CLASS_COLOR = "#2691DE";
    public static final String METHOD_COLOR = "#1E77BF";
    public static final String STATEMENT_COLOR = "#0766B7";
    public static final String RESOURCE_COLOR = "#EDC010";
    public static final String DEF_PATH_COLOR = "#203A57";
    public static final String NEW_PATH_COLOR = "#21C87B";
    public static final String REMOVED_PATH_COLOR = "#E04741";
    public static final String HIGHLIGHTED_PATH_COLOR = "#F09514";
    private static final double SVG_GRAPH_EXTENSION = 50.0;
    private static final String PATH_HIGHLIGHTED_CLASS = "highlighted";
    public static final String GRAPH_STYLE = "svg {font-size: 80%;} svg g.edge > path {stroke-width: .3em;transition: .2s ease-in-out;} svg g.cluster > text, svg g.node > text {fill: white;stroke: black;stroke-width: .015em;font-weight: bold;} svg g.edge > text {transition: .2s ease-in-out;} svg g.edge.highlighted > polygon, svg g.edge.highlighted > path {stroke-width: .4em;stroke: #F09514;filter: url(#drop-shadow);} svg g.edge.highlighted > text {fill: #F09514;filter: url(#drop-shadow);} ";
    public static final String GRAPH_SCRIPT = "var edges;function stylePath(edge) {var edgeText = edge.parentNode.getElementsByTagName('text')[0];var pathIdx = edgeText.innerHTML;var newPathIdx;for (i = 0; i < edges.length; i++) {edgeText = edges[i].parentNode.getElementsByTagName('text')[0];newPathIdx = edgeText.innerHTML;if(newPathIdx===pathIdx) {edges[i].parentNode.classList.toggle('highlighted');} } } function edgeClicked(event) {stylePath(event.target);} function setMousePathListener() {edges = document.querySelectorAll('svg g.edge > path');console.log('Found edges: '+edges.length);for (i = 0; i < edges.length; i++) {edges[i].addEventListener('click', edgeClicked, false);} } window.addEventListener('DOMContentLoaded', setMousePathListener, false);";
    public static final String SVG_FILTER = "<svg height=\"0\" width=\"0\" xmlns=\"http://www.w3.org/2000/svg\"><filter id=\"drop-shadow\"><feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"2.2\"/><feOffset dx=\"0\" dy=\"0\" result=\"offsetblur\"/><feFlood flood-color=\"white\"/><feComposite in2=\"offsetblur\" operator=\"in\"/><feMerge><feMergeNode/><feMergeNode in=\"SourceGraphic\"/></feMerge></filter></svg>";
    public static final String LEGEND_ICON_CIRCLE = "<svg viewBox=\"0 0 100 100\"><circle style=\"fill:#000000;stroke:none\" cx=\"50\" cy=\"50\" r=\"50\" /></svg>";
    private final Map<PathElement, Object> mVertexMap = new HashMap<PathElement, Object>();
    private final Set<Pair<FlowPath, String>> mPaths = new HashSet<Pair<FlowPath, String>>();
    private int mPathIndex = 1;

    public void addPath(FlowPath p, String color) {
        if (p == null) {
            throw new IllegalArgumentException("FlowPath p must not be null!");
        }
        if (color == null) {
            throw new IllegalArgumentException("color must not be null!");
        }
        boolean added = this.mPaths.add(new Pair<FlowPath, String>(p, color));
        if (!added) {
            LOGGER.trace("Path already extists in SVGGraphBuilder: {}", p.toString());
        }
    }

    private void addPathToGraph(mxGraph graph, Pair<FlowPath, String> path) {
        FlowPath p = path.getO1();
        if (p.getLength() == 0) {
            throw new IllegalArgumentException("Path must not be empty!");
        }
        Object v1 = this.getVertex(graph, p.getElement(0));
        int i = 1;
        while (i < p.getLength()) {
            Object v2 = this.getVertex(graph, p.getElement(i));
            SVGGraphBuilder.insertEdge(graph, v1, v2, path.getO2(), this.mPathIndex);
            v1 = v2;
            ++i;
        }
        ++this.mPathIndex;
    }

    public String buildGraph() {
        mxGraph graph = SVGGraphBuilder.initGraph();
        graph.getModel().beginUpdate();
        for (Pair<FlowPath, String> ePath : this.mPaths) {
            this.addPathToGraph(graph, ePath);
        }
        graph.getModel().endUpdate();
        LOGGER.debug("Building SVG graph containing {} paths", this.mPathIndex - 1);
        String svgGraph = null;
        try {
            svgGraph = SVGGraphBuilder.buildGraphWithGraphviz(graph);
        }
        catch (Exception e) {
            LOGGER.debug("Could not use Graphviz for rendering ({}), using JGraphX as fallback", e.getMessage());
            svgGraph = SVGGraphBuilder.buildGraphWithJGraphX(graph);
        }
        return svgGraph;
    }

    private static String buildGraphWithGraphviz(mxGraph graph) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        String svgGraph = null;
        Process p = null;
        try {
            BufferedReader br;
            p = rt.exec(new String[]{"dot", "-Tsvg"});
            LOGGER.debug("Found valid Graphviz installation");
            Throwable throwable = null;
            Object var5_8 = null;
            try (OutputStreamWriter stdin = new OutputStreamWriter(p.getOutputStream());){
                SVGGraphBuilder.createDotLangGraph(stdin, graph);
                ((Writer)stdin).append("\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            LOGGER.debug("Provided DotLang String to Graphviz");
            throwable = null;
            var5_8 = null;
            try {
                br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                try {
                    svgGraph = ((Stream)br.lines().parallel()).filter(s -> s.matches("^(?!<polygon\\s.*stroke=\"none\")(<\\/?svg\\W|<\\/?g\\W|<polygon|<ellipse|<text|<path|\\sviewBox).*$")).map(s -> s.replaceFirst("(\\sfont-family=\".*\"\\sfont-size=\".*\\d\"|<title>.*<\\/title>)", "").intern()).collect(Collectors.joining("\n"));
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            throwable = null;
            var5_8 = null;
            try {
                br = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                try {
                    String err = br.lines().collect(Collectors.joining("\n"));
                    if (!err.equals("")) {
                        LOGGER.debug("Error occured when using Graphviz: {}", err);
                        throw new RuntimeException("Graphviz terminated with errors");
                    }
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            LOGGER.debug("Fetched SVG String from Graphviz");
        }
        finally {
            if (p != null) {
                p.destroy();
            }
        }
        return svgGraph;
    }

    private static void createDotLangGraph(Appendable ap, mxGraph graph) throws IOException {
        Map style;
        String id;
        mxCell cell;
        HashSet<String> subgraphs = new HashSet<String>();
        LinkedList<Object> allNodes = new LinkedList<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        Object[] nodeSet = graph.getChildVertices(graph.getDefaultParent());
        stack.addAll(Arrays.asList(nodeSet));
        allNodes.addAll(Arrays.asList(nodeSet));
        ap.append("digraph G {");
        ap.append(" compound=true;");
        ap.append(" style=filled;");
        ap.append(" node [style=filled,shape=box];");
        while (!stack.isEmpty()) {
            cell = (mxCell)stack.getLast();
            id = cell.getId();
            if (subgraphs.contains(id)) {
                stack.removeLast();
                ap.append(" }");
                continue;
            }
            style = graph.getCellStyle((Object)cell);
            nodeSet = graph.getChildVertices((Object)cell);
            if (nodeSet.length == 0) {
                ap.append(" ").append(id).append(" [label=<").append(SVGGraphBuilder.makeHTML(graph.getLabel((Object)cell))).append(">,color=\"").append(style.get(mxConstants.STYLE_FILLCOLOR).toString()).append("\"];");
                stack.removeLast();
                continue;
            }
            stack.addAll(Arrays.asList(nodeSet));
            allNodes.addAll(Arrays.asList(nodeSet));
            subgraphs.add(id);
            String label = SVGGraphBuilder.makeHTML(graph.getLabel((Object)cell));
            ap.append(" subgraph cluster_").append(id).append(" {");
            ap.append(" label=<").append(label).append(">;");
            ap.append(" color=\"").append(style.get(mxConstants.STYLE_FILLCOLOR).toString()).append("\";");
            ap.append("\"").append(id).append("_0\" [style=filled,shape=circle,fixedsize=true,width=.25,color=black,label=<>];");
        }
        for (Object e : allNodes) {
            Object[] edgeSet = graph.getEdges(e, null, false, true, true);
            id = ((mxCell)e).getId();
            Object[] objectArray = edgeSet;
            int n = edgeSet.length;
            int n2 = 0;
            while (n2 < n) {
                Object edge = objectArray[n2];
                cell = (mxCell)graph.getOpposites(new Object[]{edge}, e)[0];
                String tarId = cell.getId();
                style = graph.getCellStyle(edge);
                ap.append(" ");
                if (subgraphs.contains(id)) {
                    ap.append("\"").append(id).append("_0\"");
                } else {
                    ap.append(id);
                }
                ap.append(" -> ");
                if (subgraphs.contains(tarId)) {
                    ap.append("\"").append(tarId).append("_0\"");
                } else {
                    ap.append(tarId);
                }
                ap.append(" [color=\"").append(style.get(mxConstants.STYLE_STROKECOLOR).toString()).append("\",label=<").append(SVGGraphBuilder.makeHTML(graph.getLabel(edge))).append(">");
                ap.append("];");
                ++n2;
            }
        }
        ap.append(" }");
    }

    private static String makeHTML(String str) {
        return str.replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static String buildGraphWithJGraphX(mxGraph graph) {
        mxOrganicLayout ol = new mxOrganicLayout(graph);
        GroupedLayout layout = new GroupedLayout((mxGraphLayout)ol);
        layout.execute(graph.getDefaultParent());
        return SVGGraphBuilder.graphToSVG(graph);
    }

    private static String graphToSVG(mxGraph graph) {
        Document svgDoc = null;
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = f.newDocumentBuilder();
            svgDoc = builder.newDocument();
            Element rootElement = svgDoc.createElement("svg");
            svgDoc.appendChild(rootElement);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Error when creating SVG document: " + e.getMessage());
        }
        mxSvgCanvas canvas = new mxSvgCanvas(svgDoc);
        graph.drawGraph((mxICanvas)canvas);
        String svg = mxXmlUtils.getXml((Node)canvas.getDocument());
        mxRectangle graphSize = graph.getGraphBounds();
        svg = svg.replaceFirst("<svg>", "<svg height=\"" + (int)Math.ceil(graphSize.getHeight() + 50.0) + "\" width=\"" + (int)Math.ceil(graphSize.getWidth() + 50.0) + "\">");
        return svg;
    }

    private static mxGraph initGraph() {
        mxGraph graph = new mxGraph();
        graph.setExtendParentsOnAdd(true);
        graph.setAllowDanglingEdges(false);
        graph.setAllowLoops(true);
        graph.setAutoSizeCells(true);
        mxStylesheet stylesheet = graph.getStylesheet();
        Hashtable<String, Object> style = new Hashtable<String, Object>();
        style.put(mxConstants.STYLE_SHAPE, "rectangle");
        style.put(mxConstants.STYLE_STROKEWIDTH, 2);
        style.put(mxConstants.STYLE_FONTCOLOR, "black");
        stylesheet.putCellStyle(GRAPH_STYLE_NAME, style);
        return graph;
    }

    private Object getVertex(mxGraph graph, PathElement codeElement) {
        Object vertex;
        if (this.mVertexMap.containsKey(codeElement)) {
            vertex = this.mVertexMap.get(codeElement);
        } else if (codeElement instanceof ResourceElement) {
            ResourceElement p = (ResourceElement)codeElement;
            vertex = SVGGraphBuilder.insertVertex(graph, p.getPermissionName(), graph.getDefaultParent(), RESOURCE_COLOR);
            this.mVertexMap.put(p, vertex);
        } else if (codeElement instanceof ClassElement) {
            ClassElement c = (ClassElement)codeElement;
            vertex = SVGGraphBuilder.insertVertex(graph, c.getClassName(), graph.getDefaultParent(), CLASS_COLOR);
            this.mVertexMap.put(c, vertex);
        } else if (codeElement instanceof MethodElement) {
            MethodElement m = (MethodElement)codeElement;
            Object newParent = this.getVertex(graph, m.getClassElement());
            vertex = SVGGraphBuilder.insertVertex(graph, m.getMethodSubSignature(), newParent, METHOD_COLOR);
            this.mVertexMap.put(m, vertex);
        } else if (codeElement instanceof StatementElement) {
            StatementElement u = (StatementElement)codeElement;
            Object newParent = this.getVertex(graph, u.getMethodElement());
            vertex = SVGGraphBuilder.insertVertex(graph, u.getStatementString(), newParent, STATEMENT_COLOR);
            this.mVertexMap.put(u, vertex);
        } else {
            throw new IllegalArgumentException("Did not expect vertex of type " + codeElement.getClass());
        }
        return vertex;
    }

    private static Object insertVertex(mxGraph graph, String label, Object parent, String color) {
        return graph.insertVertex(parent, null, (Object)label, 0.0, 0.0, 0.0, 0.0, "GRAPH_STYLE;" + mxConstants.STYLE_FILLCOLOR + "=" + color);
    }

    private static Object insertEdge(mxGraph graph, Object from, Object to, String color, int index) {
        return graph.insertEdge(graph.getDefaultParent(), null, (Object)index, from, to, "GRAPH_STYLE;" + mxConstants.STYLE_STROKECOLOR + "=" + color);
    }
}

