/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.analyzer;

import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisGraphLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.ParamType;
import de.upb.pga3.panda2.extension.lvl2a.ParameterNode;
import de.upb.pga3.panda2.extension.lvl2a.TransitionLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.TransitionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.Unit;

public class BackwardSlicer {
    private static final Logger LOGGER = LogManager.getLogger(BackwardSlicer.class);

    public Map<Permission, List<Unit>> slice(AnalysisGraphLvl2a inGraph, Unit inSink, Map<Permission, List<Unit>> inMapSources) {
        ArrayList<Object> lstParams;
        if (inGraph == null) {
            LOGGER.error("Cannot find the input graph.");
            return null;
        }
        if (inSink == null) {
            LOGGER.error("The slicing criterion is null.");
            return null;
        }
        if (inMapSources == null) {
            LOGGER.error("The list of sources is invalid");
            return null;
        }
        Integer iSizeFoundSources = 0;
        int iSizeMapSources = 0;
        boolean isFullSource = false;
        Collection<List<Unit>> colLstUnits = inMapSources.values();
        for (List<Unit> lstUnits : colLstUnits) {
            iSizeMapSources += lstUnits.size();
        }
        HashMap<Permission, List<Unit>> mapResults = new HashMap<Permission, List<Unit>>();
        ArrayList<Object> checkedObject = new ArrayList<Object>();
        Set<Transition> setTransitions = inGraph.getIncomingTransitions(inSink);
        List<Object> preDecessors = this.filterPredecessor(setTransitions, lstParams = new ArrayList<Object>(), true);
        isFullSource = this.processGraph(inMapSources, mapResults, inGraph, preDecessors, true, checkedObject, iSizeFoundSources, iSizeMapSources, lstParams);
        if (!isFullSource) {
            this.processGraph(inMapSources, mapResults, inGraph, lstParams, false, checkedObject, iSizeFoundSources, iSizeMapSources, lstParams);
        }
        return mapResults;
    }

    private boolean processGraph(Map<Permission, List<Unit>> inMapSources, Map<Permission, List<Unit>> mapResults, AnalysisGraphLvl2a inGraph, List<Object> inLstObjs, boolean isFirstStep, List<Object> checkedObject, Integer iSizeFoundSources, int iSizeMapSources, List<Object> lstParams) {
        boolean isFullSources = false;
        while (inLstObjs != null && !inLstObjs.isEmpty()) {
            Object obj1 = inLstObjs.get(0);
            inLstObjs.remove(0);
            if (checkedObject.contains(obj1)) continue;
            checkedObject.add(obj1);
            if (obj1 instanceof Unit) {
                Unit usource = (Unit)obj1;
                boolean isFound = this.processPermission(usource, inMapSources, mapResults);
                if (isFound) {
                    iSizeFoundSources = iSizeFoundSources + 1;
                }
                if (iSizeFoundSources == iSizeMapSources) {
                    isFullSources = true;
                    break;
                }
            }
            this.collectPredecessor(inGraph, inLstObjs, isFirstStep, obj1, lstParams);
        }
        return isFullSources;
    }

    private boolean processPermission(Unit usource, Map<Permission, List<Unit>> inMapSources, Map<Permission, List<Unit>> mapResults) {
        boolean foundNewSource = false;
        Set<Permission> setPerms = inMapSources.keySet();
        for (Permission perm : setPerms) {
            List<Unit> lstUnit = inMapSources.get(perm);
            if (!lstUnit.contains(usource)) continue;
            foundNewSource = true;
            List<Unit> lstUnits = mapResults.get(perm);
            if (lstUnits == null) {
                lstUnits = new ArrayList<Unit>();
                lstUnits.add(usource);
                mapResults.put(perm, lstUnits);
                continue;
            }
            lstUnits.add(usource);
        }
        return foundNewSource;
    }

    private void collectPredecessor(AnalysisGraphLvl2a inGraph, List<Object> inLstObjs, boolean inIsFirstStep, Object inCurObj, List<Object> lstParams) {
        Set<Transition> setTransitions = inGraph.getIncomingTransitions(inCurObj);
        List<Object> tempNextSinks = !inIsFirstStep ? this.filterPredecessor(setTransitions, lstParams, false) : this.filterPredecessor(setTransitions, lstParams, true);
        if (tempNextSinks != null && !tempNextSinks.isEmpty()) {
            for (Object object : tempNextSinks) {
                if (inLstObjs.contains(object)) continue;
                int iLastIndex = inLstObjs.size();
                inLstObjs.add(iLastIndex, object);
            }
        }
    }

    private List<Object> filterPredecessor(Set<Transition> inSetTransitions, List<Object> inLstParams, boolean inIsFirstStep) {
        ArrayList<Object> predecessor = new ArrayList<Object>();
        if (inSetTransitions != null && !inSetTransitions.isEmpty()) {
            for (Transition objTrans : inSetTransitions) {
                if (!(objTrans instanceof TransitionLvl2a)) continue;
                TransitionLvl2a tran2a = (TransitionLvl2a)objTrans;
                TransitionType tranType = tran2a.getTransitionType();
                Object source = objTrans.getSource();
                Object target = objTrans.getTarget();
                if (inIsFirstStep) {
                    ParameterNode param;
                    if (tranType == TransitionType.CONTROLDEPENDENCY || tranType == TransitionType.DATAFLOW || tranType == TransitionType.SUMMARY || tranType == TransitionType.CALL || tranType == TransitionType.PARAMIN) {
                        if (predecessor.contains(source)) continue;
                        predecessor.add(source);
                        continue;
                    }
                    if (source instanceof ParameterNode && (param = (ParameterNode)source).getType().equals((Object)ParamType.FORMAL_OUT)) {
                        inLstParams.add(param);
                    }
                    if (!(target instanceof ParameterNode) || !(param = (ParameterNode)target).getType().equals((Object)ParamType.FORMAL_OUT)) continue;
                    inLstParams.add(param);
                    continue;
                }
                if (tranType != TransitionType.CONTROLDEPENDENCY && tranType != TransitionType.DATAFLOW && tranType != TransitionType.SUMMARY && tranType != TransitionType.PARAMOUT || predecessor.contains(source)) continue;
                predecessor.add(source);
            }
        }
        return predecessor;
    }
}

