/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b.analyzer;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl2b.analyzer.ManifestPermissionComparerLvl2b;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class FixpointComputer {
    private AnalysisGraph graph;
    private ResultInput ri;
    private ManifestPermissionComparerLvl2b mpc;
    private EnhancedInput currentEnhancedInput;
    boolean allmode;
    private final Map<EnhancedInput, List<Object>> changedElements = new HashMap<EnhancedInput, List<Object>>();
    private Map<EnhancedInput, List<Transition>> worklist = new HashMap<EnhancedInput, List<Transition>>();

    public FixpointComputer(AnalysisGraph graph, ManifestPermissionComparerLvl2b mpc, boolean allmode) {
        this.graph = graph;
        this.ri = (ResultInput)graph.getInput();
        this.mpc = mpc;
        this.currentEnhancedInput = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(this.ri.getResults().size() - 1)).getAnalysisGraph().getInput();
        this.allmode = allmode;
    }

    public void computeFixpoint() {
        this.initWorkList();
        while (!this.worklist.isEmpty() && !this.changedElements.isEmpty()) {
            this.runWorklistAlgorithm();
        }
    }

    private void initWorkList() {
        int i = 0;
        while (i < this.ri.getResults().size()) {
            EnhancedInput ei = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
            SootClass[] sootClassArray = ei.getAppClasses();
            int n = sootClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                SootClass componentOrClass = sootClassArray[n2];
                this.addElement(ei, componentOrClass);
                for (SootMethod method : componentOrClass.getMethods()) {
                    if (componentOrClass.isInterface()) continue;
                    try {
                        this.addElement(ei, method);
                        Body body = method.retrieveActiveBody();
                        for (Unit stm : body.getUnits()) {
                            this.addElement(ei, stm);
                        }
                    }
                    catch (RuntimeException e) {
                        if (e.getMessage().contains("No method source set for method")) continue;
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    private void runWorklistAlgorithm() {
        EnhancedInput ei;
        int i = 0;
        while (i < this.ri.getResults().size()) {
            ei = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
            if (this.changedElements.get(ei) != null && !this.changedElements.get(ei).isEmpty()) {
                for (Object element : this.changedElements.get(ei)) {
                    this.fillUpPermission(element, ei);
                }
                this.changedElements.remove(ei);
            }
            ++i;
        }
        i = 0;
        while (i < this.ri.getResults().size()) {
            ei = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
            if (this.worklist.get(ei) != null && !this.worklist.get(ei).isEmpty()) {
                ArrayList worklistCopy = new ArrayList();
                worklistCopy.addAll(this.worklist.get(ei));
                this.worklist.remove(ei);
                for (Transition transition : worklistCopy) {
                    this.checkTransition(transition, ei);
                }
            }
            ++i;
        }
    }

    private void fillUpPermission(Object element, EnhancedInput ei) {
        block4: {
            block3: {
                if (!(element instanceof Unit)) break block3;
                if (ei.getPermissionsFor((Unit)element) == null || ei.getPermissionsFor((Unit)element).isEmpty()) break block4;
                for (Permission permission : ei.getPermissionsFor((Unit)element)) {
                    SootMethod method = ei.getBodyForUnit((Unit)element).getMethod();
                    if (ei.getPermissionsFor(method).contains(permission)) continue;
                    this.mpc.addIndirectPermission(method, permission, ei);
                    this.fillUpPermission(method, ei);
                }
                break block4;
            }
            if (element instanceof SootMethod && ei.getPermissionsFor((SootMethod)element) != null && !ei.getPermissionsFor((SootMethod)element).isEmpty()) {
                for (Permission permission : ei.getPermissionsFor((SootMethod)element)) {
                    SootClass componentOrClass = ((SootMethod)element).getDeclaringClass();
                    if (ei.getPermissionsFor(componentOrClass).contains(permission)) continue;
                    this.mpc.addIndirectPermission(componentOrClass, permission, ei);
                }
            }
        }
    }

    private void addElement(EnhancedInput ei, Object element) {
        List<Object> tempList1 = this.changedElements.get(ei);
        if (tempList1 == null) {
            tempList1 = new ArrayList<Object>();
        }
        tempList1.add(element);
        this.changedElements.put(ei, tempList1);
        if (!this.graph.getOutgoingTransitions(element).isEmpty()) {
            List<Transition> tempList2 = this.worklist.get(ei);
            if (tempList2 == null) {
                tempList2 = new ArrayList<Transition>();
            }
            tempList2.addAll(this.graph.getOutgoingTransitions(element));
            this.worklist.put(ei, tempList2);
        }
    }

    private void checkTransition(Transition transition, EnhancedInput ei) {
        if (this.allmode || ei == this.currentEnhancedInput) {
            Object source = transition.getSource();
            SootClass target = (SootClass)transition.getTarget();
            EnhancedInput ei2 = null;
            int i = 0;
            while (i < this.ri.getResults().size()) {
                EnhancedInput ei3 = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
                SootClass[] sootClassArray = ei3.getAppClasses();
                int n = sootClassArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SootClass componentOrClass = sootClassArray[n2];
                    if (target == componentOrClass) {
                        ei2 = ei3;
                        break;
                    }
                    ++n2;
                }
                if (ei2 != null) break;
                ++i;
            }
            for (Permission perm : ei.getPermissions(source)) {
                if (ei2.getPermissions(target).contains(perm)) continue;
                if (ei2.getComponentByName(target.getName()) != null && !ei2.getComponentByName(target.getName()).isInterface()) {
                    for (SootMethod targetMethod : ei2.getComponentByName(target.getName()).getMethods()) {
                        this.mpc.addIndirectPermission(targetMethod, perm, ei2);
                        this.addElement(ei2, targetMethod);
                    }
                }
                this.mpc.addIndirectPermission(target, perm, ei2);
                this.addElement(ei2, target);
            }
            for (Permission perm : ei2.getPermissions(target)) {
                if (ei.getPermissions(source).contains(perm)) continue;
                this.mpc.addIndirectPermission(source, perm, ei);
                this.addElement(ei, source);
            }
        }
    }
}

