/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.client.core;

import de.upb.pga3.panda2.client.core.ConfigManager;
import de.upb.pga3.panda2.client.core.UserInput;
import de.upb.pga3.panda2.client.core.datastructures.LevelSpecificMode;
import de.upb.pga3.panda2.client.core.datastructures.Mode;
import de.upb.pga3.panda2.client.core.datastructures.UIMessage;
import de.upb.pga3.panda2.client.core.datastructures.UIMessageType;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ConfigManagerTest {
    UserInput ui;
    UserInput uiempty;
    UserInput ui1;
    List<String> initialAPKInput;
    List<String> nonNativeAPKInput;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        ConfigManager configManager = new ConfigManager();
        this.uiempty = new UserInput();
        this.ui = new UserInput("Permission Usage (Intra App - Level 1)", null, Mode.SUMMARY);
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", LevelSpecificMode.ALL, Mode.COMPARISON);
        this.initialAPKInput = new ArrayList<String>();
        this.nonNativeAPKInput = new ArrayList<String>();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void validateInputtest() {
        UIMessage uiMessage = ConfigManager.validateInput(this.ui);
        Assert.assertNotNull((Object)uiMessage);
    }

    @Test
    public void validateInputNegativetest() {
        UIMessage uiMessage = ConfigManager.validateInput(this.uiempty);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative1test() {
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative2test() {
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative3test() {
        this.initialAPKInput.add("");
        this.ui.setSelectedInitialInput(this.initialAPKInput);
        this.ui.createAPKFilesForInitialInput();
        UIMessage uiMessage = ConfigManager.validateInput(this.ui);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative4test() {
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", LevelSpecificMode.ALL, Mode.COMPARISON);
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative5test() {
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", null, Mode.COMPARISON);
        this.initialAPKInput.add("");
        this.ui1.setSelectedInitialInput(this.initialAPKInput);
        this.ui1.createAPKFilesForInitialInput();
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative6test() {
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", LevelSpecificMode.ALL, Mode.COMPARISON);
        this.initialAPKInput.add("");
        this.ui1.setSelectedInitialInput(this.initialAPKInput);
        this.ui1.createAPKFilesForInitialInput();
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative7test() {
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", LevelSpecificMode.ALL, Mode.COMPARISON);
        this.ui1.setSelectedComparisonInput("");
        this.initialAPKInput.add("test_resources/DummyAPP.apk");
        this.nonNativeAPKInput.add("");
        this.ui1.setSelectedInitialInput(this.initialAPKInput);
        this.ui1.setSelectedNonNativeapps(this.nonNativeAPKInput);
        this.ui1.createAPKFilesForInitialInput();
        this.ui1.createAPKFilesForNonNativeApps();
        this.ui1.createPreviousAnalysisResultFile();
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validateInputNegative8test() {
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", LevelSpecificMode.ALL, Mode.COMPARISON);
        this.ui1.setSelectedComparisonInput("");
        this.initialAPKInput.add("test_resources/AllCasesLevel2bAppPart1.apk");
        this.nonNativeAPKInput.add("test_resources/AllCasesLevel2bAppPart2.apk");
        this.ui1.setSelectedInitialInput(this.initialAPKInput);
        this.ui1.setSelectedNonNativeapps(this.nonNativeAPKInput);
        this.ui1.createAPKFilesForInitialInput();
        this.ui1.createAPKFilesForNonNativeApps();
        this.ui1.createPreviousAnalysisResultFile();
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.ERROR), (Object)((Object)uiMessage.getType()));
    }

    @Test
    public void validatePositive2Btest() {
        this.ui1 = new UserInput("Permission Usage (Inter App - Level 2b)", LevelSpecificMode.ALL, Mode.COMPARISON);
        this.initialAPKInput.add("test_resources/AllCasesLevel2bAppPart1.apk");
        this.nonNativeAPKInput.add("test_resources/AllCasesLevel2bAppPart2.apk");
        this.ui1.setSelectedInitialInput(this.initialAPKInput);
        this.ui1.setSelectedNonNativeapps(this.nonNativeAPKInput);
        this.ui1.setSelectedComparisonInput("test_resources/SimpleMissingInternetP.pa2");
        this.ui1.createAPKFilesForInitialInput();
        this.ui1.createAPKFilesForNonNativeApps();
        this.ui1.createPreviousAnalysisResultFile();
        UIMessage uiMessage = ConfigManager.validateInput(this.ui1);
        Assert.assertEquals((Object)((Object)UIMessageType.INFO), (Object)((Object)uiMessage.getType()));
    }
}

