/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.core.services;

import de.upb.pga3.panda2.core.datastructures.IntentFilter;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.XMLParser;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class A3XMLParserTest {
    String apkPath = "";
    A3XMLParser a3p;
    XMLParser xp;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.apkPath = "test_resources/SimpleIntents.apk";
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void getAppNametest() {
        this.xp = A3XMLParser.getInstance();
        this.xp.fetchData(this.apkPath);
        String appName = this.xp.getAppName();
        Assert.assertEquals((Object)"simpleintents", (Object)appName);
    }

    @Test
    public void getAppNameNegativetest() {
        this.xp = A3XMLParser.getInstance();
        this.xp.fetchData(this.apkPath);
        String appName = this.xp.getAppName();
        Assert.assertNotEquals((Object)"Simple", (Object)appName);
    }

    @Test
    public void getFingerprinttest() {
        this.xp = A3XMLParser.getInstance();
        this.xp.fetchData(this.apkPath);
        String appName = this.xp.getFingerprint();
        Assert.assertEquals((Object)"24ca4ad37466d705700ec339e048f0e5", (Object)appName);
    }

    @Test
    public void getFingerprintNegativetest() {
        this.xp = A3XMLParser.getInstance();
        this.xp.fetchData(this.apkPath);
        String appName = this.xp.getFingerprint();
        Assert.assertNotEquals((Object)"dummy", (Object)appName);
    }

    @Test
    public void getUsesPermissiontest() {
        this.xp = A3XMLParser.getInstance();
        this.xp.fetchData(this.apkPath);
        List<String> usesPer = this.xp.getUsesPermission();
        Assert.assertEquals((long)0L, (long)usesPer.size());
    }

    @Test
    public void getIntentFilterstest() {
        this.xp = A3XMLParser.getInstance();
        this.xp.fetchData(this.apkPath);
        List<IntentFilter> intentFil = this.xp.getIntentFilters();
        Assert.assertEquals((long)1L, (long)intentFil.size());
    }
}

