/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.builder;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.writer.AnnotationSetSection;
import org.jf.dexlib2.writer.builder.BuilderAnnotation;
import org.jf.dexlib2.writer.builder.BuilderAnnotationSet;
import org.jf.dexlib2.writer.builder.BuilderContext;
import org.jf.dexlib2.writer.builder.BuilderMapEntryCollection;

class BuilderAnnotationSetPool
implements AnnotationSetSection<BuilderAnnotation, BuilderAnnotationSet> {
    @Nonnull
    private final BuilderContext context;
    @Nonnull
    private final ConcurrentMap<Set<? extends Annotation>, BuilderAnnotationSet> internedItems = Maps.newConcurrentMap();

    BuilderAnnotationSetPool(@Nonnull BuilderContext context) {
        this.context = context;
    }

    @Nonnull
    public BuilderAnnotationSet internAnnotationSet(@Nullable Set<? extends Annotation> annotations) {
        if (annotations == null) {
            return BuilderAnnotationSet.EMPTY;
        }
        BuilderAnnotationSet ret = (BuilderAnnotationSet)this.internedItems.get(annotations);
        if (ret != null) {
            return ret;
        }
        BuilderAnnotationSet annotationSet = new BuilderAnnotationSet(ImmutableSet.copyOf(Iterators.transform(annotations.iterator(), new Function<Annotation, BuilderAnnotation>(){

            @Override
            @Nullable
            public BuilderAnnotation apply(Annotation input) {
                return ((BuilderAnnotationSetPool)BuilderAnnotationSetPool.this).context.annotationPool.internAnnotation(input);
            }
        })));
        ret = this.internedItems.putIfAbsent(annotationSet, annotationSet);
        return ret == null ? annotationSet : ret;
    }

    @Override
    @Nonnull
    public Collection<? extends BuilderAnnotation> getAnnotations(@Nonnull BuilderAnnotationSet key) {
        return key.annotations;
    }

    @Override
    public int getNullableItemOffset(@Nullable BuilderAnnotationSet key) {
        return key == null ? 0 : key.offset;
    }

    @Override
    public int getItemOffset(@Nonnull BuilderAnnotationSet key) {
        return key.offset;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<? extends BuilderAnnotationSet, Integer>> getItems() {
        return new BuilderMapEntryCollection<BuilderAnnotationSet>(this.internedItems.values()){

            @Override
            protected int getValue(@Nonnull BuilderAnnotationSet key) {
                return key.offset;
            }

            @Override
            protected int setValue(@Nonnull BuilderAnnotationSet key, int value) {
                int prev = key.offset;
                key.offset = value;
                return prev;
            }
        };
    }
}

