/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.SootClass;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.jimple.parser.Walker;
import soot.jimple.parser.node.AFile;
import soot.jimple.parser.node.AMethodMember;
import soot.jimple.parser.node.AThrowsClause;
import soot.jimple.parser.node.PModifier;

public class SkeletonExtractorWalker
extends Walker {
    public SkeletonExtractorWalker(SootResolver aResolver, SootClass aSootClass) {
        super(aSootClass, aResolver);
    }

    public SkeletonExtractorWalker(SootResolver aResolver) {
        super(aResolver);
    }

    @Override
    public void caseAFile(AFile node) {
        Object[] temp;
        this.inAFile(node);
        for (Object element : temp = node.getModifier().toArray()) {
            ((PModifier)element).apply(this);
        }
        if (node.getFileType() != null) {
            node.getFileType().apply(this);
        }
        if (node.getClassName() != null) {
            node.getClassName().apply(this);
        }
        String className = (String)this.mProductions.removeLast();
        if (this.mSootClass == null) {
            this.mSootClass = new SootClass(className);
            this.mSootClass.setResolvingLevel(2);
        } else if (!className.equals(this.mSootClass.getName())) {
            throw new RuntimeException("expected:  " + className + ", but got: " + this.mSootClass.getName());
        }
        if (node.getExtendsClause() != null) {
            node.getExtendsClause().apply(this);
        }
        if (node.getImplementsClause() != null) {
            node.getImplementsClause().apply(this);
        }
        if (node.getFileBody() != null) {
            node.getFileBody().apply(this);
        }
        this.outAFile(node);
    }

    @Override
    public void outAFile(AFile node) {
        List implementsList = null;
        String superClass = null;
        String classType = null;
        if (node.getImplementsClause() != null) {
            implementsList = (List)this.mProductions.removeLast();
        }
        if (node.getExtendsClause() != null) {
            superClass = (String)this.mProductions.removeLast();
        }
        classType = (String)this.mProductions.removeLast();
        int modifierFlags = this.processModifiers(node.getModifier());
        if (classType.equals("interface")) {
            modifierFlags |= 0x200;
        }
        this.mSootClass.setModifiers(modifierFlags);
        if (superClass != null) {
            this.mSootClass.setSuperclass(this.mResolver.makeClassRef(superClass));
        }
        if (implementsList != null) {
            Iterator implIt = implementsList.iterator();
            while (implIt.hasNext()) {
                SootClass interfaceClass = this.mResolver.makeClassRef((String)implIt.next());
                this.mSootClass.addInterface(interfaceClass);
            }
        }
        this.mProductions.addLast(this.mSootClass);
    }

    @Override
    public void caseAMethodMember(AMethodMember node) {
        Object[] temp;
        this.inAMethodMember(node);
        for (Object element : temp = node.getModifier().toArray()) {
            ((PModifier)element).apply(this);
        }
        if (node.getType() != null) {
            node.getType().apply(this);
        }
        if (node.getName() != null) {
            node.getName().apply(this);
        }
        if (node.getLParen() != null) {
            node.getLParen().apply(this);
        }
        if (node.getParameterList() != null) {
            node.getParameterList().apply(this);
        }
        if (node.getRParen() != null) {
            node.getRParen().apply(this);
        }
        if (node.getThrowsClause() != null) {
            node.getThrowsClause().apply(this);
        }
        this.outAMethodMember(node);
    }

    @Override
    public void outAMethodMember(AMethodMember node) {
        int modifier = 0;
        List parameterList = null;
        List throwsClause = null;
        if (node.getThrowsClause() != null) {
            throwsClause = (List)this.mProductions.removeLast();
        }
        parameterList = node.getParameterList() != null ? (List)this.mProductions.removeLast() : new ArrayList();
        Object o = this.mProductions.removeLast();
        String name = (String)o;
        Type type = (Type)this.mProductions.removeLast();
        modifier = this.processModifiers(node.getModifier());
        SootMethod method = throwsClause != null ? new SootMethod(name, parameterList, type, modifier, throwsClause) : new SootMethod(name, parameterList, type, modifier);
        this.mSootClass.addMethod(method);
    }

    @Override
    public void outAThrowsClause(AThrowsClause node) {
        List l = (List)this.mProductions.removeLast();
        Iterator it = l.iterator();
        ArrayList<SootClass> exceptionClasses = new ArrayList<SootClass>(l.size());
        while (it.hasNext()) {
            String className = (String)it.next();
            exceptionClasses.add(this.mResolver.makeClassRef(className));
        }
        this.mProductions.addLast(exceptionClasses);
    }
}

