/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple.toolkits.scalar;

import java.util.List;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Unit;
import soot.UnitBoxOwner;
import soot.Value;
import soot.ValueBox;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.shimple.ShimpleBody;
import soot.shimple.toolkits.scalar.SCPFAnalysis;
import soot.shimple.toolkits.scalar.SEvaluator;
import soot.shimple.toolkits.scalar.ShimpleLocalDefs;
import soot.shimple.toolkits.scalar.ShimpleLocalUses;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.UnitValueBoxPair;
import soot.util.Chain;

public class SConstantPropagatorAndFolder
extends BodyTransformer {
    protected ShimpleBody sb;
    protected boolean debug;

    public SConstantPropagatorAndFolder(Singletons.Global g) {
    }

    public static SConstantPropagatorAndFolder v() {
        return G.v().soot_shimple_toolkits_scalar_SConstantPropagatorAndFolder();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (!(b instanceof ShimpleBody)) {
            throw new RuntimeException("SConstantPropagatorAndFolder requires a ShimpleBody.");
        }
        this.sb = (ShimpleBody)b;
        if (!this.sb.isSSA()) {
            throw new RuntimeException("ShimpleBody is not in proper SSA form as required by SConstantPropagatorAndFolder.  You may need to rebuild it or use ConstantPropagatorAndFolder instead.");
        }
        boolean pruneCFG = PhaseOptions.getBoolean(options, "prune-cfg");
        this.debug = Options.v().debug();
        this.debug |= this.sb.getOptions().debug();
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.sb.getMethod().getName() + "] Propagating and folding constants (SSA)...");
        }
        SCPFAnalysis scpf = new SCPFAnalysis(new ExceptionalUnitGraph(this.sb));
        this.propagateResults(scpf.getResults());
        if (pruneCFG) {
            this.removeStmts(scpf.getDeadStmts());
            this.replaceStmts(scpf.getStmtsToReplace());
        }
    }

    protected void propagateResults(Map<Local, Constant> localToConstant) {
        PatchingChain<Unit> units = this.sb.getUnits();
        Chain<Local> locals = this.sb.getLocals();
        ShimpleLocalDefs localDefs = new ShimpleLocalDefs(this.sb);
        ShimpleLocalUses localUses = new ShimpleLocalUses(this.sb);
        for (Local local : locals) {
            Constant constant = localToConstant.get(local);
            if (constant instanceof SEvaluator.MetaConstant) continue;
            DefinitionStmt stmt = (DefinitionStmt)localDefs.getDefsOf(local).get(0);
            ValueBox defSrcBox = stmt.getRightOpBox();
            Value defSrc = defSrcBox.getValue();
            if (defSrcBox.canContainValue(constant)) {
                defSrcBox.setValue(constant);
                if (defSrc instanceof UnitBoxOwner) {
                    ((UnitBoxOwner)((Object)defSrc)).clearUnitBoxes();
                }
            } else if (this.debug) {
                G.v().out.println("Warning: Couldn't propagate constant " + constant + " to box " + defSrcBox.getValue() + " in unit " + stmt);
            }
            for (UnitValueBoxPair pair : localUses.getUsesOf(local)) {
                ValueBox useBox = pair.getValueBox();
                if (useBox.canContainValue(constant)) {
                    useBox.setValue(constant);
                    continue;
                }
                if (!this.debug) continue;
                G.v().out.println("Warning: Couldn't propagate constant " + constant + " to box " + useBox.getValue() + " in unit " + pair.getUnit());
            }
        }
    }

    protected void removeStmts(List<IfStmt> deadStmts) {
        PatchingChain<Unit> units = this.sb.getUnits();
        for (Unit unit : deadStmts) {
            units.remove(unit);
            unit.clearUnitBoxes();
        }
    }

    protected void replaceStmts(Map<Stmt, GotoStmt> stmtsToReplace) {
        PatchingChain<Unit> units = this.sb.getUnits();
        for (Unit unit : stmtsToReplace.keySet()) {
            Unit replacement = stmtsToReplace.get(unit);
            units.swapWith(unit, replacement);
        }
    }
}

