/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import soot.FastHierarchy;
import soot.G;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.Value;
import soot.ValueBox;
import soot.baf.AddInst;
import soot.baf.AndInst;
import soot.baf.ArrayLengthInst;
import soot.baf.ArrayReadInst;
import soot.baf.ArrayWriteInst;
import soot.baf.CmpInst;
import soot.baf.CmpgInst;
import soot.baf.CmplInst;
import soot.baf.DivInst;
import soot.baf.Dup1Inst;
import soot.baf.Dup1_x1Inst;
import soot.baf.Dup1_x2Inst;
import soot.baf.Dup2Inst;
import soot.baf.Dup2_x1Inst;
import soot.baf.Dup2_x2Inst;
import soot.baf.DynamicInvokeInst;
import soot.baf.EnterMonitorInst;
import soot.baf.ExitMonitorInst;
import soot.baf.FieldGetInst;
import soot.baf.FieldPutInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IfCmpEqInst;
import soot.baf.IfCmpGeInst;
import soot.baf.IfCmpGtInst;
import soot.baf.IfCmpLeInst;
import soot.baf.IfCmpLtInst;
import soot.baf.IfCmpNeInst;
import soot.baf.IfEqInst;
import soot.baf.IfGeInst;
import soot.baf.IfGtInst;
import soot.baf.IfLeInst;
import soot.baf.IfLtInst;
import soot.baf.IfNeInst;
import soot.baf.IfNonNullInst;
import soot.baf.IfNullInst;
import soot.baf.IncInst;
import soot.baf.InstSwitch;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.InterfaceInvokeInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.LookupSwitchInst;
import soot.baf.MulInst;
import soot.baf.NegInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NopInst;
import soot.baf.OrInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.RemInst;
import soot.baf.ReturnInst;
import soot.baf.ReturnVoidInst;
import soot.baf.ShlInst;
import soot.baf.ShrInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StaticGetInst;
import soot.baf.StaticInvokeInst;
import soot.baf.StaticPutInst;
import soot.baf.StoreInst;
import soot.baf.SubInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.ThrowInst;
import soot.baf.UshrInst;
import soot.baf.VirtualInvokeInst;
import soot.baf.XorInst;
import soot.grimp.GrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GtExpr;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MethodHandle;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StmtSwitch;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.shimple.PhiExpr;
import soot.shimple.ShimpleValueSwitch;
import soot.toolkits.exceptions.AbstractThrowAnalysis;
import soot.toolkits.exceptions.ThrowableSet;

public class UnitThrowAnalysis
extends AbstractThrowAnalysis {
    protected final ThrowableSet.Manager mgr = ThrowableSet.Manager.v();
    private final ThrowableSet implicitThrowExceptions;
    private static final IntConstant INT_CONSTANT_ZERO = IntConstant.v(0);
    private static final LongConstant LONG_CONSTANT_ZERO = LongConstant.v(0L);

    public UnitThrowAnalysis(Singletons.Global g) {
        this.implicitThrowExceptions = ThrowableSet.Manager.v().VM_ERRORS.add(ThrowableSet.Manager.v().NULL_POINTER_EXCEPTION).add(ThrowableSet.Manager.v().ILLEGAL_MONITOR_STATE_EXCEPTION);
    }

    protected UnitThrowAnalysis() {
        this.implicitThrowExceptions = ThrowableSet.Manager.v().VM_ERRORS.add(ThrowableSet.Manager.v().NULL_POINTER_EXCEPTION).add(ThrowableSet.Manager.v().ILLEGAL_MONITOR_STATE_EXCEPTION);
    }

    public static UnitThrowAnalysis v() {
        return G.v().soot_toolkits_exceptions_UnitThrowAnalysis();
    }

    protected ThrowableSet defaultResult() {
        return this.mgr.VM_ERRORS;
    }

    protected UnitSwitch unitSwitch() {
        return new UnitSwitch();
    }

    protected ValueSwitch valueSwitch() {
        return new ValueSwitch();
    }

    @Override
    public ThrowableSet mightThrow(Unit u) {
        UnitSwitch sw = this.unitSwitch();
        u.apply(sw);
        return sw.getResult();
    }

    @Override
    public ThrowableSet mightThrowImplicitly(ThrowInst t) {
        return this.implicitThrowExceptions;
    }

    @Override
    public ThrowableSet mightThrowImplicitly(ThrowStmt t) {
        return this.implicitThrowExceptions;
    }

    protected ThrowableSet mightThrow(Value v) {
        ValueSwitch sw = this.valueSwitch();
        v.apply(sw);
        return sw.getResult();
    }

    protected ThrowableSet mightThrow(SootMethodRef m) {
        return ThrowableSet.Manager.v().ALL_THROWABLES;
    }

    protected class ValueSwitch
    implements GrimpValueSwitch,
    ShimpleValueSwitch {
        private ThrowableSet result;

        protected ValueSwitch() {
            this.result = UnitThrowAnalysis.this.defaultResult();
        }

        ThrowableSet getResult() {
            return this.result;
        }

        @Override
        public void caseDoubleConstant(DoubleConstant c) {
        }

        @Override
        public void caseFloatConstant(FloatConstant c) {
        }

        @Override
        public void caseIntConstant(IntConstant c) {
        }

        @Override
        public void caseLongConstant(LongConstant c) {
        }

        @Override
        public void caseNullConstant(NullConstant c) {
        }

        @Override
        public void caseStringConstant(StringConstant c) {
        }

        @Override
        public void caseClassConstant(ClassConstant c) {
        }

        @Override
        public void caseMethodHandle(MethodHandle handle) {
        }

        @Override
        public void caseAddExpr(AddExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseAndExpr(AndExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseCmpExpr(CmpExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseCmpgExpr(CmpgExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseCmplExpr(CmplExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseDivExpr(DivExpr expr) {
            this.caseBinopDivExpr(expr);
        }

        @Override
        public void caseEqExpr(EqExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseNeExpr(NeExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseGeExpr(GeExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseGtExpr(GtExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseLeExpr(LeExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseLtExpr(LtExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseMulExpr(MulExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseOrExpr(OrExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseRemExpr(RemExpr expr) {
            this.caseBinopDivExpr(expr);
        }

        @Override
        public void caseShlExpr(ShlExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseShrExpr(ShrExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseUshrExpr(UshrExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseSubExpr(SubExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseXorExpr(XorExpr expr) {
            this.caseBinopExpr(expr);
        }

        @Override
        public void caseInterfaceInvokeExpr(InterfaceInvokeExpr expr) {
            this.caseInstanceInvokeExpr(expr);
        }

        @Override
        public void caseSpecialInvokeExpr(SpecialInvokeExpr expr) {
            this.caseInstanceInvokeExpr(expr);
        }

        @Override
        public void caseStaticInvokeExpr(StaticInvokeExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
            for (int i = 0; i < expr.getArgCount(); ++i) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getArg(i)));
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getMethodRef()));
        }

        @Override
        public void caseVirtualInvokeExpr(VirtualInvokeExpr expr) {
            this.caseInstanceInvokeExpr(expr);
        }

        @Override
        public void caseDynamicInvokeExpr(DynamicInvokeExpr expr) {
        }

        @Override
        public void caseCastExpr(CastExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            Type fromType = expr.getOp().getType();
            Type toType = expr.getCastType();
            if (toType instanceof RefLikeType) {
                FastHierarchy h = Scene.v().getOrMakeFastHierarchy();
                if (fromType == null || fromType instanceof UnknownType || !(fromType instanceof NullType) && !h.canStoreType(fromType, toType)) {
                    this.result = this.result.add(UnitThrowAnalysis.this.mgr.CLASS_CAST_EXCEPTION);
                }
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseInstanceOfExpr(InstanceOfExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseNewArrayExpr(NewArrayExpr expr) {
            Value count;
            if (expr.getBaseType() instanceof RefLikeType) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            }
            if (!((count = expr.getSize()) instanceof IntConstant) || ((IntConstant)count).lessThan(INT_CONSTANT_ZERO).equals(INT_CONSTANT_ZERO)) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.NEGATIVE_ARRAY_SIZE_EXCEPTION);
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(count));
        }

        @Override
        public void caseNewMultiArrayExpr(NewMultiArrayExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            for (int i = 0; i < expr.getSizeCount(); ++i) {
                Value count = expr.getSize(i);
                if (!(count instanceof IntConstant) || ((IntConstant)count).lessThan(INT_CONSTANT_ZERO).equals(INT_CONSTANT_ZERO)) {
                    this.result = this.result.add(UnitThrowAnalysis.this.mgr.NEGATIVE_ARRAY_SIZE_EXCEPTION);
                }
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(count));
            }
        }

        @Override
        public void caseNewExpr(NewExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
            for (ValueBox box : expr.getUseBoxes()) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(box.getValue()));
            }
        }

        @Override
        public void caseLengthExpr(LengthExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseNegExpr(NegExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp()));
        }

        @Override
        public void caseArrayRef(ArrayRef ref) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(ref.getBase()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(ref.getIndex()));
        }

        @Override
        public void caseStaticFieldRef(StaticFieldRef ref) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
        }

        @Override
        public void caseInstanceFieldRef(InstanceFieldRef ref) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_FIELD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(ref.getBase()));
        }

        @Override
        public void caseParameterRef(ParameterRef v) {
        }

        @Override
        public void caseCaughtExceptionRef(CaughtExceptionRef v) {
        }

        @Override
        public void caseThisRef(ThisRef v) {
        }

        @Override
        public void caseLocal(Local l) {
        }

        @Override
        public void caseNewInvokeExpr(NewInvokeExpr e) {
            this.caseStaticInvokeExpr(e);
        }

        @Override
        public void casePhiExpr(PhiExpr e) {
            for (ValueBox box : e.getUseBoxes()) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(box.getValue()));
            }
        }

        @Override
        public void defaultCase(Object obj) {
        }

        private void caseBinopExpr(BinopExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp1()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getOp2()));
        }

        private void caseBinopDivExpr(BinopExpr expr) {
            Value divisor = expr.getOp2();
            Type divisorType = divisor.getType();
            if (divisorType instanceof UnknownType) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARITHMETIC_EXCEPTION);
            } else if (divisorType instanceof IntegerType && (!(divisor instanceof IntConstant) || ((IntConstant)divisor).equals(INT_CONSTANT_ZERO))) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARITHMETIC_EXCEPTION);
            } else if (divisorType == LongType.v() && (!(divisor instanceof LongConstant) || ((LongConstant)divisor).equals(LONG_CONSTANT_ZERO))) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARITHMETIC_EXCEPTION);
            }
            this.caseBinopExpr(expr);
        }

        private void caseInstanceInvokeExpr(InstanceInvokeExpr expr) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_METHOD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            for (int i = 0; i < expr.getArgCount(); ++i) {
                this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getArg(i)));
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getBase()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(expr.getMethodRef()));
        }
    }

    protected class UnitSwitch
    implements InstSwitch,
    StmtSwitch {
        protected ThrowableSet result;

        protected UnitSwitch() {
            this.result = UnitThrowAnalysis.this.defaultResult();
        }

        ThrowableSet getResult() {
            return this.result;
        }

        @Override
        public void caseReturnVoidInst(ReturnVoidInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
        }

        @Override
        public void caseReturnInst(ReturnInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
        }

        @Override
        public void caseNopInst(NopInst i) {
        }

        @Override
        public void caseGotoInst(GotoInst i) {
        }

        @Override
        public void caseJSRInst(JSRInst i) {
        }

        @Override
        public void casePushInst(PushInst i) {
        }

        @Override
        public void casePopInst(PopInst i) {
        }

        @Override
        public void caseIdentityInst(IdentityInst i) {
        }

        @Override
        public void caseStoreInst(StoreInst i) {
        }

        @Override
        public void caseLoadInst(LoadInst i) {
        }

        @Override
        public void caseArrayWriteInst(ArrayWriteInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION);
            if (i.getOpType() instanceof RefType) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARRAY_STORE_EXCEPTION);
            }
        }

        @Override
        public void caseArrayReadInst(ArrayReadInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION);
        }

        @Override
        public void caseIfNullInst(IfNullInst i) {
        }

        @Override
        public void caseIfNonNullInst(IfNonNullInst i) {
        }

        @Override
        public void caseIfEqInst(IfEqInst i) {
        }

        @Override
        public void caseIfNeInst(IfNeInst i) {
        }

        @Override
        public void caseIfGtInst(IfGtInst i) {
        }

        @Override
        public void caseIfGeInst(IfGeInst i) {
        }

        @Override
        public void caseIfLtInst(IfLtInst i) {
        }

        @Override
        public void caseIfLeInst(IfLeInst i) {
        }

        @Override
        public void caseIfCmpEqInst(IfCmpEqInst i) {
        }

        @Override
        public void caseIfCmpNeInst(IfCmpNeInst i) {
        }

        @Override
        public void caseIfCmpGtInst(IfCmpGtInst i) {
        }

        @Override
        public void caseIfCmpGeInst(IfCmpGeInst i) {
        }

        @Override
        public void caseIfCmpLtInst(IfCmpLtInst i) {
        }

        @Override
        public void caseIfCmpLeInst(IfCmpLeInst i) {
        }

        @Override
        public void caseStaticGetInst(StaticGetInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
        }

        @Override
        public void caseStaticPutInst(StaticPutInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
        }

        @Override
        public void caseFieldGetInst(FieldGetInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_FIELD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
        }

        @Override
        public void caseFieldPutInst(FieldPutInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_FIELD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
        }

        @Override
        public void caseInstanceCastInst(InstanceCastInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.CLASS_CAST_EXCEPTION);
        }

        @Override
        public void caseInstanceOfInst(InstanceOfInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
        }

        @Override
        public void casePrimitiveCastInst(PrimitiveCastInst i) {
        }

        @Override
        public void caseDynamicInvokeInst(DynamicInvokeInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_METHOD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
            this.result = this.result.add(ThrowableSet.Manager.v().ALL_THROWABLES);
        }

        @Override
        public void caseStaticInvokeInst(StaticInvokeInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(i.getMethodRef()));
        }

        @Override
        public void caseVirtualInvokeInst(VirtualInvokeInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_METHOD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(i.getMethodRef()));
        }

        @Override
        public void caseInterfaceInvokeInst(InterfaceInvokeInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_METHOD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(i.getMethodRef()));
        }

        @Override
        public void caseSpecialInvokeInst(SpecialInvokeInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_METHOD_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(i.getMethodRef()));
        }

        @Override
        public void caseThrowInst(ThrowInst i) {
            this.result = UnitThrowAnalysis.this.mightThrowImplicitly(i);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrowExplicitly(i));
        }

        @Override
        public void caseAddInst(AddInst i) {
        }

        @Override
        public void caseAndInst(AndInst i) {
        }

        @Override
        public void caseOrInst(OrInst i) {
        }

        @Override
        public void caseXorInst(XorInst i) {
        }

        @Override
        public void caseArrayLengthInst(ArrayLengthInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
        }

        @Override
        public void caseCmpInst(CmpInst i) {
        }

        @Override
        public void caseCmpgInst(CmpgInst i) {
        }

        @Override
        public void caseCmplInst(CmplInst i) {
        }

        @Override
        public void caseDivInst(DivInst i) {
            if (i.getOpType() instanceof IntegerType || i.getOpType() == LongType.v()) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARITHMETIC_EXCEPTION);
            }
        }

        @Override
        public void caseIncInst(IncInst i) {
        }

        @Override
        public void caseMulInst(MulInst i) {
        }

        @Override
        public void caseRemInst(RemInst i) {
            if (i.getOpType() instanceof IntegerType || i.getOpType() == LongType.v()) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARITHMETIC_EXCEPTION);
            }
        }

        @Override
        public void caseSubInst(SubInst i) {
        }

        @Override
        public void caseShlInst(ShlInst i) {
        }

        @Override
        public void caseShrInst(ShrInst i) {
        }

        @Override
        public void caseUshrInst(UshrInst i) {
        }

        @Override
        public void caseNewInst(NewInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.INITIALIZATION_ERRORS);
        }

        @Override
        public void caseNegInst(NegInst i) {
        }

        @Override
        public void caseSwapInst(SwapInst i) {
        }

        @Override
        public void caseDup1Inst(Dup1Inst i) {
        }

        @Override
        public void caseDup2Inst(Dup2Inst i) {
        }

        @Override
        public void caseDup1_x1Inst(Dup1_x1Inst i) {
        }

        @Override
        public void caseDup1_x2Inst(Dup1_x2Inst i) {
        }

        @Override
        public void caseDup2_x1Inst(Dup2_x1Inst i) {
        }

        @Override
        public void caseDup2_x2Inst(Dup2_x2Inst i) {
        }

        @Override
        public void caseNewArrayInst(NewArrayInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NEGATIVE_ARRAY_SIZE_EXCEPTION);
        }

        @Override
        public void caseNewMultiArrayInst(NewMultiArrayInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.RESOLVE_CLASS_ERRORS);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NEGATIVE_ARRAY_SIZE_EXCEPTION);
        }

        @Override
        public void caseLookupSwitchInst(LookupSwitchInst i) {
        }

        @Override
        public void caseTableSwitchInst(TableSwitchInst i) {
        }

        @Override
        public void caseEnterMonitorInst(EnterMonitorInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
        }

        @Override
        public void caseExitMonitorInst(ExitMonitorInst i) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
        }

        @Override
        public void caseAssignStmt(AssignStmt s) {
            Value lhs = s.getLeftOp();
            if (lhs instanceof ArrayRef && (lhs.getType() instanceof UnknownType || lhs.getType() instanceof RefType)) {
                this.result = this.result.add(UnitThrowAnalysis.this.mgr.ARRAY_STORE_EXCEPTION);
            }
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getLeftOp()));
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getRightOp()));
        }

        @Override
        public void caseBreakpointStmt(BreakpointStmt s) {
        }

        @Override
        public void caseEnterMonitorStmt(EnterMonitorStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getOp()));
        }

        @Override
        public void caseExitMonitorStmt(ExitMonitorStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.ILLEGAL_MONITOR_STATE_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mgr.NULL_POINTER_EXCEPTION);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getOp()));
        }

        @Override
        public void caseGotoStmt(GotoStmt s) {
        }

        @Override
        public void caseIdentityStmt(IdentityStmt s) {
        }

        @Override
        public void caseIfStmt(IfStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getCondition()));
        }

        @Override
        public void caseInvokeStmt(InvokeStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getInvokeExpr()));
        }

        @Override
        public void caseLookupSwitchStmt(LookupSwitchStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getKey()));
        }

        @Override
        public void caseNopStmt(NopStmt s) {
        }

        @Override
        public void caseRetStmt(RetStmt s) {
        }

        @Override
        public void caseReturnStmt(ReturnStmt s) {
        }

        @Override
        public void caseReturnVoidStmt(ReturnVoidStmt s) {
        }

        @Override
        public void caseTableSwitchStmt(TableSwitchStmt s) {
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrow(s.getKey()));
        }

        @Override
        public void caseThrowStmt(ThrowStmt s) {
            this.result = UnitThrowAnalysis.this.mightThrowImplicitly(s);
            this.result = this.result.add(UnitThrowAnalysis.this.mightThrowExplicitly(s));
        }

        @Override
        public void defaultCase(Object obj) {
        }
    }
}

