/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.options.Options;

public class UnusedLocalEliminator
extends BodyTransformer {
    public UnusedLocalEliminator(Singletons.Global g) {
    }

    public static UnusedLocalEliminator v() {
        return G.v().soot_toolkits_scalar_UnusedLocalEliminator();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Local[] locals;
        if (Options.v().verbose()) {
            G.v().out.println("[" + body.getMethod().getName() + "] Eliminating unused locals...");
        }
        int i = 0;
        int n = body.getLocals().size();
        int[] oldNumbers = new int[n];
        for (Local local : locals = body.getLocals().toArray(new Local[n])) {
            oldNumbers[i] = local.getNumber();
            local.setNumber(i);
            ++i;
        }
        boolean[] usedLocals = new boolean[n];
        for (Unit s : body.getUnits()) {
            Local l;
            Value v;
            for (ValueBox vb : s.getUseBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                usedLocals[l.getNumber()] = true;
            }
            for (ValueBox vb : s.getDefBoxes()) {
                v = vb.getValue();
                if (!(v instanceof Local)) continue;
                l = (Local)v;
                usedLocals[l.getNumber()] = true;
            }
        }
        ArrayList<Local> keep = new ArrayList<Local>(locals.length);
        for (Local local : locals) {
            int lno = local.getNumber();
            local.setNumber(oldNumbers[lno]);
            if (!usedLocals[lno]) continue;
            keep.add(local);
        }
        body.getLocals().clear();
        body.getLocals().addAll(keep);
    }
}

