/*
 * Decompiled with CFR 0.152.
 */
package android.accounts;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ChooseAccountTypeActivity
extends Activity {
    private static final String TAG = "AccountChooser";
    private ArrayList<AuthInfo> mAuthenticatorInfosToDisplay;
    private HashMap<String, AuthInfo> mTypeToAuthenticatorInfo = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildTypeToAuthDescriptionMap() {
        AuthenticatorDescription[] authenticatorDescriptionArray = AccountManager.get(this).getAuthenticatorTypes();
        int n = authenticatorDescriptionArray.length;
        int n2 = 0;
        while (true) {
            Drawable drawable2;
            String string2;
            AuthenticatorDescription authenticatorDescription;
            block7: {
                if (n2 >= n) {
                    return;
                }
                authenticatorDescription = authenticatorDescriptionArray[n2];
                string2 = null;
                drawable2 = null;
                try {
                    String string3;
                    Context context = this.createPackageContext(authenticatorDescription.packageName, 0);
                    drawable2 = context.getDrawable(authenticatorDescription.iconId);
                    CharSequence charSequence = context.getResources().getText(authenticatorDescription.labelId);
                    string2 = null;
                    if (charSequence != null) {
                        string2 = charSequence.toString();
                    }
                    string2 = string3 = charSequence.toString();
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    if (Log.isLoggable(TAG, 5)) {
                        Log.w(TAG, "No icon name for account type " + authenticatorDescription.type);
                    }
                }
                catch (Resources.NotFoundException notFoundException) {
                    if (!Log.isLoggable(TAG, 5)) break block7;
                    Log.w(TAG, "No icon resource for account type " + authenticatorDescription.type);
                }
            }
            AuthInfo authInfo = new AuthInfo(authenticatorDescription, string2, drawable2);
            this.mTypeToAuthenticatorInfo.put(authenticatorDescription.type, authInfo);
            ++n2;
        }
    }

    private void setResultAndFinish(String string2) {
        Bundle bundle = new Bundle();
        bundle.putString("accountType", string2);
        this.setResult(-1, new Intent().putExtras(bundle));
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseAccountTypeActivity.setResultAndFinish: selected account type " + string2);
        }
        this.finish();
    }

    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "ChooseAccountTypeActivity.onCreate(savedInstanceState=" + bundle + ")");
        }
        String[] stringArray = this.getIntent().getStringArrayExtra("allowableAccountTypes");
        HashSet<String> hashSet = null;
        if (stringArray != null) {
            hashSet = new HashSet<String>(stringArray.length);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                hashSet.add(stringArray[i]);
            }
        }
        this.buildTypeToAuthDescriptionMap();
        this.mAuthenticatorInfosToDisplay = new ArrayList(this.mTypeToAuthenticatorInfo.size());
        for (Map.Entry<String, AuthInfo> entry : this.mTypeToAuthenticatorInfo.entrySet()) {
            String string2 = entry.getKey();
            AuthInfo authInfo = entry.getValue();
            if (hashSet != null && !hashSet.contains(string2)) continue;
            this.mAuthenticatorInfosToDisplay.add(authInfo);
        }
        if (this.mAuthenticatorInfosToDisplay.isEmpty()) {
            Bundle bundle2 = new Bundle();
            bundle2.putString("errorMessage", "no allowable account types");
            this.setResult(-1, new Intent().putExtras(bundle2));
            this.finish();
            return;
        }
        if (this.mAuthenticatorInfosToDisplay.size() == 1) {
            this.setResultAndFinish(this.mAuthenticatorInfosToDisplay.get((int)0).desc.type);
            return;
        }
        this.setContentView(17367129);
        ListView listView = (ListView)this.findViewById(16908298);
        listView.setAdapter(new AccountArrayAdapter((Context)this, 17367043, this.mAuthenticatorInfosToDisplay));
        listView.setChoiceMode(0);
        listView.setTextFilterEnabled(false);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                ChooseAccountTypeActivity.this.setResultAndFinish(((AuthInfo)((ChooseAccountTypeActivity)ChooseAccountTypeActivity.this).mAuthenticatorInfosToDisplay.get((int)n)).desc.type);
            }
        });
    }

    private static class AccountArrayAdapter
    extends ArrayAdapter<AuthInfo> {
        private ArrayList<AuthInfo> mInfos;
        private LayoutInflater mLayoutInflater;

        public AccountArrayAdapter(Context context, int n, ArrayList<AuthInfo> arrayList) {
            super(context, n, arrayList);
            this.mInfos = arrayList;
            this.mLayoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            ViewHolder viewHolder;
            if (view == null) {
                view = this.mLayoutInflater.inflate(17367128, null);
                viewHolder = new ViewHolder();
                viewHolder.text = (TextView)view.findViewById(16909095);
                viewHolder.icon = (ImageView)view.findViewById(16909094);
                view.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder)view.getTag();
            }
            viewHolder.text.setText(this.mInfos.get((int)n).name);
            viewHolder.icon.setImageDrawable(this.mInfos.get((int)n).drawable);
            return view;
        }
    }

    private static class AuthInfo {
        final AuthenticatorDescription desc;
        final Drawable drawable;
        final String name;

        AuthInfo(AuthenticatorDescription authenticatorDescription, String string2, Drawable drawable2) {
            this.desc = authenticatorDescription;
            this.name = string2;
            this.drawable = drawable2;
        }
    }

    private static class ViewHolder {
        ImageView icon;
        TextView text;

        private ViewHolder() {
        }
    }
}

