/*
 * Decompiled with CFR 0.152.
 */
package android.alsa;

import android.alsa.LineTokenizer;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class AlsaCardsParser {
    private static final String TAG = "AlsaCardsParser";
    private static LineTokenizer tokenizer_ = new LineTokenizer(" :[]");
    private Vector<AlsaCardRecord> cardRecords_ = new Vector();

    public void Log() {
        int n = this.getNumCardRecords();
        for (int i = 0; i < n; ++i) {
            Slog.w(TAG, "usb:" + this.getCardRecordAt(i).textFormat());
        }
    }

    public AlsaCardRecord getCardRecordAt(int n) {
        return this.cardRecords_.get(n);
    }

    public int getNumCardRecords() {
        return this.cardRecords_.size();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scan() {
        FileReader fileReader;
        this.cardRecords_.clear();
        File file = new File("/proc/asound/cards");
        try {
            String string2;
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                AlsaCardRecord alsaCardRecord = new AlsaCardRecord();
                alsaCardRecord.parse(string2, 0);
                alsaCardRecord.parse(bufferedReader.readLine(), 1);
                this.cardRecords_.add(alsaCardRecord);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        {
            fileReader.close();
            return;
        }
    }

    public class AlsaCardRecord {
        public String mCardDescription = "";
        public String mCardName = "";
        public int mCardNum = -1;
        public String mField1 = "";

        /*
         * Enabled aggressive block sorting
         */
        public boolean parse(String string2, int n) {
            if (n == 0) {
                int n2 = tokenizer_.nextToken(string2, 0);
                int n3 = tokenizer_.nextDelimiter(string2, n2);
                int n4 = tokenizer_.nextToken(string2, n3);
                int n5 = tokenizer_.nextDelimiter(string2, n4);
                this.mField1 = string2.substring(n4, n5);
                this.mCardName = string2.substring(tokenizer_.nextToken(string2, n5));
                return true;
            } else {
                int n6;
                if (n != 1 || (n6 = tokenizer_.nextToken(string2, 0)) == -1) return true;
                this.mCardDescription = string2.substring(n6);
                return true;
            }
        }

        public String textFormat() {
            return this.mCardName + " : " + this.mCardDescription;
        }
    }
}

