/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityThread;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class LocalActivityManager {
    static final int CREATED = 2;
    static final int DESTROYED = 5;
    static final int INITIALIZING = 1;
    static final int RESTORED = 0;
    static final int RESUMED = 4;
    static final int STARTED = 3;
    private static final String TAG = "LocalActivityManager";
    private static final boolean localLOGV;
    private final Map<String, LocalActivityRecord> mActivities = new HashMap<String, LocalActivityRecord>();
    private final ArrayList<LocalActivityRecord> mActivityArray = new ArrayList();
    private final ActivityThread mActivityThread = ActivityThread.currentActivityThread();
    private int mCurState = 1;
    private boolean mFinishing;
    private final Activity mParent;
    private LocalActivityRecord mResumed;
    private boolean mSingleMode;

    public LocalActivityManager(Activity activity, boolean bl) {
        this.mParent = activity;
        this.mSingleMode = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void moveToState(LocalActivityRecord localActivityRecord, int n) {
        block14: {
            if (localActivityRecord.curState == 0 || localActivityRecord.curState == 5) return;
            if (localActivityRecord.curState == 1) {
                HashMap<String, Object> hashMap = this.mParent.getLastNonConfigurationChildInstances();
                Object object = null;
                if (hashMap != null) {
                    object = hashMap.get(localActivityRecord.id);
                }
                Activity.NonConfigurationInstances nonConfigurationInstances = null;
                if (object != null) {
                    nonConfigurationInstances = new Activity.NonConfigurationInstances();
                    nonConfigurationInstances.activity = object;
                }
                if (localActivityRecord.activityInfo == null) {
                    localActivityRecord.activityInfo = this.mActivityThread.resolveActivityInfo(localActivityRecord.intent);
                }
                localActivityRecord.activity = this.mActivityThread.startActivityNow(this.mParent, localActivityRecord.id, localActivityRecord.intent, localActivityRecord.activityInfo, localActivityRecord, localActivityRecord.instanceState, nonConfigurationInstances);
                if (localActivityRecord.activity == null) return;
                localActivityRecord.window = localActivityRecord.activity.getWindow();
                localActivityRecord.instanceState = null;
                localActivityRecord.curState = 3;
                if (n != 4) return;
                this.mActivityThread.performResumeActivity(localActivityRecord, true);
                localActivityRecord.curState = 4;
                return;
            }
            switch (localActivityRecord.curState) {
                default: {
                    return;
                }
                case 2: {
                    if (n == 3) {
                        this.mActivityThread.performRestartActivity(localActivityRecord);
                        localActivityRecord.curState = 3;
                    }
                    if (n != 4) return;
                    this.mActivityThread.performRestartActivity(localActivityRecord);
                    this.mActivityThread.performResumeActivity(localActivityRecord, true);
                    localActivityRecord.curState = 4;
                    return;
                }
                case 3: {
                    if (n == 4) {
                        this.mActivityThread.performResumeActivity(localActivityRecord, true);
                        localActivityRecord.instanceState = null;
                        localActivityRecord.curState = 4;
                    }
                    if (n != 2) return;
                    this.mActivityThread.performStopActivity(localActivityRecord, false);
                    localActivityRecord.curState = 2;
                    return;
                }
                case 4: {
                    if (n == 3) {
                        this.performPause(localActivityRecord, this.mFinishing);
                        localActivityRecord.curState = 3;
                    }
                    if (n == 2) break block14;
                }
            }
            return;
        }
        this.performPause(localActivityRecord, this.mFinishing);
        this.mActivityThread.performStopActivity(localActivityRecord, false);
        localActivityRecord.curState = 2;
    }

    private Window performDestroy(LocalActivityRecord localActivityRecord, boolean bl) {
        Window window = localActivityRecord.window;
        if (localActivityRecord.curState == 4 && !bl) {
            this.performPause(localActivityRecord, bl);
        }
        this.mActivityThread.performDestroyActivity(localActivityRecord, bl);
        localActivityRecord.activity = null;
        localActivityRecord.window = null;
        if (bl) {
            localActivityRecord.instanceState = null;
        }
        localActivityRecord.curState = 5;
        return window;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void performPause(LocalActivityRecord localActivityRecord, boolean bl) {
        boolean bl2 = localActivityRecord.instanceState == null;
        Bundle bundle = this.mActivityThread.performPauseActivity(localActivityRecord, bl, bl2);
        if (bl2) {
            localActivityRecord.instanceState = bundle;
        }
    }

    public Window destroyActivity(String string2, boolean bl) {
        LocalActivityRecord localActivityRecord = this.mActivities.get(string2);
        Window window = null;
        if (localActivityRecord != null) {
            window = this.performDestroy(localActivityRecord, bl);
            if (bl) {
                this.mActivities.remove(string2);
                this.mActivityArray.remove(localActivityRecord);
            }
        }
        return window;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchCreate(Bundle bundle) {
        if (bundle != null) {
            for (String string2 : bundle.keySet()) {
                try {
                    Bundle bundle2 = bundle.getBundle(string2);
                    LocalActivityRecord localActivityRecord = this.mActivities.get(string2);
                    if (localActivityRecord != null) {
                        localActivityRecord.instanceState = bundle2;
                    }
                    LocalActivityRecord localActivityRecord2 = new LocalActivityRecord(string2, null);
                    localActivityRecord2.instanceState = bundle2;
                    this.mActivities.put(string2, localActivityRecord2);
                    this.mActivityArray.add(localActivityRecord2);
                }
                catch (Exception exception) {
                    Log.e(TAG, "Exception thrown when restoring LocalActivityManager state", exception);
                }
            }
        }
        this.mCurState = 2;
    }

    public void dispatchDestroy(boolean bl) {
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
            this.mActivityThread.performDestroyActivity(localActivityRecord, bl);
        }
        this.mActivities.clear();
        this.mActivityArray.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchPause(boolean bl) {
        if (bl) {
            this.mFinishing = true;
        }
        this.mCurState = 3;
        if (this.mSingleMode) {
            if (this.mResumed == null) return;
            this.moveToState(this.mResumed, 3);
            return;
        } else {
            int n = this.mActivityArray.size();
            for (int i = 0; i < n; ++i) {
                LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
                if (localActivityRecord.curState != 4) continue;
                this.moveToState(localActivityRecord, 3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dispatchResume() {
        this.mCurState = 4;
        if (this.mSingleMode) {
            if (this.mResumed == null) return;
            this.moveToState(this.mResumed, 4);
            return;
        } else {
            int n = this.mActivityArray.size();
            for (int i = 0; i < n; ++i) {
                this.moveToState(this.mActivityArray.get(i), 4);
            }
        }
    }

    public HashMap<String, Object> dispatchRetainNonConfigurationInstance() {
        HashMap<String, Object> hashMap = null;
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
            if (localActivityRecord == null || localActivityRecord.activity == null || (object = localActivityRecord.activity.onRetainNonConfigurationInstance()) == null) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            hashMap.put(localActivityRecord.id, object);
        }
        return hashMap;
    }

    public void dispatchStop() {
        this.mCurState = 2;
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            this.moveToState(this.mActivityArray.get(i), 2);
        }
    }

    public Activity getActivity(String string2) {
        LocalActivityRecord localActivityRecord = this.mActivities.get(string2);
        if (localActivityRecord != null) {
            return localActivityRecord.activity;
        }
        return null;
    }

    public Activity getCurrentActivity() {
        if (this.mResumed != null) {
            return this.mResumed.activity;
        }
        return null;
    }

    public String getCurrentId() {
        if (this.mResumed != null) {
            return this.mResumed.id;
        }
        return null;
    }

    public void removeAllActivities() {
        this.dispatchDestroy(true);
    }

    public Bundle saveInstanceState() {
        Bundle bundle = null;
        int n = this.mActivityArray.size();
        for (int i = 0; i < n; ++i) {
            LocalActivityRecord localActivityRecord = this.mActivityArray.get(i);
            if (bundle == null) {
                bundle = new Bundle();
            }
            if ((localActivityRecord.instanceState != null || localActivityRecord.curState == 4) && localActivityRecord.activity != null) {
                Bundle bundle2 = new Bundle();
                localActivityRecord.activity.performSaveInstanceState(bundle2);
                localActivityRecord.instanceState = bundle2;
            }
            if (localActivityRecord.instanceState == null) continue;
            bundle.putBundle(localActivityRecord.id, localActivityRecord.instanceState);
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Window startActivity(String string2, Intent intent) {
        LocalActivityRecord localActivityRecord;
        boolean bl;
        if (this.mCurState == 1) {
            throw new IllegalStateException("Activities can't be added until the containing group has been created.");
        }
        boolean bl2 = false;
        ActivityInfo activityInfo = null;
        LocalActivityRecord localActivityRecord2 = this.mActivities.get(string2);
        if (localActivityRecord2 == null) {
            localActivityRecord2 = new LocalActivityRecord(string2, intent);
            bl = true;
        } else {
            Intent intent2 = localActivityRecord2.intent;
            activityInfo = null;
            bl = false;
            bl2 = false;
            if (intent2 != null) {
                bl2 = localActivityRecord2.intent.filterEquals(intent);
                activityInfo = null;
                bl = false;
                if (bl2) {
                    activityInfo = localActivityRecord2.activityInfo;
                    bl = false;
                }
            }
        }
        if (activityInfo == null) {
            activityInfo = this.mActivityThread.resolveActivityInfo(intent);
        }
        if (this.mSingleMode && (localActivityRecord = this.mResumed) != null && localActivityRecord != localActivityRecord2 && this.mCurState == 4) {
            this.moveToState(localActivityRecord, 3);
        }
        if (bl) {
            this.mActivities.put(string2, localActivityRecord2);
            this.mActivityArray.add(localActivityRecord2);
        } else if (localActivityRecord2.activityInfo != null) {
            if (activityInfo == localActivityRecord2.activityInfo || activityInfo.name.equals(localActivityRecord2.activityInfo.name) && activityInfo.packageName.equals(localActivityRecord2.activityInfo.packageName)) {
                if (activityInfo.launchMode != 0 || (0x20000000 & intent.getFlags()) != 0) {
                    ArrayList<Intent> arrayList = new ArrayList<Intent>(1);
                    arrayList.add(intent);
                    this.mActivityThread.performNewIntents(localActivityRecord2, arrayList);
                    localActivityRecord2.intent = intent;
                    this.moveToState(localActivityRecord2, this.mCurState);
                    if (this.mSingleMode) {
                        this.mResumed = localActivityRecord2;
                    }
                    return localActivityRecord2.window;
                }
                if (bl2 && (0x4000000 & intent.getFlags()) == 0) {
                    localActivityRecord2.intent = intent;
                    this.moveToState(localActivityRecord2, this.mCurState);
                    if (this.mSingleMode) {
                        this.mResumed = localActivityRecord2;
                    }
                    return localActivityRecord2.window;
                }
            }
            this.performDestroy(localActivityRecord2, true);
        }
        localActivityRecord2.intent = intent;
        localActivityRecord2.curState = 1;
        localActivityRecord2.activityInfo = activityInfo;
        this.moveToState(localActivityRecord2, this.mCurState);
        if (this.mSingleMode) {
            this.mResumed = localActivityRecord2;
        }
        return localActivityRecord2.window;
    }

    private static class LocalActivityRecord
    extends Binder {
        Activity activity;
        ActivityInfo activityInfo;
        int curState = 0;
        final String id;
        Bundle instanceState;
        Intent intent;
        Window window;

        LocalActivityRecord(String string2, Intent intent) {
            this.id = string2;
            this.intent = intent;
        }
    }
}

