/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.TimePicker;

public class TimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TimePicker.OnTimeChangedListener {
    private static final String HOUR = "hour";
    private static final String IS_24_HOUR = "is24hour";
    private static final String MINUTE = "minute";
    private final int mInitialHourOfDay;
    private final int mInitialMinute;
    private final boolean mIs24HourView;
    private final TimePicker mTimePicker;
    private final OnTimeSetListener mTimeSetCallback;
    private final TimePicker.ValidationCallback mValidationCallback = new TimePicker.ValidationCallback(){

        @Override
        public void onValidationChanged(boolean bl) {
            Button button = TimePickerDialog.this.getButton(-1);
            if (button != null) {
                button.setEnabled(bl);
            }
        }
    };

    public TimePickerDialog(Context context, int n, OnTimeSetListener onTimeSetListener, int n2, int n3, boolean bl) {
        super(context, TimePickerDialog.resolveDialogTheme(context, n));
        this.mTimeSetCallback = onTimeSetListener;
        this.mInitialHourOfDay = n2;
        this.mInitialMinute = n3;
        this.mIs24HourView = bl;
        Context context2 = this.getContext();
        View view = LayoutInflater.from(context2).inflate(17367290, null);
        this.setView(view);
        this.setButton(-1, (CharSequence)context2.getString(17039370), this);
        this.setButton(-2, (CharSequence)context2.getString(0x1040000), this);
        this.setButtonPanelLayoutHint(1);
        this.mTimePicker = (TimePicker)view.findViewById(16909284);
        this.mTimePicker.setIs24HourView(this.mIs24HourView);
        this.mTimePicker.setCurrentHour(this.mInitialHourOfDay);
        this.mTimePicker.setCurrentMinute(this.mInitialMinute);
        this.mTimePicker.setOnTimeChangedListener(this);
        this.mTimePicker.setValidationCallback(this.mValidationCallback);
    }

    public TimePickerDialog(Context context, OnTimeSetListener onTimeSetListener, int n, int n2, boolean bl) {
        this(context, 0, onTimeSetListener, n, n2, bl);
    }

    static int resolveDialogTheme(Context context, int n) {
        if (n == 0) {
            TypedValue typedValue = new TypedValue();
            context.getTheme().resolveAttribute(16843934, typedValue, true);
            n = typedValue.resourceId;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        switch (n) {
            default: {
                return;
            }
            case -1: {
                if (this.mTimeSetCallback == null) return;
                this.mTimeSetCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute());
                return;
            }
        }
    }

    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        int n = bundle.getInt(HOUR);
        int n2 = bundle.getInt(MINUTE);
        this.mTimePicker.setIs24HourView(bundle.getBoolean(IS_24_HOUR));
        this.mTimePicker.setCurrentHour(n);
        this.mTimePicker.setCurrentMinute(n2);
    }

    @Override
    public Bundle onSaveInstanceState() {
        Bundle bundle = super.onSaveInstanceState();
        bundle.putInt(HOUR, this.mTimePicker.getCurrentHour());
        bundle.putInt(MINUTE, this.mTimePicker.getCurrentMinute());
        bundle.putBoolean(IS_24_HOUR, this.mTimePicker.is24HourView());
        return bundle;
    }

    @Override
    public void onTimeChanged(TimePicker timePicker, int n, int n2) {
    }

    public void updateTime(int n, int n2) {
        this.mTimePicker.setCurrentHour(n);
        this.mTimePicker.setCurrentMinute(n2);
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(TimePicker var1, int var2, int var3);
    }
}

