/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.OutputStream;

final class BluetoothOutputStream
extends OutputStream {
    private BluetoothSocket mSocket;

    BluetoothOutputStream(BluetoothSocket bluetoothSocket) {
        this.mSocket = bluetoothSocket;
    }

    @Override
    public void close() throws IOException {
        this.mSocket.close();
    }

    @Override
    public void flush() throws IOException {
        this.mSocket.flush();
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.mSocket.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("buffer is null");
        }
        if ((n | n2) < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("invalid offset or length");
        }
        this.mSocket.write(byArray, n, n2);
    }
}

