/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHealthAppConfiguration;
import android.bluetooth.IBluetoothHealthCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IBluetoothHealth
extends IInterface {
    public boolean connectChannelToSink(BluetoothDevice var1, BluetoothHealthAppConfiguration var2, int var3) throws RemoteException;

    public boolean connectChannelToSource(BluetoothDevice var1, BluetoothHealthAppConfiguration var2) throws RemoteException;

    public boolean disconnectChannel(BluetoothDevice var1, BluetoothHealthAppConfiguration var2, int var3) throws RemoteException;

    public List<BluetoothDevice> getConnectedHealthDevices() throws RemoteException;

    public int getHealthDeviceConnectionState(BluetoothDevice var1) throws RemoteException;

    public List<BluetoothDevice> getHealthDevicesMatchingConnectionStates(int[] var1) throws RemoteException;

    public ParcelFileDescriptor getMainChannelFd(BluetoothDevice var1, BluetoothHealthAppConfiguration var2) throws RemoteException;

    public boolean registerAppConfiguration(BluetoothHealthAppConfiguration var1, IBluetoothHealthCallback var2) throws RemoteException;

    public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothHealth {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetoothHealth";
        static final int TRANSACTION_connectChannelToSink = 4;
        static final int TRANSACTION_connectChannelToSource = 3;
        static final int TRANSACTION_disconnectChannel = 5;
        static final int TRANSACTION_getConnectedHealthDevices = 7;
        static final int TRANSACTION_getHealthDeviceConnectionState = 9;
        static final int TRANSACTION_getHealthDevicesMatchingConnectionStates = 8;
        static final int TRANSACTION_getMainChannelFd = 6;
        static final int TRANSACTION_registerAppConfiguration = 1;
        static final int TRANSACTION_unregisterAppConfiguration = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothHealth asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IBluetoothHealth) {
                return (IBluetoothHealth)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = parcel.readInt() != 0 ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.registerAppConfiguration(bluetoothHealthAppConfiguration, IBluetoothHealthCallback.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    int n3 = 0;
                    if (bl) {
                        n3 = 1;
                    }
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = parcel.readInt() != 0 ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.unregisterAppConfiguration(bluetoothHealthAppConfiguration);
                    parcel2.writeNoException();
                    int n4 = 0;
                    if (bl) {
                        n4 = 1;
                    }
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = parcel.readInt() != 0 ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.connectChannelToSource(bluetoothDevice, bluetoothHealthAppConfiguration);
                    parcel2.writeNoException();
                    int n5 = 0;
                    if (bl) {
                        n5 = 1;
                    }
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = parcel.readInt() != 0 ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.connectChannelToSink(bluetoothDevice, bluetoothHealthAppConfiguration, parcel.readInt());
                    parcel2.writeNoException();
                    int n6 = 0;
                    if (bl) {
                        n6 = 1;
                    }
                    parcel2.writeInt(n6);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = parcel.readInt() != 0 ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.disconnectChannel(bluetoothDevice, bluetoothHealthAppConfiguration, parcel.readInt());
                    parcel2.writeNoException();
                    int n7 = 0;
                    if (bl) {
                        n7 = 1;
                    }
                    parcel2.writeInt(n7);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration = parcel.readInt() != 0 ? BluetoothHealthAppConfiguration.CREATOR.createFromParcel(parcel) : null;
                    ParcelFileDescriptor parcelFileDescriptor = this.getMainChannelFd(bluetoothDevice, bluetoothHealthAppConfiguration);
                    parcel2.writeNoException();
                    if (parcelFileDescriptor != null) {
                        parcel2.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<BluetoothDevice> list = this.getConnectedHealthDevices();
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<BluetoothDevice> list = this.getHealthDevicesMatchingConnectionStates(parcel.createIntArray());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 9: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
            int n8 = this.getHealthDeviceConnectionState(bluetoothDevice);
            parcel2.writeNoException();
            parcel2.writeInt(n8);
            return true;
        }

        private static class Proxy
        implements IBluetoothHealth {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean connectChannelToSink(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block9: {
                    block8: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (bluetoothHealthAppConfiguration != null) {
                                parcel2.writeInt(1);
                                bluetoothHealthAppConfiguration.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            this.mRemote.transact(4, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean connectChannelToSource(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block9: {
                    block8: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (bluetoothHealthAppConfiguration != null) {
                                parcel2.writeInt(1);
                                bluetoothHealthAppConfiguration.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(3, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean disconnectChannel(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block9: {
                    block8: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (bluetoothHealthAppConfiguration != null) {
                                parcel2.writeInt(1);
                                bluetoothHealthAppConfiguration.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            this.mRemote.transact(5, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public List<BluetoothDevice> getConnectedHealthDevices() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<BluetoothDevice> arrayList = parcel2.createTypedArrayList(BluetoothDevice.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getHealthDeviceConnectionState(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<BluetoothDevice> getHealthDevicesMatchingConnectionStates(int[] nArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeIntArray(nArray);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<BluetoothDevice> arrayList = parcel2.createTypedArrayList(BluetoothDevice.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParcelFileDescriptor getMainChannelFd(BluetoothDevice bluetoothDevice, BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (bluetoothHealthAppConfiguration != null) {
                        parcel.writeInt(1);
                        bluetoothHealthAppConfiguration.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    ParcelFileDescriptor parcelFileDescriptor = parcel2.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel2) : null;
                    return parcelFileDescriptor;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean registerAppConfiguration(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration, IBluetoothHealthCallback iBluetoothHealthCallback) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothHealthAppConfiguration != null) {
                                parcel2.writeInt(1);
                                bluetoothHealthAppConfiguration.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            IBinder iBinder = iBluetoothHealthCallback != null ? iBluetoothHealthCallback.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            this.mRemote.transact(1, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean unregisterAppConfiguration(BluetoothHealthAppConfiguration bluetoothHealthAppConfiguration) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothHealthAppConfiguration != null) {
                                parcel2.writeInt(1);
                                bluetoothHealthAppConfiguration.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(2, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }
        }
    }
}

