/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.le.BluetoothLeUtils;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class AdvertiseData
implements Parcelable {
    public static final Parcelable.Creator<AdvertiseData> CREATOR = new Parcelable.Creator<AdvertiseData>(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public AdvertiseData createFromParcel(Parcel parcel) {
            Builder builder = new Builder();
            ArrayList arrayList = parcel.readArrayList(ParcelUuid.class.getClassLoader());
            if (arrayList != null) {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    builder.addServiceUuid((ParcelUuid)iterator.next());
                }
            }
            int n = parcel.readInt();
            for (int i = 0; i < n; ++i) {
                int n2 = parcel.readInt();
                if (parcel.readInt() != 1) continue;
                byte[] byArray = new byte[parcel.readInt()];
                parcel.readByteArray(byArray);
                builder.addManufacturerData(n2, byArray);
            }
            int n3 = parcel.readInt();
            for (int i = 0; i < n3; ++i) {
                ParcelUuid parcelUuid = (ParcelUuid)parcel.readParcelable(ParcelUuid.class.getClassLoader());
                if (parcel.readInt() != 1) continue;
                byte[] byArray = new byte[parcel.readInt()];
                parcel.readByteArray(byArray);
                builder.addServiceData(parcelUuid, byArray);
            }
            boolean bl = parcel.readByte() == 1;
            builder.setIncludeTxPowerLevel(bl);
            boolean bl2 = parcel.readByte() == 1;
            builder.setIncludeDeviceName(bl2);
            return builder.build();
        }

        public AdvertiseData[] newArray(int n) {
            return new AdvertiseData[n];
        }
    };
    private final boolean mIncludeDeviceName;
    private final boolean mIncludeTxPowerLevel;
    private final SparseArray<byte[]> mManufacturerSpecificData;
    private final Map<ParcelUuid, byte[]> mServiceData;
    private final List<ParcelUuid> mServiceUuids;

    private AdvertiseData(List<ParcelUuid> list, SparseArray<byte[]> sparseArray, Map<ParcelUuid, byte[]> map, boolean bl, boolean bl2) {
        this.mServiceUuids = list;
        this.mManufacturerSpecificData = sparseArray;
        this.mServiceData = map;
        this.mIncludeTxPowerLevel = bl;
        this.mIncludeDeviceName = bl2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (this == object) break block4;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                AdvertiseData advertiseData = (AdvertiseData)object;
                if (!Objects.equals(this.mServiceUuids, advertiseData.mServiceUuids) || !BluetoothLeUtils.equals(this.mManufacturerSpecificData, advertiseData.mManufacturerSpecificData) || !BluetoothLeUtils.equals(this.mServiceData, advertiseData.mServiceData) || this.mIncludeDeviceName != advertiseData.mIncludeDeviceName || this.mIncludeTxPowerLevel != advertiseData.mIncludeTxPowerLevel) break block5;
            }
            return true;
        }
        return false;
    }

    public boolean getIncludeDeviceName() {
        return this.mIncludeDeviceName;
    }

    public boolean getIncludeTxPowerLevel() {
        return this.mIncludeTxPowerLevel;
    }

    public SparseArray<byte[]> getManufacturerSpecificData() {
        return this.mManufacturerSpecificData;
    }

    public Map<ParcelUuid, byte[]> getServiceData() {
        return this.mServiceData;
    }

    public List<ParcelUuid> getServiceUuids() {
        return this.mServiceUuids;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.mServiceUuids, this.mManufacturerSpecificData, this.mServiceData, this.mIncludeDeviceName, this.mIncludeTxPowerLevel};
        return Objects.hash(objectArray);
    }

    public String toString() {
        return "AdvertiseData [mServiceUuids=" + this.mServiceUuids + ", mManufacturerSpecificData=" + BluetoothLeUtils.toString(this.mManufacturerSpecificData) + ", mServiceData=" + BluetoothLeUtils.toString(this.mServiceData) + ", mIncludeTxPowerLevel=" + this.mIncludeTxPowerLevel + ", mIncludeDeviceName=" + this.mIncludeDeviceName + "]";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeList(this.mServiceUuids);
        parcel.writeInt(this.mManufacturerSpecificData.size());
        for (int i = 0; i < this.mManufacturerSpecificData.size(); ++i) {
            parcel.writeInt(this.mManufacturerSpecificData.keyAt(i));
            byte[] byArray = this.mManufacturerSpecificData.valueAt(i);
            if (byArray == null) {
                parcel.writeInt(0);
                continue;
            }
            parcel.writeInt(n2);
            parcel.writeInt(byArray.length);
            parcel.writeByteArray(byArray);
        }
        parcel.writeInt(this.mServiceData.size());
        for (ParcelUuid parcelUuid : this.mServiceData.keySet()) {
            parcel.writeParcelable(parcelUuid, n);
            byte[] byArray = this.mServiceData.get(parcelUuid);
            if (byArray == null) {
                parcel.writeInt(0);
                continue;
            }
            parcel.writeInt(n2);
            parcel.writeInt(byArray.length);
            parcel.writeByteArray(byArray);
        }
        int n3 = this.getIncludeTxPowerLevel() ? n2 : 0;
        parcel.writeByte((byte)n3);
        if (!this.getIncludeDeviceName()) {
            n2 = 0;
        }
        parcel.writeByte((byte)n2);
    }

    public static final class Builder {
        private boolean mIncludeDeviceName;
        private boolean mIncludeTxPowerLevel;
        private SparseArray<byte[]> mManufacturerSpecificData;
        private Map<ParcelUuid, byte[]> mServiceData;
        private List<ParcelUuid> mServiceUuids = new ArrayList<ParcelUuid>();

        public Builder() {
            this.mManufacturerSpecificData = new SparseArray();
            this.mServiceData = new ArrayMap<ParcelUuid, byte[]>();
        }

        public Builder addManufacturerData(int n, byte[] byArray) {
            if (n < 0) {
                throw new IllegalArgumentException("invalid manufacturerId - " + n);
            }
            if (byArray == null) {
                throw new IllegalArgumentException("manufacturerSpecificData is null");
            }
            this.mManufacturerSpecificData.put(n, byArray);
            return this;
        }

        public Builder addServiceData(ParcelUuid parcelUuid, byte[] byArray) {
            if (parcelUuid == null || byArray == null) {
                throw new IllegalArgumentException("serviceDataUuid or serviceDataUuid is null");
            }
            this.mServiceData.put(parcelUuid, byArray);
            return this;
        }

        public Builder addServiceUuid(ParcelUuid parcelUuid) {
            if (parcelUuid == null) {
                throw new IllegalArgumentException("serivceUuids are null");
            }
            this.mServiceUuids.add(parcelUuid);
            return this;
        }

        public AdvertiseData build() {
            return new AdvertiseData(this.mServiceUuids, this.mManufacturerSpecificData, this.mServiceData, this.mIncludeTxPowerLevel, this.mIncludeDeviceName);
        }

        public Builder setIncludeDeviceName(boolean bl) {
            this.mIncludeDeviceName = bl;
            return this;
        }

        public Builder setIncludeTxPowerLevel(boolean bl) {
            this.mIncludeTxPowerLevel = bl;
            return this;
        }
    }
}

