/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothGattCallbackWrapper;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public final class BluetoothLeAdvertiser {
    private static final int FLAGS_FIELD_BYTES = 3;
    private static final int MANUFACTURER_SPECIFIC_DATA_LENGTH = 2;
    private static final int MAX_ADVERTISING_DATA_BYTES = 31;
    private static final int OVERHEAD_BYTES_PER_FIELD = 2;
    private static final int SERVICE_DATA_UUID_LENGTH = 2;
    private static final String TAG = "BluetoothLeAdvertiser";
    private BluetoothAdapter mBluetoothAdapter;
    private final IBluetoothManager mBluetoothManager;
    private final Handler mHandler;
    private final Map<AdvertiseCallback, AdvertiseCallbackWrapper> mLeAdvertisers = new HashMap<AdvertiseCallback, AdvertiseCallbackWrapper>();

    public BluetoothLeAdvertiser(IBluetoothManager iBluetoothManager) {
        this.mBluetoothManager = iBluetoothManager;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    private int byteLength(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    private void postStartFailure(final AdvertiseCallback advertiseCallback, final int n) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                advertiseCallback.onStartFailure(n);
            }
        });
    }

    private void postStartSuccess(final AdvertiseCallback advertiseCallback, final AdvertiseSettings advertiseSettings) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                advertiseCallback.onStartSuccess(advertiseSettings);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int totalBytes(AdvertiseData advertiseData) {
        if (advertiseData == null) {
            return 0;
        }
        int n = 3;
        if (advertiseData.getServiceUuids() != null) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (ParcelUuid parcelUuid : advertiseData.getServiceUuids()) {
                if (BluetoothUuid.is16BitUuid(parcelUuid)) {
                    ++n2;
                    continue;
                }
                if (BluetoothUuid.is32BitUuid(parcelUuid)) {
                    ++n3;
                    continue;
                }
                ++n4;
            }
            if (n2 != 0) {
                n += 2 + n2 * 2;
            }
            if (n3 != 0) {
                n += 2 + n3 * 4;
            }
            if (n4 != 0) {
                n += 2 + n4 * 16;
            }
        }
        for (ParcelUuid parcelUuid : advertiseData.getServiceData().keySet()) {
            n += 4 + this.byteLength(advertiseData.getServiceData().get(parcelUuid));
        }
        for (int i = 0; i < advertiseData.getManufacturerSpecificData().size(); ++i) {
            n += 4 + this.byteLength(advertiseData.getManufacturerSpecificData().valueAt(i));
        }
        if (advertiseData.getIncludeTxPowerLevel()) {
            n += 3;
        }
        if (!advertiseData.getIncludeDeviceName()) return n;
        if (this.mBluetoothAdapter.getName() == null) return n;
        return n + (2 + this.mBluetoothAdapter.getName().length());
    }

    public void cleanup() {
        this.mLeAdvertisers.clear();
    }

    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseCallback advertiseCallback) {
        this.startAdvertising(advertiseSettings, advertiseData, null, advertiseCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startAdvertising(AdvertiseSettings advertiseSettings, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseCallback advertiseCallback) {
        Map<AdvertiseCallback, AdvertiseCallbackWrapper> map = this.mLeAdvertisers;
        synchronized (map) {
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (advertiseCallback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            if (!this.mBluetoothAdapter.isMultipleAdvertisementSupported()) {
                this.postStartFailure(advertiseCallback, 5);
                return;
            }
            if (this.totalBytes(advertiseData) > 31 || this.totalBytes(advertiseData2) > 31) {
                this.postStartFailure(advertiseCallback, 1);
                return;
            }
            if (this.mLeAdvertisers.containsKey(advertiseCallback)) {
                this.postStartFailure(advertiseCallback, 3);
                return;
            }
            try {
                IBluetoothGatt iBluetoothGatt = this.mBluetoothManager.getBluetoothGatt();
                new AdvertiseCallbackWrapper(advertiseCallback, advertiseData, advertiseData2, advertiseSettings, iBluetoothGatt).startRegisteration();
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Failed to get Bluetooth gatt - ", remoteException);
                this.postStartFailure(advertiseCallback, 4);
                return;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopAdvertising(AdvertiseCallback advertiseCallback) {
        Map<AdvertiseCallback, AdvertiseCallbackWrapper> map = this.mLeAdvertisers;
        synchronized (map) {
            BluetoothLeUtils.checkAdapterStateOn(this.mBluetoothAdapter);
            if (advertiseCallback == null) {
                throw new IllegalArgumentException("callback cannot be null");
            }
            AdvertiseCallbackWrapper advertiseCallbackWrapper = this.mLeAdvertisers.get(advertiseCallback);
            if (advertiseCallbackWrapper == null) {
                return;
            }
            advertiseCallbackWrapper.stopAdvertising();
            return;
        }
    }

    private class AdvertiseCallbackWrapper
    extends BluetoothGattCallbackWrapper {
        private static final int LE_CALLBACK_TIMEOUT_MILLIS = 2000;
        private final AdvertiseCallback mAdvertiseCallback;
        private final AdvertiseData mAdvertisement;
        private final IBluetoothGatt mBluetoothGatt;
        private int mClientIf;
        private boolean mIsAdvertising = false;
        private final AdvertiseData mScanResponse;
        private final AdvertiseSettings mSettings;

        public AdvertiseCallbackWrapper(AdvertiseCallback advertiseCallback, AdvertiseData advertiseData, AdvertiseData advertiseData2, AdvertiseSettings advertiseSettings, IBluetoothGatt iBluetoothGatt) {
            this.mAdvertiseCallback = advertiseCallback;
            this.mAdvertisement = advertiseData;
            this.mScanResponse = advertiseData2;
            this.mSettings = advertiseSettings;
            this.mBluetoothGatt = iBluetoothGatt;
            this.mClientIf = 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onClientRegistered(int n, int n2) {
            Log.d(BluetoothLeAdvertiser.TAG, "onClientRegistered() - status=" + n + " clientIf=" + n2);
            synchronized (this) {
                if (n == 0) {
                    this.mClientIf = n2;
                    try {
                        this.mBluetoothGatt.startMultiAdvertising(this.mClientIf, this.mAdvertisement, this.mScanResponse, this.mSettings);
                        return;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothLeAdvertiser.TAG, "failed to start advertising", remoteException);
                    }
                }
                this.mClientIf = -1;
                this.notifyAll();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onMultiAdvertiseCallback(int n, boolean bl, AdvertiseSettings advertiseSettings) {
            synchronized (this) {
                if (bl) {
                    if (n == 0) {
                        this.mIsAdvertising = true;
                        BluetoothLeAdvertiser.this.postStartSuccess(this.mAdvertiseCallback, advertiseSettings);
                    } else {
                        BluetoothLeAdvertiser.this.postStartFailure(this.mAdvertiseCallback, n);
                    }
                } else {
                    try {
                        this.mBluetoothGatt.unregisterClient(this.mClientIf);
                        this.mClientIf = -1;
                        this.mIsAdvertising = false;
                        BluetoothLeAdvertiser.this.mLeAdvertisers.remove(this.mAdvertiseCallback);
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothLeAdvertiser.TAG, "remote exception when unregistering", remoteException);
                    }
                }
                this.notifyAll();
                return;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void startRegisteration() {
            synchronized (this) {
                if (this.mClientIf == -1) {
                    return;
                }
                try {
                    UUID uUID = UUID.randomUUID();
                    this.mBluetoothGatt.registerClient(new ParcelUuid(uUID), this);
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    Exception exception;
                    block13: {
                        exception = interruptedException;
                        break block13;
                        catch (RemoteException remoteException) {
                            exception = remoteException;
                        }
                    }
                    Log.e(BluetoothLeAdvertiser.TAG, "Failed to start registeration", exception);
                }
                if (this.mClientIf > 0 && this.mIsAdvertising) {
                    BluetoothLeAdvertiser.this.mLeAdvertisers.put(this.mAdvertiseCallback, this);
                } else if (this.mClientIf <= 0) {
                    BluetoothLeAdvertiser.this.postStartFailure(this.mAdvertiseCallback, 4);
                } else {
                    try {
                        this.mBluetoothGatt.unregisterClient(this.mClientIf);
                        this.mClientIf = -1;
                    }
                    catch (RemoteException remoteException) {
                        Log.e(BluetoothLeAdvertiser.TAG, "remote exception when unregistering", remoteException);
                    }
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void stopAdvertising() {
            synchronized (this) {
                block6: {
                    Exception exception;
                    try {
                        this.mBluetoothGatt.stopMultiAdvertising(this.mClientIf);
                        this.wait(2000L);
                        break block6;
                    }
                    catch (RemoteException remoteException) {
                        exception = remoteException;
                    }
                    catch (InterruptedException interruptedException) {
                        exception = interruptedException;
                    }
                    Log.e(BluetoothLeAdvertiser.TAG, "Failed to stop advertising", exception);
                }
                if (BluetoothLeAdvertiser.this.mLeAdvertisers.containsKey(this.mAdvertiseCallback)) {
                    BluetoothLeAdvertiser.this.mLeAdvertisers.remove(this.mAdvertiseCallback);
                }
                return;
            }
        }
    }
}

