/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;

public class ClipDescription
implements Parcelable {
    public static final Parcelable.Creator<ClipDescription> CREATOR = new Parcelable.Creator<ClipDescription>(){

        @Override
        public ClipDescription createFromParcel(Parcel parcel) {
            return new ClipDescription(parcel);
        }

        public ClipDescription[] newArray(int n) {
            return new ClipDescription[n];
        }
    };
    public static final String MIMETYPE_TEXT_HTML = "text/html";
    public static final String MIMETYPE_TEXT_INTENT = "text/vnd.android.intent";
    public static final String MIMETYPE_TEXT_PLAIN = "text/plain";
    public static final String MIMETYPE_TEXT_URILIST = "text/uri-list";
    final CharSequence mLabel;
    final String[] mMimeTypes;

    public ClipDescription(ClipDescription clipDescription) {
        this.mLabel = clipDescription.mLabel;
        this.mMimeTypes = clipDescription.mMimeTypes;
    }

    ClipDescription(Parcel parcel) {
        this.mLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.mMimeTypes = parcel.createStringArray();
    }

    public ClipDescription(CharSequence charSequence, String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("mimeTypes is null");
        }
        this.mLabel = charSequence;
        this.mMimeTypes = stringArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean compareMimeTypes(String string2, String string3) {
        int n = string3.length();
        if (n == 3 && string3.equals("*/*")) return true;
        int n2 = string3.indexOf(47);
        if (n2 <= 0) return false;
        if (n == n2 + 2 && string3.charAt(n2 + 1) == '*') {
            if (!string3.regionMatches(0, string2, 0, n2 + 1)) return false;
            return true;
        }
        if (string3.equals(string2)) return true;
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String[] filterMimeTypes(String string2) {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < this.mMimeTypes.length; ++i) {
            if (!ClipDescription.compareMimeTypes(this.mMimeTypes[i], string2)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(this.mMimeTypes[i]);
        }
        if (arrayList == null) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public String getMimeType(int n) {
        return this.mMimeTypes[n];
    }

    public int getMimeTypeCount() {
        return this.mMimeTypes.length;
    }

    public boolean hasMimeType(String string2) {
        for (int i = 0; i < this.mMimeTypes.length; ++i) {
            if (!ClipDescription.compareMimeTypes(this.mMimeTypes[i], string2)) continue;
            return true;
        }
        return false;
    }

    public boolean toShortString(StringBuilder stringBuilder) {
        boolean bl = true;
        for (int i = 0; i < this.mMimeTypes.length; ++i) {
            if (!bl) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.mMimeTypes[i]);
            bl = false;
        }
        if (this.mLabel != null) {
            if (!bl) {
                stringBuilder.append(' ');
            }
            bl = false;
            stringBuilder.append('\"');
            stringBuilder.append(this.mLabel);
            stringBuilder.append('\"');
        }
        return !bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("ClipDescription { ");
        this.toShortString(stringBuilder);
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }

    public void validate() {
        if (this.mMimeTypes == null) {
            throw new NullPointerException("null mime types");
        }
        if (this.mMimeTypes.length <= 0) {
            throw new IllegalArgumentException("must have at least 1 mime type");
        }
        for (int i = 0; i < this.mMimeTypes.length; ++i) {
            if (this.mMimeTypes[i] != null) continue;
            throw new NullPointerException("mime type at " + i + " is null");
        }
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        TextUtils.writeToParcel(this.mLabel, parcel, n);
        parcel.writeStringArray(this.mMimeTypes);
    }
}

