/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.PrintWriter;

public final class ComponentName
implements Parcelable,
Cloneable,
Comparable<ComponentName> {
    public static final Parcelable.Creator<ComponentName> CREATOR = new Parcelable.Creator<ComponentName>(){

        @Override
        public ComponentName createFromParcel(Parcel parcel) {
            return new ComponentName(parcel);
        }

        public ComponentName[] newArray(int n) {
            return new ComponentName[n];
        }
    };
    private final String mClass;
    private final String mPackage;

    public ComponentName(Context context, Class<?> clazz) {
        this.mPackage = context.getPackageName();
        this.mClass = clazz.getName();
    }

    public ComponentName(Context context, String string2) {
        if (string2 == null) {
            throw new NullPointerException("class name is null");
        }
        this.mPackage = context.getPackageName();
        this.mClass = string2;
    }

    public ComponentName(Parcel parcel) {
        this.mPackage = parcel.readString();
        if (this.mPackage == null) {
            throw new NullPointerException("package name is null");
        }
        this.mClass = parcel.readString();
        if (this.mClass == null) {
            throw new NullPointerException("class name is null");
        }
    }

    private ComponentName(String string2, Parcel parcel) {
        this.mPackage = string2;
        this.mClass = parcel.readString();
    }

    public ComponentName(String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException("package name is null");
        }
        if (string3 == null) {
            throw new NullPointerException("class name is null");
        }
        this.mPackage = string2;
        this.mClass = string3;
    }

    private static void appendShortClassName(StringBuilder stringBuilder, String string2, String string3) {
        if (string3.startsWith(string2)) {
            int n = string2.length();
            int n2 = string3.length();
            if (n2 > n && string3.charAt(n) == '.') {
                stringBuilder.append(string3, n, n2);
                return;
            }
        }
        stringBuilder.append(string3);
    }

    public static void appendShortString(StringBuilder stringBuilder, String string2, String string3) {
        stringBuilder.append(string2).append('/');
        ComponentName.appendShortClassName(stringBuilder, string2, string3);
    }

    private static void printShortClassName(PrintWriter printWriter, String string2, String string3) {
        if (string3.startsWith(string2)) {
            int n = string2.length();
            int n2 = string3.length();
            if (n2 > n && string3.charAt(n) == '.') {
                printWriter.write(string3, n, n2 - n);
                return;
            }
        }
        printWriter.print(string3);
    }

    public static void printShortString(PrintWriter printWriter, String string2, String string3) {
        printWriter.print(string2);
        printWriter.print('/');
        ComponentName.printShortClassName(printWriter, string2, string3);
    }

    public static ComponentName readFromParcel(Parcel parcel) {
        String string2 = parcel.readString();
        if (string2 != null) {
            return new ComponentName(string2, parcel);
        }
        return null;
    }

    public static ComponentName unflattenFromString(String string2) {
        int n = string2.indexOf(47);
        if (n < 0 || n + 1 >= string2.length()) {
            return null;
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        if (string4.length() > 0 && string4.charAt(0) == '.') {
            string4 = string3 + string4;
        }
        return new ComponentName(string3, string4);
    }

    public static void writeToParcel(ComponentName componentName, Parcel parcel) {
        if (componentName != null) {
            componentName.writeToParcel(parcel, 0);
            return;
        }
        parcel.writeString(null);
    }

    public void appendShortString(StringBuilder stringBuilder) {
        ComponentName.appendShortString(stringBuilder, this.mPackage, this.mClass);
    }

    public ComponentName clone() {
        return new ComponentName(this.mPackage, this.mClass);
    }

    @Override
    public int compareTo(ComponentName componentName) {
        int n = this.mPackage.compareTo(componentName.mPackage);
        if (n != 0) {
            return n;
        }
        return this.mClass.compareTo(componentName.mClass);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        ComponentName componentName;
        boolean bl = false;
        if (object == null) return bl;
        try {
            componentName = (ComponentName)object;
            boolean bl2 = this.mPackage.equals(componentName.mPackage);
            bl = false;
            if (!bl2) return bl;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        boolean bl3 = this.mClass.equals(componentName.mClass);
        bl = false;
        if (!bl3) return bl;
        return true;
    }

    public String flattenToShortString() {
        StringBuilder stringBuilder = new StringBuilder(this.mPackage.length() + this.mClass.length());
        ComponentName.appendShortString(stringBuilder, this.mPackage, this.mClass);
        return stringBuilder.toString();
    }

    public String flattenToString() {
        return this.mPackage + "/" + this.mClass;
    }

    public String getClassName() {
        return this.mClass;
    }

    public String getPackageName() {
        return this.mPackage;
    }

    public String getShortClassName() {
        if (this.mClass.startsWith(this.mPackage)) {
            int n = this.mPackage.length();
            int n2 = this.mClass.length();
            if (n2 > n && this.mClass.charAt(n) == '.') {
                return this.mClass.substring(n, n2);
            }
        }
        return this.mClass;
    }

    public int hashCode() {
        return this.mPackage.hashCode() + this.mClass.hashCode();
    }

    public String toShortString() {
        return "{" + this.mPackage + "/" + this.mClass + "}";
    }

    public String toString() {
        return "ComponentInfo{" + this.mPackage + "/" + this.mClass + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mPackage);
        parcel.writeString(this.mClass);
    }
}

