/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.AppOpsManager;
import android.content.ClipDescription;
import android.content.ComponentCallbacks2;
import android.content.ContentProviderNative;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.pm.PathPermission;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public abstract class ContentProvider
implements ComponentCallbacks2 {
    private static final String TAG = "ContentProvider";
    private String[] mAuthorities;
    private String mAuthority;
    private final ThreadLocal<String> mCallingPackage = new ThreadLocal();
    private Context mContext = null;
    private boolean mExported;
    private int mMyUid;
    private boolean mNoPerms;
    private PathPermission[] mPathPermissions;
    private String mReadPermission;
    private boolean mSingleUser;
    private Transport mTransport = new Transport();
    private String mWritePermission;

    public ContentProvider() {
    }

    public ContentProvider(Context context, String string2, String string3, PathPermission[] pathPermissionArray) {
        this.mContext = context;
        this.mReadPermission = string2;
        this.mWritePermission = string3;
        this.mPathPermissions = pathPermissionArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void attachInfo(Context context, ProviderInfo providerInfo, boolean bl) {
        AsyncTask.init();
        this.mNoPerms = bl;
        if (this.mContext == null) {
            this.mContext = context;
            if (context != null) {
                this.mTransport.mAppOpsManager = (AppOpsManager)context.getSystemService("appops");
            }
            this.mMyUid = Process.myUid();
            if (providerInfo != null) {
                this.setReadPermission(providerInfo.readPermission);
                this.setWritePermission(providerInfo.writePermission);
                this.setPathPermissions(providerInfo.pathPermissions);
                this.mExported = providerInfo.exported;
                boolean bl2 = (0x40000000 & providerInfo.flags) != 0;
                this.mSingleUser = bl2;
                this.setAuthorities(providerInfo.authority);
            }
            this.onCreate();
        }
    }

    public static ContentProvider coerceToLocalContentProvider(IContentProvider iContentProvider) {
        if (iContentProvider instanceof Transport) {
            return ((Transport)iContentProvider).getContentProvider();
        }
        return null;
    }

    public static String getAuthorityWithoutUserId(String string2) {
        if (string2 == null) {
            return null;
        }
        return string2.substring(1 + string2.lastIndexOf(64));
    }

    public static Uri getUriWithoutUserId(Uri uri) {
        if (uri == null) {
            return null;
        }
        Uri.Builder builder = uri.buildUpon();
        builder.authority(ContentProvider.getAuthorityWithoutUserId(uri.getAuthority()));
        return builder.build();
    }

    public static int getUserIdFromAuthority(String string2) {
        return ContentProvider.getUserIdFromAuthority(string2, -2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getUserIdFromAuthority(String string2, int n) {
        if (string2 == null) {
            return n;
        }
        int n2 = string2.lastIndexOf(64);
        if (n2 == -1) return n;
        String string3 = string2.substring(0, n2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            Log.w(TAG, "Error parsing userId.", numberFormatException);
            return -10000;
        }
    }

    public static int getUserIdFromUri(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, -2);
    }

    public static int getUserIdFromUri(Uri uri, int n) {
        if (uri == null) {
            return n;
        }
        return ContentProvider.getUserIdFromAuthority(uri.getAuthority(), n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uri maybeAddUserId(Uri uri, int n) {
        if (uri == null) {
            return null;
        }
        if (n == -2) return uri;
        if (!"content".equals(uri.getScheme())) return uri;
        if (ContentProvider.uriHasUserId(uri)) return uri;
        Uri.Builder builder = uri.buildUpon();
        builder.encodedAuthority("" + n + "@" + uri.getEncodedAuthority());
        return builder.build();
    }

    private String setCallingPackage(String string2) {
        String string3 = this.mCallingPackage.get();
        this.mCallingPackage.set(string2);
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean uriHasUserId(Uri uri) {
        return uri != null && !TextUtils.isEmpty(uri.getUserInfo());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateIncomingUri(Uri uri) throws SecurityException {
        String string2;
        String string3 = uri.getAuthority();
        int n = ContentProvider.getUserIdFromAuthority(string3, -2);
        if (n != -2 && n != this.mContext.getUserId()) {
            throw new SecurityException("trying to query a ContentProvider in user " + this.mContext.getUserId() + " with a uri belonging to user " + n);
        }
        if (this.matchesOurAuthorities(ContentProvider.getAuthorityWithoutUserId(string3))) return;
        String string4 = "The authority of the uri " + uri + " does not match the one of the " + "contentProvider: ";
        if (this.mAuthority != null) {
            string2 = string4 + this.mAuthority;
            throw new SecurityException(string2);
        }
        string2 = string4 + this.mAuthorities;
        throw new SecurityException(string2);
    }

    public ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
        int n = arrayList.size();
        ContentProviderResult[] contentProviderResultArray = new ContentProviderResult[n];
        for (int i = 0; i < n; ++i) {
            contentProviderResultArray[i] = arrayList.get(i).apply(this, contentProviderResultArray, i);
        }
        return contentProviderResultArray;
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        this.attachInfo(context, providerInfo, false);
    }

    public void attachInfoForTesting(Context context, ProviderInfo providerInfo) {
        this.attachInfo(context, providerInfo, true);
    }

    public int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        int n = contentValuesArray.length;
        for (int i = 0; i < n; ++i) {
            this.insert(uri, contentValuesArray[i]);
        }
        return n;
    }

    public Bundle call(String string2, String string3, Bundle bundle) {
        return null;
    }

    public Uri canonicalize(Uri uri) {
        return null;
    }

    boolean checkUser(int n, int n2, Context context) {
        return UserHandle.getUserId(n2) == context.getUserId() || this.mSingleUser || context.checkPermission("android.permission.INTERACT_ACROSS_USERS", n, n2) == 0;
    }

    public abstract int delete(Uri var1, String var2, String[] var3);

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.println("nothing to dump");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void enforceReadPermissionInner(Uri uri) throws SecurityException {
        String string2;
        Context context = this.getContext();
        int n = Binder.getCallingPid();
        int n2 = Binder.getCallingUid();
        if (UserHandle.isSameApp(n2, this.mMyUid)) {
            return;
        }
        boolean bl = this.mExported;
        String string3 = null;
        if (bl) {
            boolean bl2 = this.checkUser(n, n2, context);
            string3 = null;
            if (bl2) {
                String string4 = this.getReadPermission();
                string3 = null;
                if (string4 != null) {
                    if (context.checkPermission(string4, n, n2) == 0) return;
                    string3 = string4;
                }
                boolean bl3 = string4 == null;
                PathPermission[] pathPermissionArray = this.getPathPermissions();
                if (pathPermissionArray != null) {
                    String string5 = uri.getPath();
                    for (PathPermission pathPermission : pathPermissionArray) {
                        String string6 = pathPermission.getReadPermission();
                        if (string6 == null || !pathPermission.match(string5)) continue;
                        if (context.checkPermission(string6, n, n2) == 0) return;
                        bl3 = false;
                        string3 = string6;
                    }
                }
                if (bl3) return;
            }
        }
        if (context.checkUriPermission(uri, n, n2, 1) == 0) return;
        if (this.mExported) {
            string2 = " requires " + string3 + ", or grantUriPermission()";
            throw new SecurityException("Permission Denial: reading " + this.getClass().getName() + " uri " + uri + " from pid=" + n + ", uid=" + n2 + string2);
        }
        string2 = " requires the provider be exported, or grantUriPermission()";
        throw new SecurityException("Permission Denial: reading " + this.getClass().getName() + " uri " + uri + " from pid=" + n + ", uid=" + n2 + string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void enforceWritePermissionInner(Uri uri) throws SecurityException {
        String string2;
        Context context = this.getContext();
        int n = Binder.getCallingPid();
        int n2 = Binder.getCallingUid();
        if (UserHandle.isSameApp(n2, this.mMyUid)) {
            return;
        }
        boolean bl = this.mExported;
        String string3 = null;
        if (bl) {
            boolean bl2 = this.checkUser(n, n2, context);
            string3 = null;
            if (bl2) {
                String string4 = this.getWritePermission();
                string3 = null;
                if (string4 != null) {
                    if (context.checkPermission(string4, n, n2) == 0) return;
                    string3 = string4;
                }
                boolean bl3 = string4 == null;
                PathPermission[] pathPermissionArray = this.getPathPermissions();
                if (pathPermissionArray != null) {
                    String string5 = uri.getPath();
                    for (PathPermission pathPermission : pathPermissionArray) {
                        String string6 = pathPermission.getWritePermission();
                        if (string6 == null || !pathPermission.match(string5)) continue;
                        if (context.checkPermission(string6, n, n2) == 0) return;
                        bl3 = false;
                        string3 = string6;
                    }
                }
                if (bl3) return;
            }
        }
        if (context.checkUriPermission(uri, n, n2, 2) == 0) return;
        if (this.mExported) {
            string2 = " requires " + string3 + ", or grantUriPermission()";
            throw new SecurityException("Permission Denial: writing " + this.getClass().getName() + " uri " + uri + " from pid=" + n + ", uid=" + n2 + string2);
        }
        string2 = " requires the provider be exported, or grantUriPermission()";
        throw new SecurityException("Permission Denial: writing " + this.getClass().getName() + " uri " + uri + " from pid=" + n + ", uid=" + n2 + string2);
    }

    public AppOpsManager getAppOpsManager() {
        return this.mTransport.mAppOpsManager;
    }

    public final String getCallingPackage() {
        String string2 = this.mCallingPackage.get();
        if (string2 != null) {
            this.mTransport.mAppOpsManager.checkPackage(Binder.getCallingUid(), string2);
        }
        return string2;
    }

    public final Context getContext() {
        return this.mContext;
    }

    public IContentProvider getIContentProvider() {
        return this.mTransport;
    }

    public final PathPermission[] getPathPermissions() {
        return this.mPathPermissions;
    }

    public final String getReadPermission() {
        return this.mReadPermission;
    }

    public String[] getStreamTypes(Uri uri, String string2) {
        return null;
    }

    public abstract String getType(Uri var1);

    public final String getWritePermission() {
        return this.mWritePermission;
    }

    public abstract Uri insert(Uri var1, ContentValues var2);

    protected boolean isTemporary() {
        return false;
    }

    protected final boolean matchesOurAuthorities(String string2) {
        if (this.mAuthority != null) {
            return this.mAuthority.equals(string2);
        }
        if (this.mAuthorities != null) {
            int n = this.mAuthorities.length;
            for (int i = 0; i < n; ++i) {
                if (!this.mAuthorities[i].equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
    }

    public abstract boolean onCreate();

    @Override
    public void onLowMemory() {
    }

    @Override
    public void onTrimMemory(int n) {
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
        ParcelFileDescriptor parcelFileDescriptor = this.openFile(uri, string2);
        if (parcelFileDescriptor != null) {
            return new AssetFileDescriptor(parcelFileDescriptor, 0L, -1L);
        }
        return null;
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return this.openAssetFile(uri, string2);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        throw new FileNotFoundException("No files supported by provider at " + uri);
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return this.openFile(uri, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final ParcelFileDescriptor openFileHelper(Uri uri, String string2) throws FileNotFoundException {
        Cursor cursor = this.query(uri, new String[]{"_data"}, null, null, null);
        int n = 0;
        if (cursor != null) {
            n = cursor.getCount();
        }
        if (n != 1) {
            if (cursor != null) {
                cursor.close();
            }
            if (n == 0) {
                throw new FileNotFoundException("No entry for " + uri);
            }
            throw new FileNotFoundException("Multiple items at " + uri);
        }
        cursor.moveToFirst();
        int n2 = cursor.getColumnIndex("_data");
        String string3 = n2 >= 0 ? cursor.getString(n2) : null;
        cursor.close();
        if (string3 == null) {
            throw new FileNotFoundException("Column _data not found.");
        }
        int n3 = ParcelFileDescriptor.parseMode(string2);
        return ParcelFileDescriptor.open(new File(string3), n3);
    }

    public <T> ParcelFileDescriptor openPipeHelper(final Uri uri, final String string2, final Bundle bundle, final T t, final PipeDataWriter<T> pipeDataWriter) throws FileNotFoundException {
        try {
            final ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            new AsyncTask<Object, Object, Object>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                protected Object doInBackground(Object ... objectArray) {
                    pipeDataWriter.writeDataToPipe(parcelFileDescriptorArray[1], uri, string2, bundle, t);
                    try {
                        parcelFileDescriptorArray[1].close();
                        return null;
                    }
                    catch (IOException iOException) {
                        Log.w(ContentProvider.TAG, "Failure closing pipe", iOException);
                        return null;
                    }
                }
            }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[0];
            return parcelFileDescriptor;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("failure making pipe");
        }
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        if ("*/*".equals(string2)) {
            return this.openAssetFile(uri, "r");
        }
        String string3 = this.getType(uri);
        if (string3 != null && ClipDescription.compareMimeTypes(string3, string2)) {
            return this.openAssetFile(uri, "r");
        }
        throw new FileNotFoundException("Can't open " + uri + " as type " + string2);
    }

    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return this.openTypedAssetFile(uri, string2, bundle);
    }

    public abstract Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5);

    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) {
        return this.query(uri, stringArray, string2, stringArray2, string3);
    }

    public Uri rejectInsert(Uri uri, ContentValues contentValues) {
        return uri.buildUpon().appendPath("0").build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cursor rejectQuery(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) {
        String string4;
        if (string2 == null || string2.isEmpty()) {
            string4 = "'A' = 'B'";
            return this.query(uri, stringArray, string4, stringArray2, string3, cancellationSignal);
        }
        string4 = "'A' = 'B' AND (" + string2 + ")";
        return this.query(uri, stringArray, string4, stringArray2, string3, cancellationSignal);
    }

    public final void setAppOps(int n, int n2) {
        if (!this.mNoPerms) {
            this.mTransport.mReadOp = n;
            this.mTransport.mWriteOp = n2;
        }
    }

    protected final void setAuthorities(String string2) {
        block3: {
            block2: {
                if (string2 == null) break block2;
                if (string2.indexOf(59) != -1) break block3;
                this.mAuthority = string2;
                this.mAuthorities = null;
            }
            return;
        }
        this.mAuthority = null;
        this.mAuthorities = string2.split(";");
    }

    protected final void setPathPermissions(PathPermission[] pathPermissionArray) {
        this.mPathPermissions = pathPermissionArray;
    }

    protected final void setReadPermission(String string2) {
        this.mReadPermission = string2;
    }

    protected final void setWritePermission(String string2) {
        this.mWritePermission = string2;
    }

    public void shutdown() {
        Log.w(TAG, "implement ContentProvider shutdown() to make sure all database connections are gracefully shutdown");
    }

    public Uri uncanonicalize(Uri uri) {
        return uri;
    }

    public abstract int update(Uri var1, ContentValues var2, String var3, String[] var4);

    public static interface PipeDataWriter<T> {
        public void writeDataToPipe(ParcelFileDescriptor var1, Uri var2, String var3, Bundle var4, T var5);
    }

    class Transport
    extends ContentProviderNative {
        AppOpsManager mAppOpsManager = null;
        int mReadOp = -1;
        int mWriteOp = -1;

        Transport() {
        }

        private void enforceFilePermission(String string2, Uri uri, String string3) throws FileNotFoundException, SecurityException {
            if (string3 != null && string3.indexOf(119) != -1 ? this.enforceWritePermission(string2, uri) != 0 : this.enforceReadPermission(string2, uri) != 0) {
                throw new FileNotFoundException("App op not allowed");
            }
        }

        private int enforceReadPermission(String string2, Uri uri) throws SecurityException {
            ContentProvider.this.enforceReadPermissionInner(uri);
            if (this.mReadOp != -1) {
                return this.mAppOpsManager.noteOp(this.mReadOp, Binder.getCallingUid(), string2);
            }
            return 0;
        }

        private int enforceWritePermission(String string2, Uri uri) throws SecurityException {
            ContentProvider.this.enforceWritePermissionInner(uri);
            if (this.mWriteOp != -1) {
                return this.mAppOpsManager.noteOp(this.mWriteOp, Binder.getCallingUid(), string2);
            }
            return 0;
        }

        @Override
        public ContentProviderResult[] applyBatch(String string2, ArrayList<ContentProviderOperation> arrayList) throws OperationApplicationException {
            int n;
            ContentProviderResult[] contentProviderResultArray;
            int n2 = arrayList.size();
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                ContentProviderOperation contentProviderOperation = arrayList.get(i);
                Uri uri = contentProviderOperation.getUri();
                ContentProvider.this.validateIncomingUri(uri);
                nArray[i] = ContentProvider.getUserIdFromUri(uri);
                if (nArray[i] != -2) {
                    ContentProviderOperation contentProviderOperation2 = new ContentProviderOperation(contentProviderOperation, true);
                    arrayList.set(i, contentProviderOperation2);
                    contentProviderOperation = contentProviderOperation2;
                }
                if (contentProviderOperation.isReadOperation() && this.enforceReadPermission(string2, uri) != 0) {
                    throw new OperationApplicationException("App op not allowed", 0);
                }
                if (!contentProviderOperation.isWriteOperation() || this.enforceWritePermission(string2, uri) == 0) continue;
                throw new OperationApplicationException("App op not allowed", 0);
            }
            String string3 = ContentProvider.this.setCallingPackage(string2);
            try {
                contentProviderResultArray = ContentProvider.this.applyBatch(arrayList);
                n = 0;
            }
            catch (Throwable throwable) {
                ContentProvider.this.setCallingPackage(string3);
                throw throwable;
            }
            while (true) {
                if (n >= contentProviderResultArray.length) break;
                if (nArray[n] != -2) {
                    contentProviderResultArray[n] = new ContentProviderResult(contentProviderResultArray[n], nArray[n]);
                }
                ++n;
                continue;
                break;
            }
            ContentProvider.this.setCallingPackage(string3);
            return contentProviderResultArray;
        }

        @Override
        public int bulkInsert(String string2, Uri uri, ContentValues[] contentValuesArray) {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceWritePermission(string2, uri2) != 0) {
                return 0;
            }
            String string3 = ContentProvider.this.setCallingPackage(string2);
            try {
                int n = ContentProvider.this.bulkInsert(uri2, contentValuesArray);
                return n;
            }
            finally {
                ContentProvider.this.setCallingPackage(string3);
            }
        }

        @Override
        public Bundle call(String string2, String string3, String string4, Bundle bundle) {
            String string5 = ContentProvider.this.setCallingPackage(string2);
            try {
                Bundle bundle2 = ContentProvider.this.call(string3, string4, bundle);
                return bundle2;
            }
            finally {
                ContentProvider.this.setCallingPackage(string5);
            }
        }

        @Override
        public Uri canonicalize(String string2, Uri uri) {
            ContentProvider.this.validateIncomingUri(uri);
            int n = ContentProvider.getUserIdFromUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceReadPermission(string2, uri2) != 0) {
                return null;
            }
            String string3 = ContentProvider.this.setCallingPackage(string2);
            try {
                Uri uri3 = ContentProvider.maybeAddUserId(ContentProvider.this.canonicalize(uri2), n);
                return uri3;
            }
            finally {
                ContentProvider.this.setCallingPackage(string3);
            }
        }

        @Override
        public ICancellationSignal createCancellationSignal() {
            return CancellationSignal.createTransport();
        }

        @Override
        public int delete(String string2, Uri uri, String string3, String[] stringArray) {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceWritePermission(string2, uri2) != 0) {
                return 0;
            }
            String string4 = ContentProvider.this.setCallingPackage(string2);
            try {
                int n = ContentProvider.this.delete(uri2, string3, stringArray);
                return n;
            }
            finally {
                ContentProvider.this.setCallingPackage(string4);
            }
        }

        ContentProvider getContentProvider() {
            return ContentProvider.this;
        }

        @Override
        public String getProviderName() {
            return this.getContentProvider().getClass().getName();
        }

        @Override
        public String[] getStreamTypes(Uri uri, String string2) {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            return ContentProvider.this.getStreamTypes(uri2, string2);
        }

        @Override
        public String getType(Uri uri) {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            return ContentProvider.this.getType(uri2);
        }

        @Override
        public Uri insert(String string2, Uri uri, ContentValues contentValues) {
            ContentProvider.this.validateIncomingUri(uri);
            int n = ContentProvider.getUserIdFromUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceWritePermission(string2, uri2) != 0) {
                return ContentProvider.this.rejectInsert(uri2, contentValues);
            }
            String string3 = ContentProvider.this.setCallingPackage(string2);
            try {
                Uri uri3 = ContentProvider.maybeAddUserId(ContentProvider.this.insert(uri2, contentValues), n);
                return uri3;
            }
            finally {
                ContentProvider.this.setCallingPackage(string3);
            }
        }

        @Override
        public AssetFileDescriptor openAssetFile(String string2, Uri uri, String string3, ICancellationSignal iCancellationSignal) throws FileNotFoundException {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            this.enforceFilePermission(string2, uri2, string3);
            String string4 = ContentProvider.this.setCallingPackage(string2);
            try {
                AssetFileDescriptor assetFileDescriptor = ContentProvider.this.openAssetFile(uri2, string3, CancellationSignal.fromTransport(iCancellationSignal));
                return assetFileDescriptor;
            }
            finally {
                ContentProvider.this.setCallingPackage(string4);
            }
        }

        @Override
        public ParcelFileDescriptor openFile(String string2, Uri uri, String string3, ICancellationSignal iCancellationSignal) throws FileNotFoundException {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            this.enforceFilePermission(string2, uri2, string3);
            String string4 = ContentProvider.this.setCallingPackage(string2);
            try {
                ParcelFileDescriptor parcelFileDescriptor = ContentProvider.this.openFile(uri2, string3, CancellationSignal.fromTransport(iCancellationSignal));
                return parcelFileDescriptor;
            }
            finally {
                ContentProvider.this.setCallingPackage(string4);
            }
        }

        @Override
        public AssetFileDescriptor openTypedAssetFile(String string2, Uri uri, String string3, Bundle bundle, ICancellationSignal iCancellationSignal) throws FileNotFoundException {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            this.enforceFilePermission(string2, uri2, "r");
            String string4 = ContentProvider.this.setCallingPackage(string2);
            try {
                AssetFileDescriptor assetFileDescriptor = ContentProvider.this.openTypedAssetFile(uri2, string3, bundle, CancellationSignal.fromTransport(iCancellationSignal));
                return assetFileDescriptor;
            }
            finally {
                ContentProvider.this.setCallingPackage(string4);
            }
        }

        @Override
        public Cursor query(String string2, Uri uri, String[] stringArray, String string3, String[] stringArray2, String string4, ICancellationSignal iCancellationSignal) {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceReadPermission(string2, uri2) != 0) {
                return ContentProvider.this.rejectQuery(uri2, stringArray, string3, stringArray2, string4, CancellationSignal.fromTransport(iCancellationSignal));
            }
            String string5 = ContentProvider.this.setCallingPackage(string2);
            try {
                Cursor cursor = ContentProvider.this.query(uri2, stringArray, string3, stringArray2, string4, CancellationSignal.fromTransport(iCancellationSignal));
                return cursor;
            }
            finally {
                ContentProvider.this.setCallingPackage(string5);
            }
        }

        @Override
        public Uri uncanonicalize(String string2, Uri uri) {
            ContentProvider.this.validateIncomingUri(uri);
            int n = ContentProvider.getUserIdFromUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceReadPermission(string2, uri2) != 0) {
                return null;
            }
            String string3 = ContentProvider.this.setCallingPackage(string2);
            try {
                Uri uri3 = ContentProvider.maybeAddUserId(ContentProvider.this.uncanonicalize(uri2), n);
                return uri3;
            }
            finally {
                ContentProvider.this.setCallingPackage(string3);
            }
        }

        @Override
        public int update(String string2, Uri uri, ContentValues contentValues, String string3, String[] stringArray) {
            ContentProvider.this.validateIncomingUri(uri);
            Uri uri2 = ContentProvider.getUriWithoutUserId(uri);
            if (this.enforceWritePermission(string2, uri2) != 0) {
                return 0;
            }
            String string4 = ContentProvider.this.setCallingPackage(string2);
            try {
                int n = ContentProvider.this.update(uri2, contentValues, string3, stringArray);
                return n;
            }
            finally {
                ContentProvider.this.setCallingPackage(string4);
            }
        }
    }
}

