/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.List;

public interface ILauncherApps
extends IInterface {
    public void addOnAppsChangedListener(IOnAppsChangedListener var1) throws RemoteException;

    public List<ResolveInfo> getLauncherActivities(String var1, UserHandle var2) throws RemoteException;

    public boolean isActivityEnabled(ComponentName var1, UserHandle var2) throws RemoteException;

    public boolean isPackageEnabled(String var1, UserHandle var2) throws RemoteException;

    public void removeOnAppsChangedListener(IOnAppsChangedListener var1) throws RemoteException;

    public ResolveInfo resolveActivity(Intent var1, UserHandle var2) throws RemoteException;

    public void showAppDetailsAsUser(ComponentName var1, Rect var2, Bundle var3, UserHandle var4) throws RemoteException;

    public void startActivityAsUser(ComponentName var1, Rect var2, Bundle var3, UserHandle var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILauncherApps {
        private static final String DESCRIPTOR = "android.content.pm.ILauncherApps";
        static final int TRANSACTION_addOnAppsChangedListener = 1;
        static final int TRANSACTION_getLauncherActivities = 3;
        static final int TRANSACTION_isActivityEnabled = 8;
        static final int TRANSACTION_isPackageEnabled = 7;
        static final int TRANSACTION_removeOnAppsChangedListener = 2;
        static final int TRANSACTION_resolveActivity = 4;
        static final int TRANSACTION_showAppDetailsAsUser = 6;
        static final int TRANSACTION_startActivityAsUser = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILauncherApps asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ILauncherApps) {
                return (ILauncherApps)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addOnAppsChangedListener(IOnAppsChangedListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removeOnAppsChangedListener(IOnAppsChangedListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.getLauncherActivities(string2, userHandle);
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
                    ResolveInfo resolveInfo = this.resolveActivity(intent, userHandle);
                    parcel2.writeNoException();
                    if (resolveInfo != null) {
                        parcel2.writeInt(1);
                        resolveInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
                    this.startActivityAsUser(componentName, rect, bundle, userHandle);
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
                    this.showAppDetailsAsUser(componentName, rect, bundle, userHandle);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.isPackageEnabled(string3, userHandle);
                    parcel2.writeNoException();
                    int n3 = 0;
                    if (bl) {
                        n3 = 1;
                    }
                    parcel2.writeInt(n3);
                    return true;
                }
                case 8: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
            UserHandle userHandle = parcel.readInt() != 0 ? UserHandle.CREATOR.createFromParcel(parcel) : null;
            boolean bl = this.isActivityEnabled(componentName, userHandle);
            parcel2.writeNoException();
            int n4 = 0;
            if (bl) {
                n4 = 1;
            }
            parcel2.writeInt(n4);
            return true;
        }

        private static class Proxy
        implements ILauncherApps {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addOnAppsChangedListener(IOnAppsChangedListener iOnAppsChangedListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iOnAppsChangedListener != null ? iOnAppsChangedListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> getLauncherActivities(String string2, UserHandle userHandle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    if (userHandle != null) {
                        parcel.writeInt(1);
                        userHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isActivityEnabled(ComponentName componentName, UserHandle userHandle) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block9: {
                    block8: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (componentName != null) {
                                parcel2.writeInt(1);
                                componentName.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (userHandle != null) {
                                parcel2.writeInt(1);
                                userHandle.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(8, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isPackageEnabled(String string2, UserHandle userHandle) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            if (userHandle != null) {
                                parcel2.writeInt(1);
                                userHandle.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(7, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void removeOnAppsChangedListener(IOnAppsChangedListener iOnAppsChangedListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iOnAppsChangedListener != null ? iOnAppsChangedListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResolveInfo resolveActivity(Intent intent, UserHandle userHandle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (userHandle != null) {
                        parcel.writeInt(1);
                        userHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    ResolveInfo resolveInfo = parcel2.readInt() != 0 ? ResolveInfo.CREATOR.createFromParcel(parcel2) : null;
                    return resolveInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void showAppDetailsAsUser(ComponentName componentName, Rect rect, Bundle bundle, UserHandle userHandle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (userHandle != null) {
                        parcel.writeInt(1);
                        userHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void startActivityAsUser(ComponentName componentName, Rect rect, Bundle bundle, UserHandle userHandle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (userHandle != null) {
                        parcel.writeInt(1);
                        userHandle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

