/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageDeleteObserver2;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.KeySet;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageInfo;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.VerificationParams;
import android.content.pm.VerifierDeviceIdentity;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPackageManager
extends IInterface {
    public boolean activitySupportsIntent(ComponentName var1, Intent var2, String var3) throws RemoteException;

    public void addCrossProfileIntentFilter(IntentFilter var1, String var2, int var3, int var4, int var5, int var6) throws RemoteException;

    public void addPackageToPreferred(String var1) throws RemoteException;

    public boolean addPermission(PermissionInfo var1) throws RemoteException;

    public boolean addPermissionAsync(PermissionInfo var1) throws RemoteException;

    public void addPersistentPreferredActivity(IntentFilter var1, ComponentName var2, int var3) throws RemoteException;

    public void addPreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4, int var5) throws RemoteException;

    public boolean canForwardTo(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public String[] canonicalToCurrentPackageNames(String[] var1) throws RemoteException;

    public int checkPermission(String var1, String var2) throws RemoteException;

    public int checkSignatures(String var1, String var2) throws RemoteException;

    public int checkUidPermission(String var1, int var2) throws RemoteException;

    public int checkUidSignatures(int var1, int var2) throws RemoteException;

    public void clearApplicationUserData(String var1, IPackageDataObserver var2, int var3) throws RemoteException;

    public void clearCrossProfileIntentFilters(int var1, String var2, int var3) throws RemoteException;

    public void clearPackagePersistentPreferredActivities(String var1, int var2) throws RemoteException;

    public void clearPackagePreferredActivities(String var1) throws RemoteException;

    public String[] currentToCanonicalPackageNames(String[] var1) throws RemoteException;

    public void deleteApplicationCacheFiles(String var1, IPackageDataObserver var2) throws RemoteException;

    public void deleteBundledSystemPackages(String[] var1) throws RemoteException;

    public void deletePackage(String var1, IPackageDeleteObserver2 var2, int var3, int var4) throws RemoteException;

    public void deletePackageAsUser(String var1, IPackageDeleteObserver var2, int var3, int var4) throws RemoteException;

    public void enterSafeMode() throws RemoteException;

    public void extendVerificationTimeout(int var1, int var2, long var3) throws RemoteException;

    public void finishPackageInstall(int var1) throws RemoteException;

    public void forceDexOpt(String var1) throws RemoteException;

    public void freeStorage(long var1, IntentSender var3) throws RemoteException;

    public void freeStorageAndNotify(long var1, IPackageDataObserver var3) throws RemoteException;

    public ActivityInfo getActivityInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    public List<PermissionGroupInfo> getAllPermissionGroups(int var1) throws RemoteException;

    public String[] getAppOpPermissionPackages(String var1) throws RemoteException;

    public int getApplicationEnabledSetting(String var1, int var2) throws RemoteException;

    public boolean getApplicationHiddenSettingAsUser(String var1, int var2) throws RemoteException;

    public ApplicationInfo getApplicationInfo(String var1, int var2, int var3) throws RemoteException;

    public boolean getBlockUninstallForUser(String var1, int var2) throws RemoteException;

    public int getComponentEnabledSetting(ComponentName var1, int var2) throws RemoteException;

    public int getFlagsForUid(int var1) throws RemoteException;

    public ComponentName getHomeActivities(List<ResolveInfo> var1) throws RemoteException;

    public int getInstallLocation() throws RemoteException;

    public ParceledListSlice getInstalledApplications(int var1, int var2) throws RemoteException;

    public ParceledListSlice getInstalledPackages(int var1, int var2) throws RemoteException;

    public String getInstallerPackageName(String var1) throws RemoteException;

    public InstrumentationInfo getInstrumentationInfo(ComponentName var1, int var2) throws RemoteException;

    public KeySet getKeySetByAlias(String var1, String var2) throws RemoteException;

    public ResolveInfo getLastChosenActivity(Intent var1, String var2, int var3) throws RemoteException;

    public String getNameForUid(int var1) throws RemoteException;

    public int[] getPackageGids(String var1) throws RemoteException;

    public PackageInfo getPackageInfo(String var1, int var2, int var3) throws RemoteException;

    public IPackageInstaller getPackageInstaller() throws RemoteException;

    public void getPackageSizeInfo(String var1, int var2, IPackageStatsObserver var3) throws RemoteException;

    public int getPackageUid(String var1, int var2) throws RemoteException;

    public String[] getPackagesForUid(int var1) throws RemoteException;

    public ParceledListSlice getPackagesHoldingPermissions(String[] var1, int var2, int var3) throws RemoteException;

    public PermissionGroupInfo getPermissionGroupInfo(String var1, int var2) throws RemoteException;

    public PermissionInfo getPermissionInfo(String var1, int var2) throws RemoteException;

    public List<ApplicationInfo> getPersistentApplications(int var1) throws RemoteException;

    public int getPreferredActivities(List<IntentFilter> var1, List<ComponentName> var2, String var3) throws RemoteException;

    public List<PackageInfo> getPreferredPackages(int var1) throws RemoteException;

    public ProviderInfo getProviderInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    public ActivityInfo getReceiverInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    public ServiceInfo getServiceInfo(ComponentName var1, int var2, int var3) throws RemoteException;

    public KeySet getSigningKeySet(String var1) throws RemoteException;

    public FeatureInfo[] getSystemAvailableFeatures() throws RemoteException;

    public String[] getSystemSharedLibraryNames() throws RemoteException;

    public int getUidForSharedUser(String var1) throws RemoteException;

    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException;

    public void grantPermission(String var1, String var2) throws RemoteException;

    public boolean hasSystemFeature(String var1) throws RemoteException;

    public boolean hasSystemUidErrors() throws RemoteException;

    public int installExistingPackageAsUser(String var1, int var2) throws RemoteException;

    public void installPackage(String var1, IPackageInstallObserver2 var2, int var3, String var4, VerificationParams var5, String var6) throws RemoteException;

    public void installPackageAsUser(String var1, IPackageInstallObserver2 var2, int var3, String var4, VerificationParams var5, String var6, int var7) throws RemoteException;

    public boolean isFirstBoot() throws RemoteException;

    public boolean isNeedProtectSecPreloadedApps() throws RemoteException;

    public boolean isOnlyCoreApps() throws RemoteException;

    public boolean isPackageAvailable(String var1, int var2) throws RemoteException;

    public boolean isPackageSignedByKeySet(String var1, KeySet var2) throws RemoteException;

    public boolean isPackageSignedByKeySetExactly(String var1, KeySet var2) throws RemoteException;

    public boolean isPermissionEnforced(String var1) throws RemoteException;

    public boolean isProtectedBroadcast(String var1) throws RemoteException;

    public boolean isSafeMode() throws RemoteException;

    public boolean isStorageLow() throws RemoteException;

    public boolean isSupportUninstallablePreloadedApps() throws RemoteException;

    public boolean isUidPrivileged(int var1) throws RemoteException;

    public void movePackage(String var1, IPackageMoveObserver var2, int var3) throws RemoteException;

    public PackageCleanItem nextPackageToClean(PackageCleanItem var1) throws RemoteException;

    public void performBootDexOpt() throws RemoteException;

    public boolean performDexOptIfNeeded(String var1, String var2) throws RemoteException;

    public List<ProviderInfo> queryContentProviders(String var1, int var2, int var3) throws RemoteException;

    public List<InstrumentationInfo> queryInstrumentation(String var1, int var2) throws RemoteException;

    public List<ResolveInfo> queryIntentActivities(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public List<ResolveInfo> queryIntentActivityOptions(ComponentName var1, Intent[] var2, String[] var3, Intent var4, String var5, int var6, int var7) throws RemoteException;

    public List<ResolveInfo> queryIntentContentProviders(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public List<ResolveInfo> queryIntentReceivers(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public List<ResolveInfo> queryIntentServices(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public List<PermissionInfo> queryPermissionsByGroup(String var1, int var2) throws RemoteException;

    public void querySyncProviders(List<String> var1, List<ProviderInfo> var2) throws RemoteException;

    public void removePackageFromPreferred(String var1) throws RemoteException;

    public void removePermission(String var1) throws RemoteException;

    public void replacePreferredActivity(IntentFilter var1, int var2, ComponentName[] var3, ComponentName var4, int var5) throws RemoteException;

    public void resetPreferredActivities(int var1) throws RemoteException;

    public ProviderInfo resolveContentProvider(String var1, int var2, int var3) throws RemoteException;

    public ResolveInfo resolveIntent(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public ResolveInfo resolveService(Intent var1, String var2, int var3, int var4) throws RemoteException;

    public void revokePermission(String var1, String var2) throws RemoteException;

    public void setApplicationEnabledSetting(String var1, int var2, int var3, int var4, String var5) throws RemoteException;

    public boolean setApplicationHiddenSettingAsUser(String var1, boolean var2, int var3) throws RemoteException;

    public boolean setBlockUninstallForUser(String var1, boolean var2, int var3) throws RemoteException;

    public void setComponentEnabledSetting(ComponentName var1, int var2, int var3, int var4) throws RemoteException;

    public boolean setInstallLocation(int var1) throws RemoteException;

    public void setInstallerPackageName(String var1, String var2) throws RemoteException;

    public void setLastChosenActivity(Intent var1, String var2, int var3, IntentFilter var4, int var5, ComponentName var6) throws RemoteException;

    public void setPackageStoppedState(String var1, boolean var2, int var3) throws RemoteException;

    public void setPermissionEnforced(String var1, boolean var2) throws RemoteException;

    public void systemReady() throws RemoteException;

    public void updateExternalMediaStatus(boolean var1, boolean var2) throws RemoteException;

    public void verifyPendingInstall(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPackageManager {
        private static final String DESCRIPTOR = "android.content.pm.IPackageManager";
        static final int TRANSACTION_activitySupportsIntent = 13;
        static final int TRANSACTION_addCrossProfileIntentFilter = 68;
        static final int TRANSACTION_addPackageToPreferred = 56;
        static final int TRANSACTION_addPermission = 19;
        static final int TRANSACTION_addPermissionAsync = 94;
        static final int TRANSACTION_addPersistentPreferredActivity = 66;
        static final int TRANSACTION_addPreferredActivity = 62;
        static final int TRANSACTION_canForwardTo = 33;
        static final int TRANSACTION_canonicalToCurrentPackageNames = 6;
        static final int TRANSACTION_checkPermission = 17;
        static final int TRANSACTION_checkSignatures = 24;
        static final int TRANSACTION_checkUidPermission = 18;
        static final int TRANSACTION_checkUidSignatures = 25;
        static final int TRANSACTION_clearApplicationUserData = 79;
        static final int TRANSACTION_clearCrossProfileIntentFilters = 69;
        static final int TRANSACTION_clearPackagePersistentPreferredActivities = 67;
        static final int TRANSACTION_clearPackagePreferredActivities = 64;
        static final int TRANSACTION_currentToCanonicalPackageNames = 5;
        static final int TRANSACTION_deleteApplicationCacheFiles = 78;
        static final int TRANSACTION_deleteBundledSystemPackages = 115;
        static final int TRANSACTION_deletePackage = 54;
        static final int TRANSACTION_deletePackageAsUser = 53;
        static final int TRANSACTION_enterSafeMode = 84;
        static final int TRANSACTION_extendVerificationTimeout = 99;
        static final int TRANSACTION_finishPackageInstall = 51;
        static final int TRANSACTION_forceDexOpt = 90;
        static final int TRANSACTION_freeStorage = 77;
        static final int TRANSACTION_freeStorageAndNotify = 76;
        static final int TRANSACTION_getActivityInfo = 12;
        static final int TRANSACTION_getAllPermissionGroups = 10;
        static final int TRANSACTION_getAppOpPermissionPackages = 31;
        static final int TRANSACTION_getApplicationEnabledSetting = 74;
        static final int TRANSACTION_getApplicationHiddenSettingAsUser = 107;
        static final int TRANSACTION_getApplicationInfo = 11;
        static final int TRANSACTION_getBlockUninstallForUser = 110;
        static final int TRANSACTION_getComponentEnabledSetting = 72;
        static final int TRANSACTION_getFlagsForUid = 29;
        static final int TRANSACTION_getHomeActivities = 70;
        static final int TRANSACTION_getInstallLocation = 96;
        static final int TRANSACTION_getInstalledApplications = 42;
        static final int TRANSACTION_getInstalledPackages = 40;
        static final int TRANSACTION_getInstallerPackageName = 55;
        static final int TRANSACTION_getInstrumentationInfo = 47;
        static final int TRANSACTION_getKeySetByAlias = 111;
        static final int TRANSACTION_getLastChosenActivity = 60;
        static final int TRANSACTION_getNameForUid = 27;
        static final int TRANSACTION_getPackageGids = 4;
        static final int TRANSACTION_getPackageInfo = 2;
        static final int TRANSACTION_getPackageInstaller = 108;
        static final int TRANSACTION_getPackageSizeInfo = 80;
        static final int TRANSACTION_getPackageUid = 3;
        static final int TRANSACTION_getPackagesForUid = 26;
        static final int TRANSACTION_getPackagesHoldingPermissions = 41;
        static final int TRANSACTION_getPermissionGroupInfo = 9;
        static final int TRANSACTION_getPermissionInfo = 7;
        static final int TRANSACTION_getPersistentApplications = 43;
        static final int TRANSACTION_getPreferredActivities = 65;
        static final int TRANSACTION_getPreferredPackages = 58;
        static final int TRANSACTION_getProviderInfo = 16;
        static final int TRANSACTION_getReceiverInfo = 14;
        static final int TRANSACTION_getServiceInfo = 15;
        static final int TRANSACTION_getSigningKeySet = 112;
        static final int TRANSACTION_getSystemAvailableFeatures = 82;
        static final int TRANSACTION_getSystemSharedLibraryNames = 81;
        static final int TRANSACTION_getUidForSharedUser = 28;
        static final int TRANSACTION_getVerifierDeviceIdentity = 100;
        static final int TRANSACTION_grantPermission = 21;
        static final int TRANSACTION_hasSystemFeature = 83;
        static final int TRANSACTION_hasSystemUidErrors = 87;
        static final int TRANSACTION_installExistingPackageAsUser = 97;
        static final int TRANSACTION_installPackage = 49;
        static final int TRANSACTION_installPackageAsUser = 50;
        static final int TRANSACTION_isFirstBoot = 101;
        static final int TRANSACTION_isNeedProtectSecPreloadedApps = 117;
        static final int TRANSACTION_isOnlyCoreApps = 102;
        static final int TRANSACTION_isPackageAvailable = 1;
        static final int TRANSACTION_isPackageSignedByKeySet = 113;
        static final int TRANSACTION_isPackageSignedByKeySetExactly = 114;
        static final int TRANSACTION_isPermissionEnforced = 104;
        static final int TRANSACTION_isProtectedBroadcast = 23;
        static final int TRANSACTION_isSafeMode = 85;
        static final int TRANSACTION_isStorageLow = 105;
        static final int TRANSACTION_isSupportUninstallablePreloadedApps = 116;
        static final int TRANSACTION_isUidPrivileged = 30;
        static final int TRANSACTION_movePackage = 93;
        static final int TRANSACTION_nextPackageToClean = 92;
        static final int TRANSACTION_performBootDexOpt = 88;
        static final int TRANSACTION_performDexOptIfNeeded = 89;
        static final int TRANSACTION_queryContentProviders = 46;
        static final int TRANSACTION_queryInstrumentation = 48;
        static final int TRANSACTION_queryIntentActivities = 34;
        static final int TRANSACTION_queryIntentActivityOptions = 35;
        static final int TRANSACTION_queryIntentContentProviders = 39;
        static final int TRANSACTION_queryIntentReceivers = 36;
        static final int TRANSACTION_queryIntentServices = 38;
        static final int TRANSACTION_queryPermissionsByGroup = 8;
        static final int TRANSACTION_querySyncProviders = 45;
        static final int TRANSACTION_removePackageFromPreferred = 57;
        static final int TRANSACTION_removePermission = 20;
        static final int TRANSACTION_replacePreferredActivity = 63;
        static final int TRANSACTION_resetPreferredActivities = 59;
        static final int TRANSACTION_resolveContentProvider = 44;
        static final int TRANSACTION_resolveIntent = 32;
        static final int TRANSACTION_resolveService = 37;
        static final int TRANSACTION_revokePermission = 22;
        static final int TRANSACTION_setApplicationEnabledSetting = 73;
        static final int TRANSACTION_setApplicationHiddenSettingAsUser = 106;
        static final int TRANSACTION_setBlockUninstallForUser = 109;
        static final int TRANSACTION_setComponentEnabledSetting = 71;
        static final int TRANSACTION_setInstallLocation = 95;
        static final int TRANSACTION_setInstallerPackageName = 52;
        static final int TRANSACTION_setLastChosenActivity = 61;
        static final int TRANSACTION_setPackageStoppedState = 75;
        static final int TRANSACTION_setPermissionEnforced = 103;
        static final int TRANSACTION_systemReady = 86;
        static final int TRANSACTION_updateExternalMediaStatus = 91;
        static final int TRANSACTION_verifyPendingInstall = 98;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPackageManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IPackageManager) {
                return (IPackageManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isPackageAvailable(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PackageInfo packageInfo = this.getPackageInfo(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (packageInfo != null) {
                        parcel2.writeInt(1);
                        packageInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = this.getPackageUid(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int[] nArray = this.getPackageGids(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.currentToCanonicalPackageNames(parcel.createStringArray());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.canonicalToCurrentPackageNames(parcel.createStringArray());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionInfo permissionInfo = this.getPermissionInfo(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (permissionInfo != null) {
                        parcel2.writeInt(1);
                        permissionInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PermissionInfo> list = this.queryPermissionsByGroup(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionGroupInfo permissionGroupInfo = this.getPermissionGroupInfo(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (permissionGroupInfo != null) {
                        parcel2.writeInt(1);
                        permissionGroupInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PermissionGroupInfo> list = this.getAllPermissionGroups(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ApplicationInfo applicationInfo = this.getApplicationInfo(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (applicationInfo != null) {
                        parcel2.writeInt(1);
                        applicationInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    ActivityInfo activityInfo = this.getActivityInfo(componentName, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (activityInfo != null) {
                        parcel2.writeInt(1);
                        activityInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.activitySupportsIntent(componentName, intent, parcel.readString());
                    parcel2.writeNoException();
                    int n5 = bl ? 1 : 0;
                    parcel2.writeInt(n5);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    ActivityInfo activityInfo = this.getReceiverInfo(componentName, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (activityInfo != null) {
                        parcel2.writeInt(1);
                        activityInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    ServiceInfo serviceInfo = this.getServiceInfo(componentName, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (serviceInfo != null) {
                        parcel2.writeInt(1);
                        serviceInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    ProviderInfo providerInfo = this.getProviderInfo(componentName, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (providerInfo != null) {
                        parcel2.writeInt(1);
                        providerInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = this.checkPermission(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.checkUidPermission(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionInfo permissionInfo = parcel.readInt() != 0 ? PermissionInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.addPermission(permissionInfo);
                    parcel2.writeNoException();
                    int n8 = bl ? 1 : 0;
                    parcel2.writeInt(n8);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removePermission(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.grantPermission(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.revokePermission(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isProtectedBroadcast(parcel.readString());
                    parcel2.writeNoException();
                    int n9 = bl ? 1 : 0;
                    parcel2.writeInt(n9);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n10 = this.checkSignatures(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n10);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n11 = this.checkUidSignatures(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n11);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getPackagesForUid(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getNameForUid(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.getUidForSharedUser(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n13 = this.getFlagsForUid(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n13);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isUidPrivileged(parcel.readInt());
                    parcel2.writeNoException();
                    int n14 = bl ? 1 : 0;
                    parcel2.writeInt(n14);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getAppOpPermissionPackages(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    ResolveInfo resolveInfo = this.resolveIntent(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (resolveInfo != null) {
                        parcel2.writeInt(1);
                        resolveInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.canForwardTo(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    int n15 = bl ? 1 : 0;
                    parcel2.writeInt(n15);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.queryIntentActivities(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    Intent[] intentArray = parcel.createTypedArray(Intent.CREATOR);
                    String[] stringArray = parcel.createStringArray();
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.queryIntentActivityOptions(componentName, intentArray, stringArray, intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.queryIntentReceivers(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    ResolveInfo resolveInfo = this.resolveService(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (resolveInfo != null) {
                        parcel2.writeInt(1);
                        resolveInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.queryIntentServices(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    List<ResolveInfo> list = this.queryIntentContentProviders(intent, parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParceledListSlice parceledListSlice = this.getInstalledPackages(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (parceledListSlice != null) {
                        parcel2.writeInt(1);
                        parceledListSlice.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParceledListSlice parceledListSlice = this.getPackagesHoldingPermissions(parcel.createStringArray(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (parceledListSlice != null) {
                        parcel2.writeInt(1);
                        parceledListSlice.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParceledListSlice parceledListSlice = this.getInstalledApplications(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (parceledListSlice != null) {
                        parcel2.writeInt(1);
                        parceledListSlice.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ApplicationInfo> list = this.getPersistentApplications(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ProviderInfo providerInfo = this.resolveContentProvider(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (providerInfo != null) {
                        parcel2.writeInt(1);
                        providerInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ArrayList<String> arrayList = parcel.createStringArrayList();
                    ArrayList<ProviderInfo> arrayList2 = parcel.createTypedArrayList(ProviderInfo.CREATOR);
                    this.querySyncProviders(arrayList, arrayList2);
                    parcel2.writeNoException();
                    parcel2.writeStringList(arrayList);
                    parcel2.writeTypedList(arrayList2);
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<ProviderInfo> list = this.queryContentProviders(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    InstrumentationInfo instrumentationInfo = this.getInstrumentationInfo(componentName, parcel.readInt());
                    parcel2.writeNoException();
                    if (instrumentationInfo != null) {
                        parcel2.writeInt(1);
                        instrumentationInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<InstrumentationInfo> list = this.queryInstrumentation(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = parcel.readString();
                    IPackageInstallObserver2 iPackageInstallObserver2 = IPackageInstallObserver2.Stub.asInterface(parcel.readStrongBinder());
                    int n16 = parcel.readInt();
                    String string4 = parcel.readString();
                    VerificationParams verificationParams = parcel.readInt() != 0 ? VerificationParams.CREATOR.createFromParcel(parcel) : null;
                    this.installPackage(string3, iPackageInstallObserver2, n16, string4, verificationParams, parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    IPackageInstallObserver2 iPackageInstallObserver2 = IPackageInstallObserver2.Stub.asInterface(parcel.readStrongBinder());
                    int n17 = parcel.readInt();
                    String string6 = parcel.readString();
                    VerificationParams verificationParams = parcel.readInt() != 0 ? VerificationParams.CREATOR.createFromParcel(parcel) : null;
                    this.installPackageAsUser(string5, iPackageInstallObserver2, n17, string6, verificationParams, parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishPackageInstall(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setInstallerPackageName(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deletePackageAsUser(parcel.readString(), IPackageDeleteObserver.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 54: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deletePackage(parcel.readString(), IPackageDeleteObserver2.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 55: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string7 = this.getInstallerPackageName(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeString(string7);
                    return true;
                }
                case 56: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.addPackageToPreferred(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 57: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.removePackageFromPreferred(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 58: {
                    parcel.enforceInterface(DESCRIPTOR);
                    List<PackageInfo> list = this.getPreferredPackages(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedList(list);
                    return true;
                }
                case 59: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.resetPreferredActivities(parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 60: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    ResolveInfo resolveInfo = this.getLastChosenActivity(intent, parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    if (resolveInfo != null) {
                        parcel2.writeInt(1);
                        resolveInfo.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 61: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Intent intent = parcel.readInt() != 0 ? Intent.CREATOR.createFromParcel(parcel) : null;
                    String string8 = parcel.readString();
                    int n18 = parcel.readInt();
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    int n19 = parcel.readInt();
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.setLastChosenActivity(intent, string8, n18, intentFilter, n19, componentName);
                    parcel2.writeNoException();
                    return true;
                }
                case 62: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    int n20 = parcel.readInt();
                    ComponentName[] componentNameArray = parcel.createTypedArray(ComponentName.CREATOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.addPreferredActivity(intentFilter, n20, componentNameArray, componentName, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 63: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    int n21 = parcel.readInt();
                    ComponentName[] componentNameArray = parcel.createTypedArray(ComponentName.CREATOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.replacePreferredActivity(intentFilter, n21, componentNameArray, componentName, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 64: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearPackagePreferredActivities(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 65: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ArrayList<IntentFilter> arrayList = new ArrayList<IntentFilter>();
                    ArrayList<ComponentName> arrayList3 = new ArrayList<ComponentName>();
                    int n22 = this.getPreferredActivities(arrayList, arrayList3, parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    parcel2.writeTypedList(arrayList);
                    parcel2.writeTypedList(arrayList3);
                    return true;
                }
                case 66: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.addPersistentPreferredActivity(intentFilter, componentName, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 67: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearPackagePersistentPreferredActivities(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 68: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IntentFilter intentFilter = parcel.readInt() != 0 ? IntentFilter.CREATOR.createFromParcel(parcel) : null;
                    this.addCrossProfileIntentFilter(intentFilter, parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 69: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearCrossProfileIntentFilters(parcel.readInt(), parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 70: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ArrayList<ResolveInfo> arrayList = new ArrayList<ResolveInfo>();
                    ComponentName componentName = this.getHomeActivities(arrayList);
                    parcel2.writeNoException();
                    if (componentName != null) {
                        parcel2.writeInt(1);
                        componentName.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    parcel2.writeTypedList(arrayList);
                    return true;
                }
                case 71: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.setComponentEnabledSetting(componentName, parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 72: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    int n23 = this.getComponentEnabledSetting(componentName, parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n23);
                    return true;
                }
                case 73: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setApplicationEnabledSetting(parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 74: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n24 = this.getApplicationEnabledSetting(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 75: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string9 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setPackageStoppedState(string9, bl, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 76: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.freeStorageAndNotify(parcel.readLong(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 77: {
                    parcel.enforceInterface(DESCRIPTOR);
                    long l = parcel.readLong();
                    IntentSender intentSender = parcel.readInt() != 0 ? IntentSender.CREATOR.createFromParcel(parcel) : null;
                    this.freeStorage(l, intentSender);
                    parcel2.writeNoException();
                    return true;
                }
                case 78: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deleteApplicationCacheFiles(parcel.readString(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 79: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.clearApplicationUserData(parcel.readString(), IPackageDataObserver.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 80: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getPackageSizeInfo(parcel.readString(), parcel.readInt(), IPackageStatsObserver.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 81: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String[] stringArray = this.getSystemSharedLibraryNames();
                    parcel2.writeNoException();
                    parcel2.writeStringArray(stringArray);
                    return true;
                }
                case 82: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getSystemAvailableFeatures();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 83: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasSystemFeature(parcel.readString());
                    parcel2.writeNoException();
                    int n25 = bl ? 1 : 0;
                    parcel2.writeInt(n25);
                    return true;
                }
                case 84: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enterSafeMode();
                    parcel2.writeNoException();
                    return true;
                }
                case 85: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSafeMode();
                    parcel2.writeNoException();
                    int n26 = bl ? 1 : 0;
                    parcel2.writeInt(n26);
                    return true;
                }
                case 86: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.systemReady();
                    parcel2.writeNoException();
                    return true;
                }
                case 87: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.hasSystemUidErrors();
                    parcel2.writeNoException();
                    int n27 = bl ? 1 : 0;
                    parcel2.writeInt(n27);
                    return true;
                }
                case 88: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.performBootDexOpt();
                    parcel2.writeNoException();
                    return true;
                }
                case 89: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.performDexOptIfNeeded(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    int n28 = bl ? 1 : 0;
                    parcel2.writeInt(n28);
                    return true;
                }
                case 90: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.forceDexOpt(parcel.readString());
                    parcel2.writeNoException();
                    return true;
                }
                case 91: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    this.updateExternalMediaStatus(bl, bl2);
                    parcel2.writeNoException();
                    return true;
                }
                case 92: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PackageCleanItem packageCleanItem = parcel.readInt() != 0 ? PackageCleanItem.CREATOR.createFromParcel(parcel) : null;
                    PackageCleanItem packageCleanItem2 = this.nextPackageToClean(packageCleanItem);
                    parcel2.writeNoException();
                    if (packageCleanItem2 != null) {
                        parcel2.writeInt(1);
                        packageCleanItem2.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 93: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.movePackage(parcel.readString(), IPackageMoveObserver.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 94: {
                    parcel.enforceInterface(DESCRIPTOR);
                    PermissionInfo permissionInfo = parcel.readInt() != 0 ? PermissionInfo.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.addPermissionAsync(permissionInfo);
                    parcel2.writeNoException();
                    int n29 = bl ? 1 : 0;
                    parcel2.writeInt(n29);
                    return true;
                }
                case 95: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setInstallLocation(parcel.readInt());
                    parcel2.writeNoException();
                    int n30 = bl ? 1 : 0;
                    parcel2.writeInt(n30);
                    return true;
                }
                case 96: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n31 = this.getInstallLocation();
                    parcel2.writeNoException();
                    parcel2.writeInt(n31);
                    return true;
                }
                case 97: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n32 = this.installExistingPackageAsUser(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n32);
                    return true;
                }
                case 98: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.verifyPendingInstall(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 99: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.extendVerificationTimeout(parcel.readInt(), parcel.readInt(), parcel.readLong());
                    parcel2.writeNoException();
                    return true;
                }
                case 100: {
                    parcel.enforceInterface(DESCRIPTOR);
                    VerifierDeviceIdentity verifierDeviceIdentity = this.getVerifierDeviceIdentity();
                    parcel2.writeNoException();
                    if (verifierDeviceIdentity != null) {
                        parcel2.writeInt(1);
                        verifierDeviceIdentity.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 101: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isFirstBoot();
                    parcel2.writeNoException();
                    int n33 = bl ? 1 : 0;
                    parcel2.writeInt(n33);
                    return true;
                }
                case 102: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isOnlyCoreApps();
                    parcel2.writeNoException();
                    int n34 = bl ? 1 : 0;
                    parcel2.writeInt(n34);
                    return true;
                }
                case 103: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string10 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    this.setPermissionEnforced(string10, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 104: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isPermissionEnforced(parcel.readString());
                    parcel2.writeNoException();
                    int n35 = bl ? 1 : 0;
                    parcel2.writeInt(n35);
                    return true;
                }
                case 105: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isStorageLow();
                    parcel2.writeNoException();
                    int n36 = bl ? 1 : 0;
                    parcel2.writeInt(n36);
                    return true;
                }
                case 106: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string11 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = this.setApplicationHiddenSettingAsUser(string11, bl, parcel.readInt());
                    parcel2.writeNoException();
                    int n37 = bl3 ? 1 : 0;
                    parcel2.writeInt(n37);
                    return true;
                }
                case 107: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getApplicationHiddenSettingAsUser(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    int n38 = bl ? 1 : 0;
                    parcel2.writeInt(n38);
                    return true;
                }
                case 108: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IPackageInstaller iPackageInstaller = this.getPackageInstaller();
                    parcel2.writeNoException();
                    IBinder iBinder = iPackageInstaller != null ? iPackageInstaller.asBinder() : null;
                    parcel2.writeStrongBinder(iBinder);
                    return true;
                }
                case 109: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string12 = parcel.readString();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl4 = this.setBlockUninstallForUser(string12, bl, parcel.readInt());
                    parcel2.writeNoException();
                    int n39 = bl4 ? 1 : 0;
                    parcel2.writeInt(n39);
                    return true;
                }
                case 110: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getBlockUninstallForUser(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    int n40 = bl ? 1 : 0;
                    parcel2.writeInt(n40);
                    return true;
                }
                case 111: {
                    parcel.enforceInterface(DESCRIPTOR);
                    KeySet keySet = this.getKeySetByAlias(parcel.readString(), parcel.readString());
                    parcel2.writeNoException();
                    if (keySet != null) {
                        parcel2.writeInt(1);
                        keySet.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 112: {
                    parcel.enforceInterface(DESCRIPTOR);
                    KeySet keySet = this.getSigningKeySet(parcel.readString());
                    parcel2.writeNoException();
                    if (keySet != null) {
                        parcel2.writeInt(1);
                        keySet.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 113: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string13 = parcel.readString();
                    KeySet keySet = parcel.readInt() != 0 ? KeySet.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.isPackageSignedByKeySet(string13, keySet);
                    parcel2.writeNoException();
                    int n41 = bl ? 1 : 0;
                    parcel2.writeInt(n41);
                    return true;
                }
                case 114: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string14 = parcel.readString();
                    KeySet keySet = parcel.readInt() != 0 ? KeySet.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.isPackageSignedByKeySetExactly(string14, keySet);
                    parcel2.writeNoException();
                    int n42 = bl ? 1 : 0;
                    parcel2.writeInt(n42);
                    return true;
                }
                case 115: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.deleteBundledSystemPackages(parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 116: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isSupportUninstallablePreloadedApps();
                    parcel2.writeNoException();
                    int n43 = bl ? 1 : 0;
                    parcel2.writeInt(n43);
                    return true;
                }
                case 117: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            boolean bl = this.isNeedProtectSecPreloadedApps();
            parcel2.writeNoException();
            int n44 = bl ? 1 : 0;
            parcel2.writeInt(n44);
            return true;
        }

        private static class Proxy
        implements IPackageManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean activitySupportsIntent(ComponentName componentName, Intent intent, String string2) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block9: {
                    block8: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (componentName != null) {
                                parcel2.writeInt(1);
                                componentName.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (intent != null) {
                                parcel2.writeInt(1);
                                intent.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeString(string2);
                            this.mRemote.transact(13, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block8;
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addCrossProfileIntentFilter(IntentFilter intentFilter, String string2, int n, int n2, int n3, int n4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    this.mRemote.transact(68, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void addPackageToPreferred(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(56, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addPermission(PermissionInfo permissionInfo) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (permissionInfo != null) {
                                parcel2.writeInt(1);
                                permissionInfo.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(19, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean addPermissionAsync(PermissionInfo permissionInfo) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (permissionInfo != null) {
                                parcel2.writeInt(1);
                                permissionInfo.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(94, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addPersistentPreferredActivity(IntentFilter intentFilter, ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(66, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void addPreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeTypedArray(componentNameArray, 0);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(62, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean canForwardTo(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (intent != null) {
                                parcel2.writeInt(1);
                                intent.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeString(string2);
                            parcel2.writeInt(n);
                            parcel2.writeInt(n2);
                            this.mRemote.transact(33, parcel2, parcel, 0);
                            parcel.readException();
                            int n3 = parcel.readInt();
                            if (n3 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public String[] canonicalToCurrentPackageNames(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray2 = parcel2.createStringArray();
                    return stringArray2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkPermission(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkSignatures(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkUidPermission(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int checkUidSignatures(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    return n3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void clearApplicationUserData(String string2, IPackageDataObserver iPackageDataObserver, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDataObserver != null ? iPackageDataObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(79, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void clearCrossProfileIntentFilters(int n, String string2, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    parcel.writeInt(n2);
                    this.mRemote.transact(69, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearPackagePersistentPreferredActivities(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(67, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void clearPackagePreferredActivities(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(64, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] currentToCanonicalPackageNames(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray2 = parcel2.createStringArray();
                    return stringArray2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void deleteApplicationCacheFiles(String string2, IPackageDataObserver iPackageDataObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDataObserver != null ? iPackageDataObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(78, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void deleteBundledSystemPackages(String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(115, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void deletePackage(String string2, IPackageDeleteObserver2 iPackageDeleteObserver2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDeleteObserver2 != null ? iPackageDeleteObserver2.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void deletePackageAsUser(String string2, IPackageDeleteObserver iPackageDeleteObserver, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageDeleteObserver != null ? iPackageDeleteObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void enterSafeMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(84, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void extendVerificationTimeout(int n, int n2, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeLong(l);
                    this.mRemote.transact(99, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void finishPackageInstall(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void forceDexOpt(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(90, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void freeStorage(long l, IntentSender intentSender) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    if (intentSender != null) {
                        parcel.writeInt(1);
                        intentSender.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(77, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void freeStorageAndNotify(long l, IPackageDataObserver iPackageDataObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeLong(l);
                    IBinder iBinder = iPackageDataObserver != null ? iPackageDataObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(76, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ActivityInfo getActivityInfo(ComponentName componentName, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    ActivityInfo activityInfo = parcel2.readInt() != 0 ? ActivityInfo.CREATOR.createFromParcel(parcel2) : null;
                    return activityInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PermissionGroupInfo> getAllPermissionGroups(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PermissionGroupInfo> arrayList = parcel2.createTypedArrayList(PermissionGroupInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getAppOpPermissionPackages(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(31, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getApplicationEnabledSetting(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(74, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean getApplicationHiddenSettingAsUser(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(107, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ApplicationInfo getApplicationInfo(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    ApplicationInfo applicationInfo = parcel2.readInt() != 0 ? ApplicationInfo.CREATOR.createFromParcel(parcel2) : null;
                    return applicationInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean getBlockUninstallForUser(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(110, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getComponentEnabledSetting(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(72, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getFlagsForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ComponentName getHomeActivities(List<ResolveInfo> list) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(70, parcel, parcel2, 0);
                    parcel2.readException();
                    ComponentName componentName = parcel2.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel2) : null;
                    parcel2.readTypedList(list, ResolveInfo.CREATOR);
                    parcel2.recycle();
                    parcel.recycle();
                    return componentName;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getInstallLocation() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(96, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParceledListSlice getInstalledApplications(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(42, parcel, parcel2, 0);
                    parcel2.readException();
                    ParceledListSlice parceledListSlice = parcel2.readInt() != 0 ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(parcel2) : null;
                    return parceledListSlice;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParceledListSlice getInstalledPackages(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(40, parcel, parcel2, 0);
                    parcel2.readException();
                    ParceledListSlice parceledListSlice = parcel2.readInt() != 0 ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(parcel2) : null;
                    return parceledListSlice;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getInstallerPackageName(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(55, parcel, parcel2, 0);
                    parcel2.readException();
                    String string3 = parcel2.readString();
                    return string3;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public InstrumentationInfo getInstrumentationInfo(ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    InstrumentationInfo instrumentationInfo = parcel2.readInt() != 0 ? InstrumentationInfo.CREATOR.createFromParcel(parcel2) : null;
                    return instrumentationInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public KeySet getKeySetByAlias(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(111, parcel, parcel2, 0);
                    parcel2.readException();
                    KeySet keySet = parcel2.readInt() != 0 ? KeySet.CREATOR.createFromParcel(parcel2) : null;
                    return keySet;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResolveInfo getLastChosenActivity(Intent intent, String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(60, parcel, parcel2, 0);
                    parcel2.readException();
                    ResolveInfo resolveInfo = parcel2.readInt() != 0 ? ResolveInfo.CREATOR.createFromParcel(parcel2) : null;
                    return resolveInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getNameForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int[] getPackageGids(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int[] nArray = parcel2.createIntArray();
                    return nArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PackageInfo getPackageInfo(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    PackageInfo packageInfo = parcel2.readInt() != 0 ? PackageInfo.CREATOR.createFromParcel(parcel2) : null;
                    return packageInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public IPackageInstaller getPackageInstaller() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(108, parcel, parcel2, 0);
                    parcel2.readException();
                    IPackageInstaller iPackageInstaller = IPackageInstaller.Stub.asInterface(parcel2.readStrongBinder());
                    return iPackageInstaller;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getPackageSizeInfo(String string2, int n, IPackageStatsObserver iPackageStatsObserver) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    IBinder iBinder = iPackageStatsObserver != null ? iPackageStatsObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(80, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getPackageUid(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getPackagesForUid(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParceledListSlice getPackagesHoldingPermissions(String[] stringArray, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringArray(stringArray);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    ParceledListSlice parceledListSlice = parcel2.readInt() != 0 ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(parcel2) : null;
                    return parceledListSlice;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PermissionGroupInfo getPermissionGroupInfo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    PermissionGroupInfo permissionGroupInfo = parcel2.readInt() != 0 ? PermissionGroupInfo.CREATOR.createFromParcel(parcel2) : null;
                    return permissionGroupInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PermissionInfo getPermissionInfo(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    PermissionInfo permissionInfo = parcel2.readInt() != 0 ? PermissionInfo.CREATOR.createFromParcel(parcel2) : null;
                    return permissionInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<ApplicationInfo> getPersistentApplications(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ApplicationInfo> arrayList = parcel2.createTypedArrayList(ApplicationInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPreferredActivities(List<IntentFilter> list, List<ComponentName> list2, String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(65, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.readTypedList(list, IntentFilter.CREATOR);
                    parcel2.readTypedList(list2, ComponentName.CREATOR);
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PackageInfo> getPreferredPackages(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(58, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PackageInfo> arrayList = parcel2.createTypedArrayList(PackageInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ProviderInfo getProviderInfo(ComponentName componentName, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    ProviderInfo providerInfo = parcel2.readInt() != 0 ? ProviderInfo.CREATOR.createFromParcel(parcel2) : null;
                    return providerInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ActivityInfo getReceiverInfo(ComponentName componentName, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    ActivityInfo activityInfo = parcel2.readInt() != 0 ? ActivityInfo.CREATOR.createFromParcel(parcel2) : null;
                    return activityInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ServiceInfo getServiceInfo(ComponentName componentName, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    ServiceInfo serviceInfo = parcel2.readInt() != 0 ? ServiceInfo.CREATOR.createFromParcel(parcel2) : null;
                    return serviceInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public KeySet getSigningKeySet(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(112, parcel, parcel2, 0);
                    parcel2.readException();
                    KeySet keySet = parcel2.readInt() != 0 ? KeySet.CREATOR.createFromParcel(parcel2) : null;
                    return keySet;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public FeatureInfo[] getSystemAvailableFeatures() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(82, parcel, parcel2, 0);
                    parcel2.readException();
                    FeatureInfo[] featureInfoArray = parcel2.createTypedArray(FeatureInfo.CREATOR);
                    return featureInfoArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String[] getSystemSharedLibraryNames() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(81, parcel, parcel2, 0);
                    parcel2.readException();
                    String[] stringArray = parcel2.createStringArray();
                    return stringArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getUidForSharedUser(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(100, parcel, parcel2, 0);
                    parcel2.readException();
                    VerifierDeviceIdentity verifierDeviceIdentity = parcel2.readInt() != 0 ? VerifierDeviceIdentity.CREATOR.createFromParcel(parcel2) : null;
                    return verifierDeviceIdentity;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void grantPermission(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean hasSystemFeature(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(83, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean hasSystemUidErrors() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(87, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int installExistingPackageAsUser(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(97, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void installPackage(String string2, IPackageInstallObserver2 iPackageInstallObserver2, int n, String string3, VerificationParams verificationParams, String string4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageInstallObserver2 != null ? iPackageInstallObserver2.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    if (verificationParams != null) {
                        parcel.writeInt(1);
                        verificationParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string4);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void installPackageAsUser(String string2, IPackageInstallObserver2 iPackageInstallObserver2, int n, String string3, VerificationParams verificationParams, String string4, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageInstallObserver2 != null ? iPackageInstallObserver2.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeString(string3);
                    if (verificationParams != null) {
                        parcel.writeInt(1);
                        verificationParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string4);
                    parcel.writeInt(n2);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isFirstBoot() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(101, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isNeedProtectSecPreloadedApps() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(117, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isOnlyCoreApps() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(102, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isPackageAvailable(String string2, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block3: {
                    block2: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            parcel2.writeInt(n);
                            this.mRemote.transact(1, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isPackageSignedByKeySet(String string2, KeySet keySet) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            if (keySet != null) {
                                parcel2.writeInt(1);
                                keySet.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(113, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isPackageSignedByKeySetExactly(String string2, KeySet keySet) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            if (keySet != null) {
                                parcel2.writeInt(1);
                                keySet.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(114, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean isPermissionEnforced(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(104, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isProtectedBroadcast(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSafeMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(85, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isStorageLow() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(105, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isSupportUninstallablePreloadedApps() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(116, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isUidPrivileged(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void movePackage(String string2, IPackageMoveObserver iPackageMoveObserver, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iPackageMoveObserver != null ? iPackageMoveObserver.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(93, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public PackageCleanItem nextPackageToClean(PackageCleanItem packageCleanItem) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (packageCleanItem != null) {
                        parcel.writeInt(1);
                        packageCleanItem.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(92, parcel, parcel2, 0);
                    parcel2.readException();
                    PackageCleanItem packageCleanItem2 = parcel2.readInt() != 0 ? PackageCleanItem.CREATOR.createFromParcel(parcel2) : null;
                    return packageCleanItem2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void performBootDexOpt() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(88, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean performDexOptIfNeeded(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(89, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public List<ProviderInfo> queryContentProviders(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ProviderInfo> arrayList = parcel2.createTypedArrayList(ProviderInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<InstrumentationInfo> queryInstrumentation(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(48, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<InstrumentationInfo> arrayList = parcel2.createTypedArrayList(InstrumentationInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentActivities(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(34, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentActivityOptions(ComponentName componentName, Intent[] intentArray, String[] stringArray, Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeTypedArray(intentArray, 0);
                    parcel.writeStringArray(stringArray);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(35, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentContentProviders(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentReceivers(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(36, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public List<ResolveInfo> queryIntentServices(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(38, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<ResolveInfo> arrayList = parcel2.createTypedArrayList(ResolveInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public List<PermissionInfo> queryPermissionsByGroup(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    ArrayList<PermissionInfo> arrayList = parcel2.createTypedArrayList(PermissionInfo.CREATOR);
                    return arrayList;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void querySyncProviders(List<String> list, List<ProviderInfo> list2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStringList(list);
                    parcel.writeTypedList(list2);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.readStringList(list);
                    parcel2.readTypedList(list2, ProviderInfo.CREATOR);
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removePackageFromPreferred(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(57, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void removePermission(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void replacePreferredActivity(IntentFilter intentFilter, int n, ComponentName[] componentNameArray, ComponentName componentName, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeTypedArray(componentNameArray, 0);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(63, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void resetPreferredActivities(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(59, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ProviderInfo resolveContentProvider(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    ProviderInfo providerInfo = parcel2.readInt() != 0 ? ProviderInfo.CREATOR.createFromParcel(parcel2) : null;
                    return providerInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResolveInfo resolveIntent(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    ResolveInfo resolveInfo = parcel2.readInt() != 0 ? ResolveInfo.CREATOR.createFromParcel(parcel2) : null;
                    return resolveInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ResolveInfo resolveService(Intent intent, String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(37, parcel, parcel2, 0);
                    parcel2.readException();
                    ResolveInfo resolveInfo = parcel2.readInt() != 0 ? ResolveInfo.CREATOR.createFromParcel(parcel2) : null;
                    return resolveInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void revokePermission(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setApplicationEnabledSetting(String string2, int n, int n2, int n3, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeString(string3);
                    this.mRemote.transact(73, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setApplicationHiddenSettingAsUser(String string2, boolean bl, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            parcel2.writeInt(n);
                            this.mRemote.transact(106, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setBlockUninstallForUser(String string2, boolean bl, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            parcel2.writeString(string2);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            parcel2.writeInt(n);
                            this.mRemote.transact(109, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setComponentEnabledSetting(ComponentName componentName, int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(71, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean setInstallLocation(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(95, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setInstallerPackageName(String string2, String string3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setLastChosenActivity(Intent intent, String string2, int n, IntentFilter intentFilter, int n2, ComponentName componentName) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (intent != null) {
                        parcel.writeInt(1);
                        intent.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    if (intentFilter != null) {
                        parcel.writeInt(1);
                        intentFilter.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(61, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setPackageStoppedState(String string2, boolean bl, int n) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    parcel2.writeInt(n);
                    this.mRemote.transact(75, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void setPermissionEnforced(String string2, boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(103, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            @Override
            public void systemReady() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(86, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void updateExternalMediaStatus(boolean bl, boolean bl2) throws RemoteException {
                int n = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    int n2 = bl ? n : 0;
                    parcel.writeInt(n2);
                    if (!bl2) {
                        n = 0;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(91, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void verifyPendingInstall(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(98, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

