/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ILauncherApps;
import android.content.pm.IOnAppsChangedListener;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LauncherApps {
    static final boolean DEBUG = false;
    static final String TAG = "LauncherApps";
    private IOnAppsChangedListener.Stub mAppsChangedListener;
    private List<CallbackMessageHandler> mCallbacks = new ArrayList<CallbackMessageHandler>();
    private Context mContext;
    private PackageManager mPm;
    private ILauncherApps mService;

    public LauncherApps(Context context, ILauncherApps iLauncherApps) {
        this.mAppsChangedListener = new IOnAppsChangedListener.Stub(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPackageAdded(UserHandle userHandle, String string2) throws RemoteException {
                LauncherApps launcherApps = LauncherApps.this;
                synchronized (launcherApps) {
                    Iterator iterator = LauncherApps.this.mCallbacks.iterator();
                    while (iterator.hasNext()) {
                        ((CallbackMessageHandler)iterator.next()).postOnPackageAdded(string2, userHandle);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPackageChanged(UserHandle userHandle, String string2) throws RemoteException {
                LauncherApps launcherApps = LauncherApps.this;
                synchronized (launcherApps) {
                    Iterator iterator = LauncherApps.this.mCallbacks.iterator();
                    while (iterator.hasNext()) {
                        ((CallbackMessageHandler)iterator.next()).postOnPackageChanged(string2, userHandle);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPackageRemoved(UserHandle userHandle, String string2) throws RemoteException {
                LauncherApps launcherApps = LauncherApps.this;
                synchronized (launcherApps) {
                    Iterator iterator = LauncherApps.this.mCallbacks.iterator();
                    while (iterator.hasNext()) {
                        ((CallbackMessageHandler)iterator.next()).postOnPackageRemoved(string2, userHandle);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPackagesAvailable(UserHandle userHandle, String[] stringArray, boolean bl) throws RemoteException {
                LauncherApps launcherApps = LauncherApps.this;
                synchronized (launcherApps) {
                    Iterator iterator = LauncherApps.this.mCallbacks.iterator();
                    while (iterator.hasNext()) {
                        ((CallbackMessageHandler)iterator.next()).postOnPackagesAvailable(stringArray, userHandle, bl);
                    }
                    return;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onPackagesUnavailable(UserHandle userHandle, String[] stringArray, boolean bl) throws RemoteException {
                LauncherApps launcherApps = LauncherApps.this;
                synchronized (launcherApps) {
                    Iterator iterator = LauncherApps.this.mCallbacks.iterator();
                    while (iterator.hasNext()) {
                        ((CallbackMessageHandler)iterator.next()).postOnPackagesUnavailable(stringArray, userHandle, bl);
                    }
                    return;
                }
            }
        };
        this.mContext = context;
        this.mService = iLauncherApps;
        this.mPm = context.getPackageManager();
    }

    private void addCallbackLocked(Callback callback, Handler handler) {
        this.removeCallbackLocked(callback);
        if (handler == null) {
            handler = new Handler();
        }
        CallbackMessageHandler callbackMessageHandler = new CallbackMessageHandler(handler.getLooper(), callback);
        this.mCallbacks.add(callbackMessageHandler);
    }

    static ComponentName getComponentName(ResolveInfo resolveInfo) {
        return new ComponentName(resolveInfo.activityInfo.packageName, resolveInfo.activityInfo.name);
    }

    private void removeCallbackLocked(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        int n = this.mCallbacks.size();
        int n2 = 0;
        while (true) {
            block6: {
                block5: {
                    if (n2 >= n) break block5;
                    if (this.mCallbacks.get(n2).mCallback != callback) break block6;
                    this.mCallbacks.remove(n2);
                }
                return;
            }
            ++n2;
        }
    }

    public void addCallback(Callback callback) {
        this.registerCallback(callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<LauncherActivityInfo> getActivityList(String string2, UserHandle userHandle) {
        List<ResolveInfo> list;
        try {
            List<ResolveInfo> list2;
            list = list2 = this.mService.getLauncherActivities(string2, userHandle);
        }
        catch (RemoteException remoteException) {
            list = null;
        }
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<LauncherActivityInfo> arrayList = new ArrayList<LauncherActivityInfo>();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ResolveInfo resolveInfo = list.get(n2);
            long l = 0L;
            try {
                l = this.mPm.getPackageInfo((String)resolveInfo.activityInfo.packageName, (int)8192).firstInstallTime;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            arrayList.add(new LauncherActivityInfo(this.mContext, resolveInfo, userHandle, l));
            ++n2;
        }
        return arrayList;
    }

    public boolean isActivityEnabled(ComponentName componentName, UserHandle userHandle) {
        try {
            boolean bl = this.mService.isActivityEnabled(componentName, userHandle);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
    }

    public boolean isPackageEnabled(String string2, UserHandle userHandle) {
        try {
            boolean bl = this.mService.isPackageEnabled(string2, userHandle);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
    }

    public void registerCallback(Callback callback) {
        this.registerCallback(callback, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerCallback(Callback callback, Handler handler) {
        synchronized (this) {
            if (callback != null && !this.mCallbacks.contains(callback)) {
                boolean bl = this.mCallbacks.size() == 0;
                this.addCallbackLocked(callback, handler);
                if (bl) {
                    try {
                        this.mService.addOnAppsChangedListener(this.mAppsChangedListener);
                    }
                    catch (RemoteException remoteException) {}
                }
            }
            return;
        }
    }

    public void removeCallback(Callback callback) {
        this.unregisterCallback(callback);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LauncherActivityInfo resolveActivity(Intent intent, UserHandle userHandle) {
        long l;
        ResolveInfo resolveInfo;
        try {
            resolveInfo = this.mService.resolveActivity(intent, userHandle);
            if (resolveInfo == null) return null;
            l = 0L;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Failed to call LauncherAppsService");
        }
        try {
            l = this.mPm.getPackageInfo((String)resolveInfo.activityInfo.packageName, (int)8192).firstInstallTime;
            return new LauncherActivityInfo(this.mContext, resolveInfo, userHandle, l);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return new LauncherActivityInfo(this.mContext, resolveInfo, userHandle, l);
        }
    }

    public void startAppDetailsActivity(ComponentName componentName, UserHandle userHandle, Rect rect, Bundle bundle) {
        try {
            this.mService.showAppDetailsAsUser(componentName, rect, bundle, userHandle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void startMainActivity(ComponentName componentName, UserHandle userHandle, Rect rect, Bundle bundle) {
        try {
            this.mService.startActivityAsUser(componentName, rect, bundle, userHandle);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterCallback(Callback callback) {
        synchronized (this) {
            this.removeCallbackLocked(callback);
            int n = this.mCallbacks.size();
            if (n == 0) {
                try {
                    this.mService.removeOnAppsChangedListener(this.mAppsChangedListener);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    public static abstract class Callback {
        public abstract void onPackageAdded(String var1, UserHandle var2);

        public abstract void onPackageChanged(String var1, UserHandle var2);

        public abstract void onPackageRemoved(String var1, UserHandle var2);

        public abstract void onPackagesAvailable(String[] var1, UserHandle var2, boolean var3);

        public abstract void onPackagesUnavailable(String[] var1, UserHandle var2, boolean var3);
    }

    private static class CallbackMessageHandler
    extends Handler {
        private static final int MSG_ADDED = 1;
        private static final int MSG_AVAILABLE = 4;
        private static final int MSG_CHANGED = 3;
        private static final int MSG_REMOVED = 2;
        private static final int MSG_UNAVAILABLE = 5;
        private Callback mCallback;

        public CallbackMessageHandler(Looper looper, Callback callback) {
            super(looper, null, true);
            this.mCallback = callback;
        }

        @Override
        public void handleMessage(Message message) {
            if (this.mCallback == null || !(message.obj instanceof CallbackInfo)) {
                return;
            }
            CallbackInfo callbackInfo = (CallbackInfo)message.obj;
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    this.mCallback.onPackageAdded(callbackInfo.packageName, callbackInfo.user);
                    return;
                }
                case 2: {
                    this.mCallback.onPackageRemoved(callbackInfo.packageName, callbackInfo.user);
                    return;
                }
                case 3: {
                    this.mCallback.onPackageChanged(callbackInfo.packageName, callbackInfo.user);
                    return;
                }
                case 4: {
                    this.mCallback.onPackagesAvailable(callbackInfo.packageNames, callbackInfo.user, callbackInfo.replacing);
                    return;
                }
                case 5: 
            }
            this.mCallback.onPackagesUnavailable(callbackInfo.packageNames, callbackInfo.user, callbackInfo.replacing);
        }

        public void postOnPackageAdded(String string2, UserHandle userHandle) {
            CallbackInfo callbackInfo = new CallbackInfo();
            callbackInfo.packageName = string2;
            callbackInfo.user = userHandle;
            this.obtainMessage(1, callbackInfo).sendToTarget();
        }

        public void postOnPackageChanged(String string2, UserHandle userHandle) {
            CallbackInfo callbackInfo = new CallbackInfo();
            callbackInfo.packageName = string2;
            callbackInfo.user = userHandle;
            this.obtainMessage(3, callbackInfo).sendToTarget();
        }

        public void postOnPackageRemoved(String string2, UserHandle userHandle) {
            CallbackInfo callbackInfo = new CallbackInfo();
            callbackInfo.packageName = string2;
            callbackInfo.user = userHandle;
            this.obtainMessage(2, callbackInfo).sendToTarget();
        }

        public void postOnPackagesAvailable(String[] stringArray, UserHandle userHandle, boolean bl) {
            CallbackInfo callbackInfo = new CallbackInfo();
            callbackInfo.packageNames = stringArray;
            callbackInfo.replacing = bl;
            callbackInfo.user = userHandle;
            this.obtainMessage(4, callbackInfo).sendToTarget();
        }

        public void postOnPackagesUnavailable(String[] stringArray, UserHandle userHandle, boolean bl) {
            CallbackInfo callbackInfo = new CallbackInfo();
            callbackInfo.packageNames = stringArray;
            callbackInfo.replacing = bl;
            callbackInfo.user = userHandle;
            this.obtainMessage(5, callbackInfo).sendToTarget();
        }

        private static class CallbackInfo {
            String packageName;
            String[] packageNames;
            boolean replacing;
            UserHandle user;

            private CallbackInfo() {
            }
        }
    }
}

