/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.DatabaseUtils;
import java.util.ArrayList;

public class MatrixCursor
extends AbstractCursor {
    private final int columnCount;
    private final String[] columnNames;
    private Object[] data;
    private int rowCount = 0;

    public MatrixCursor(String[] stringArray) {
        this(stringArray, 16);
    }

    public MatrixCursor(String[] stringArray, int n) {
        this.columnNames = stringArray;
        this.columnCount = stringArray.length;
        if (n < 1) {
            n = 1;
        }
        this.data = new Object[n * this.columnCount];
    }

    private void addRow(ArrayList<?> arrayList, int n) {
        int n2 = arrayList.size();
        if (n2 != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.size() = " + n2);
        }
        this.rowCount = 1 + this.rowCount;
        Object[] objectArray = this.data;
        for (int i = 0; i < n2; ++i) {
            objectArray[n + i] = arrayList.get(i);
        }
    }

    private void ensureCapacity(int n) {
        if (n > this.data.length) {
            Object[] objectArray = this.data;
            int n2 = 2 * this.data.length;
            if (n2 < n) {
                n2 = n;
            }
            this.data = new Object[n2];
            System.arraycopy(objectArray, 0, this.data, 0, objectArray.length);
        }
    }

    private Object get(int n) {
        if (n < 0 || n >= this.columnCount) {
            throw new CursorIndexOutOfBoundsException("Requested column: " + n + ", # of columns: " + this.columnCount);
        }
        if (this.mPos < 0) {
            throw new CursorIndexOutOfBoundsException("Before first row.");
        }
        if (this.mPos >= this.rowCount) {
            throw new CursorIndexOutOfBoundsException("After last row.");
        }
        return this.data[n + this.mPos * this.columnCount];
    }

    public void addRow(Iterable<?> iterable) {
        int n = this.rowCount * this.columnCount;
        int n2 = n + this.columnCount;
        this.ensureCapacity(n2);
        if (iterable instanceof ArrayList) {
            this.addRow((ArrayList)iterable, n);
            return;
        }
        int n3 = n;
        Object[] objectArray = this.data;
        for (Object obj : iterable) {
            if (n3 == n2) {
                throw new IllegalArgumentException("columnValues.size() > columnNames.length");
            }
            int n4 = n3 + 1;
            objectArray[n3] = obj;
            n3 = n4;
        }
        if (n3 != n2) {
            throw new IllegalArgumentException("columnValues.size() < columnNames.length");
        }
        this.rowCount = 1 + this.rowCount;
    }

    public void addRow(Object[] objectArray) {
        if (objectArray.length != this.columnCount) {
            throw new IllegalArgumentException("columnNames.length = " + this.columnCount + ", columnValues.length = " + objectArray.length);
        }
        int n = this.rowCount;
        this.rowCount = n + 1;
        int n2 = n * this.columnCount;
        this.ensureCapacity(n2 + this.columnCount);
        System.arraycopy(objectArray, 0, this.data, n2, this.columnCount);
    }

    @Override
    public byte[] getBlob(int n) {
        return (byte[])this.get(n);
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public int getCount() {
        return this.rowCount;
    }

    @Override
    public double getDouble(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0.0;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return Double.parseDouble(object.toString());
    }

    @Override
    public float getFloat(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        return Float.parseFloat(object.toString());
    }

    @Override
    public int getInt(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return Integer.parseInt(object.toString());
    }

    @Override
    public long getLong(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        return Long.parseLong(object.toString());
    }

    @Override
    public short getShort(int n) {
        Object object = this.get(n);
        if (object == null) {
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        return Short.parseShort(object.toString());
    }

    @Override
    public String getString(int n) {
        Object object = this.get(n);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Override
    public int getType(int n) {
        return DatabaseUtils.getTypeOfObject(this.get(n));
    }

    @Override
    public boolean isNull(int n) {
        return this.get(n) == null;
    }

    public RowBuilder newRow() {
        int n = this.rowCount;
        this.rowCount = n + 1;
        this.ensureCapacity(this.rowCount * this.columnCount);
        return new RowBuilder(n);
    }

    public class RowBuilder {
        private final int endIndex;
        private int index;
        private final int row;

        RowBuilder(int n) {
            this.row = n;
            this.index = n * MatrixCursor.this.columnCount;
            this.endIndex = this.index + MatrixCursor.this.columnCount;
        }

        public RowBuilder add(Object object) {
            if (this.index == this.endIndex) {
                throw new CursorIndexOutOfBoundsException("No more columns left.");
            }
            Object[] objectArray = MatrixCursor.this.data;
            int n = this.index;
            this.index = n + 1;
            objectArray[n] = object;
            return this;
        }

        public RowBuilder add(String string2, Object object) {
            for (int i = 0; i < MatrixCursor.this.columnNames.length; ++i) {
                if (!string2.equals(MatrixCursor.this.columnNames[i])) continue;
                ((MatrixCursor)MatrixCursor.this).data[i + this.row * ((MatrixCursor)MatrixCursor.this).columnCount] = object;
            }
            return this;
        }
    }
}

