/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.AbstractWindowedCursor;
import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.DatabaseObjectNotClosedException;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQuery;
import android.os.StrictMode;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final int NO_COUNT = -1;
    static final String TAG = "SQLiteCursor";
    private Map<String, Integer> mColumnNameMap;
    private final String[] mColumns;
    private int mCount = -1;
    private int mCursorWindowCapacity;
    private final SQLiteCursorDriver mDriver;
    private final String mEditTable;
    private final SQLiteQuery mQuery;
    private final Throwable mStackTrace;

    /*
     * Enabled aggressive block sorting
     */
    public SQLiteCursor(SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        if (sQLiteQuery == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        this.mStackTrace = StrictMode.vmSqliteObjectLeaksEnabled() ? new DatabaseObjectNotClosedException().fillInStackTrace() : null;
        this.mDriver = sQLiteCursorDriver;
        this.mEditTable = string2;
        this.mColumnNameMap = null;
        this.mQuery = sQLiteQuery;
        this.mColumns = sQLiteQuery.getColumnNames();
        this.mRowIdColumnIndex = DatabaseUtils.findRowIdColumnIndex(this.mColumns);
    }

    @Deprecated
    public SQLiteCursor(SQLiteDatabase sQLiteDatabase, SQLiteCursorDriver sQLiteCursorDriver, String string2, SQLiteQuery sQLiteQuery) {
        this(sQLiteCursorDriver, string2, sQLiteQuery);
    }

    private void fillWindow(int n) {
        block4: {
            this.clearOrCreateWindow(this.getDatabase().getPath());
            try {
                if (this.mCount == -1) {
                    int n2 = DatabaseUtils.cursorPickFillWindowStartPosition(n, 0);
                    this.mCount = this.mQuery.fillWindow(this.mWindow, n2, n, true);
                    this.mCursorWindowCapacity = this.mWindow.getNumRows();
                    if (Log.isLoggable(TAG, 3)) {
                        Log.d(TAG, "received count(*) from native_fill_window: " + this.mCount);
                        return;
                    }
                    break block4;
                }
                int n3 = DatabaseUtils.cursorPickFillWindowStartPosition(n, this.mCursorWindowCapacity);
                this.mQuery.fillWindow(this.mWindow, n3, n, false);
                return;
            }
            catch (RuntimeException runtimeException) {
                this.closeWindow();
                throw runtimeException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        super.close();
        synchronized (this) {
            this.mQuery.close();
            this.mDriver.cursorClosed();
            return;
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.mDriver.cursorDeactivated();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void finalize() {
        try {
            if (this.mWindow == null) return;
            if (this.mStackTrace != null) {
                String string2 = this.mQuery.getSql();
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder().append("Finalizing a Cursor that has not been deactivated or closed. database = ").append(this.mQuery.getDatabase().getLabel()).append(", table = ").append(this.mEditTable).append(", query = ");
                if (n > 1000) {
                    n = 1000;
                }
                StrictMode.onSqliteObjectLeaked(stringBuilder.append(string2.substring(0, n)).toString(), this.mStackTrace);
            }
            this.close();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public int getColumnIndex(String string2) {
        Integer n;
        int n2;
        int n3 = -1;
        if (this.mColumnNameMap == null) {
            String[] stringArray = this.mColumns;
            int n4 = stringArray.length;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(n4, 1.0f);
            for (int i = 0; i < n4; ++i) {
                hashMap.put(stringArray[i], i);
            }
            this.mColumnNameMap = hashMap;
        }
        if ((n2 = string2.lastIndexOf(46)) != n3) {
            Exception exception = new Exception();
            Log.e(TAG, "requesting column name with table name -- " + string2, exception);
            string2 = string2.substring(n2 + 1);
        }
        if ((n = this.mColumnNameMap.get(string2)) != null) {
            n3 = n;
        }
        return n3;
    }

    @Override
    public String[] getColumnNames() {
        return this.mColumns;
    }

    @Override
    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    public SQLiteDatabase getDatabase() {
        return this.mQuery.getDatabase();
    }

    @Override
    public boolean onMove(int n, int n2) {
        if (this.mWindow == null || n2 < this.mWindow.getStartPosition() || n2 >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(n2);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        synchronized (this) {
            if (!this.mQuery.getDatabase().isOpen()) {
                return false;
            }
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            this.mCount = -1;
            this.mDriver.cursorRequeried(this);
        }
        try {
            return super.requery();
        }
        catch (IllegalStateException illegalStateException) {
            Log.w(TAG, "requery() failed " + illegalStateException.getMessage(), illegalStateException);
            return false;
        }
    }

    public void setSelectionArguments(String[] stringArray) {
        this.mDriver.setBindArguments(stringArray);
    }

    @Override
    public void setWindow(CursorWindow cursorWindow) {
        super.setWindow(cursorWindow);
        this.mCount = -1;
    }
}

