/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Printer;
import java.util.ArrayList;

public final class SQLiteDebug {
    public static final boolean DEBUG_LOG_SLOW_QUERIES;
    public static final boolean DEBUG_SQL_LOG;
    public static final boolean DEBUG_SQL_STATEMENTS;
    public static final boolean DEBUG_SQL_TIME;

    static {
        DEBUG_SQL_LOG = Log.isLoggable("SQLiteLog", 2);
        DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
        DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
        DEBUG_LOG_SLOW_QUERIES = Build.IS_DEBUGGABLE;
    }

    private SQLiteDebug() {
    }

    public static void dump(Printer printer, String[] stringArray) {
        boolean bl = false;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals("-v")) continue;
            bl = true;
        }
        SQLiteDatabase.dumpAll(printer, bl);
    }

    public static PagerStats getDatabaseInfo() {
        PagerStats pagerStats = new PagerStats();
        SQLiteDebug.nativeGetPagerStats(pagerStats);
        pagerStats.dbStats = SQLiteDatabase.getDbStats();
        return pagerStats;
    }

    private static native void nativeGetPagerStats(PagerStats var0);

    public static final boolean shouldLogSlowQuery(long l) {
        int n = SystemProperties.getInt("db.log.slow_query_threshold", -1);
        return n >= 0 && l >= (long)n;
    }

    public static class DbStats {
        public String cache;
        public String dbName;
        public long dbSize;
        public int lookaside;
        public long pageSize;

        public DbStats(String string2, long l, long l2, int n, int n2, int n3, int n4) {
            this.dbName = string2;
            this.pageSize = l2 / 1024L;
            this.dbSize = l * l2 / 1024L;
            this.lookaside = n;
            this.cache = n2 + "/" + n3 + "/" + n4;
        }
    }

    public static class PagerStats {
        public ArrayList<DbStats> dbStats;
        public int largestMemAlloc;
        public int memoryUsed;
        public int pageCacheOverflow;
    }
}

