/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteStatementInfo;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;

public final class SQLiteSession {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int TRANSACTION_MODE_DEFERRED = 0;
    public static final int TRANSACTION_MODE_EXCLUSIVE = 2;
    public static final int TRANSACTION_MODE_IMMEDIATE = 1;
    private SQLiteConnection mConnection;
    private int mConnectionFlags;
    private final SQLiteConnectionPool mConnectionPool;
    private int mConnectionUseCount;
    private Transaction mTransactionPool;
    private Transaction mTransactionStack;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !SQLiteSession.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    public SQLiteSession(SQLiteConnectionPool sQLiteConnectionPool) {
        if (sQLiteConnectionPool == null) {
            throw new IllegalArgumentException("connectionPool must not be null");
        }
        this.mConnectionPool = sQLiteConnectionPool;
    }

    private void acquireConnection(String string2, int n, CancellationSignal cancellationSignal) {
        if (this.mConnection == null) {
            if (!$assertionsDisabled && this.mConnectionUseCount != 0) {
                throw new AssertionError();
            }
            this.mConnection = this.mConnectionPool.acquireConnection(string2, n, cancellationSignal);
            this.mConnectionFlags = n;
        }
        this.mConnectionUseCount = 1 + this.mConnectionUseCount;
    }

    /*
     * Exception decompiling
     */
    private void beginTransactionUnchecked(int var1_1, SQLiteTransactionListener var2_2, int var3_3, CancellationSignal var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [6 : 144->159)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private void endTransactionUnchecked(CancellationSignal var1_1, boolean var2_2) {
        block16: {
            block17: {
                block15: {
                    block14: {
                        if (var1_1 != null) {
                            var1_1.throwIfCanceled();
                        }
                        var3_3 = this.mTransactionStack;
                        if ((var3_3.mMarkedSuccessful || var2_2) && !var3_3.mChildFailed) {
                            var4_4 = true;
lbl6:
                            // 2 sources

                            while (true) {
                                var5_5 = var3_3.mListener;
                                var6_6 = null;
                                if (var5_5 != null) {
                                    if (!var4_4) break block14;
                                    var5_5.onCommit();
                                }
lbl13:
                                // 4 sources

                                while (true) {
                                    this.mTransactionStack = var3_3.mParent;
                                    this.recycleTransaction(var3_3);
                                    if (this.mTransactionStack == null) break block15;
                                    if (!var4_4) {
                                        this.mTransactionStack.mChildFailed = true;
                                    }
lbl19:
                                    // 6 sources

                                    while (var6_6 != null) {
                                        throw var6_6;
                                    }
                                    break block16;
                                    break;
                                }
                                break;
                            }
                        }
                        var4_4 = false;
                        ** while (true)
                    }
                    try {
                        var5_5.onRollback();
                        var6_6 = null;
                    }
                    catch (RuntimeException var8_7) {
                        var6_6 = var8_7;
                        var4_4 = false;
                    }
                    ** while (true)
                }
                if (!var4_4) break block17;
                this.mConnection.execute("COMMIT;", null, var1_1);
                ** GOTO lbl19
            }
            try {
                this.mConnection.execute("ROLLBACK;", null, var1_1);
                ** GOTO lbl19
            }
            catch (Throwable var7_8) {
                throw var7_8;
            }
            finally {
                this.releaseConnection();
                ** GOTO lbl19
            }
        }
    }

    private boolean executeSpecial(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        switch (DatabaseUtils.getSqlStatementType(string2)) {
            default: {
                return false;
            }
            case 4: {
                this.beginTransaction(2, null, n, cancellationSignal);
                return true;
            }
            case 5: {
                this.setTransactionSuccessful();
                this.endTransaction(cancellationSignal);
                return true;
            }
            case 6: 
        }
        this.endTransaction(cancellationSignal);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Transaction obtainTransaction(int n, SQLiteTransactionListener sQLiteTransactionListener) {
        Transaction transaction = this.mTransactionPool;
        if (transaction != null) {
            this.mTransactionPool = transaction.mParent;
            transaction.mParent = null;
            transaction.mMarkedSuccessful = false;
            transaction.mChildFailed = false;
        } else {
            transaction = new Transaction();
        }
        transaction.mMode = n;
        transaction.mListener = sQLiteTransactionListener;
        return transaction;
    }

    private void recycleTransaction(Transaction transaction) {
        transaction.mParent = this.mTransactionPool;
        transaction.mListener = null;
        this.mTransactionPool = transaction;
    }

    private void releaseConnection() {
        int n;
        if (!$assertionsDisabled && this.mConnection == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mConnectionUseCount <= 0) {
            throw new AssertionError();
        }
        this.mConnectionUseCount = n = -1 + this.mConnectionUseCount;
        if (n == 0) {
            this.mConnectionPool.releaseConnection(this.mConnection);
        }
        return;
        finally {
            this.mConnection = null;
        }
    }

    private void throwIfNestedTransaction() {
        if (this.hasNestedTransaction()) {
            throw new IllegalStateException("Cannot perform this operation because a nested transaction is in progress.");
        }
    }

    private void throwIfNoTransaction() {
        if (this.mTransactionStack == null) {
            throw new IllegalStateException("Cannot perform this operation because there is no current transaction.");
        }
    }

    private void throwIfTransactionMarkedSuccessful() {
        if (this.mTransactionStack != null && this.mTransactionStack.mMarkedSuccessful) {
            throw new IllegalStateException("Cannot perform this operation because the transaction has already been marked successful.  The only thing you can do now is call endTransaction().");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean yieldTransactionUnchecked(long l, CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if (!this.mConnectionPool.shouldYieldConnection(this.mConnection, this.mConnectionFlags)) {
            return false;
        }
        int n = this.mTransactionStack.mMode;
        SQLiteTransactionListener sQLiteTransactionListener = this.mTransactionStack.mListener;
        int n2 = this.mConnectionFlags;
        this.endTransactionUnchecked(cancellationSignal, true);
        if (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.beginTransactionUnchecked(n, sQLiteTransactionListener, n2, cancellationSignal);
        return true;
    }

    public void beginTransaction(int n, SQLiteTransactionListener sQLiteTransactionListener, int n2, CancellationSignal cancellationSignal) {
        this.throwIfTransactionMarkedSuccessful();
        this.beginTransactionUnchecked(n, sQLiteTransactionListener, n2, cancellationSignal);
    }

    public void endTransaction(CancellationSignal cancellationSignal) {
        this.throwIfNoTransaction();
        if (!$assertionsDisabled && this.mConnection == null) {
            throw new AssertionError();
        }
        this.endTransactionUnchecked(cancellationSignal, false);
    }

    public void execute(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n, cancellationSignal)) {
            return;
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            this.mConnection.execute(string2, objectArray, cancellationSignal);
            return;
        }
        finally {
            this.releaseConnection();
        }
    }

    public ParcelFileDescriptor executeForBlobFileDescriptor(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n, cancellationSignal)) {
            return null;
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            ParcelFileDescriptor parcelFileDescriptor = this.mConnection.executeForBlobFileDescriptor(string2, objectArray, cancellationSignal);
            return parcelFileDescriptor;
        }
        finally {
            this.releaseConnection();
        }
    }

    public int executeForChangedRowCount(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n, cancellationSignal)) {
            return 0;
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            int n2 = this.mConnection.executeForChangedRowCount(string2, objectArray, cancellationSignal);
            return n2;
        }
        finally {
            this.releaseConnection();
        }
    }

    public int executeForCursorWindow(String string2, Object[] objectArray, CursorWindow cursorWindow, int n, int n2, boolean bl, int n3, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (cursorWindow == null) {
            throw new IllegalArgumentException("window must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n3, cancellationSignal)) {
            cursorWindow.clear();
            return 0;
        }
        this.acquireConnection(string2, n3, cancellationSignal);
        try {
            int n4 = this.mConnection.executeForCursorWindow(string2, objectArray, cursorWindow, n, n2, bl, cancellationSignal);
            return n4;
        }
        finally {
            this.releaseConnection();
        }
    }

    public long executeForLastInsertedRowId(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n, cancellationSignal)) {
            return 0L;
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            long l = this.mConnection.executeForLastInsertedRowId(string2, objectArray, cancellationSignal);
            return l;
        }
        finally {
            this.releaseConnection();
        }
    }

    public long executeForLong(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n, cancellationSignal)) {
            return 0L;
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            long l = this.mConnection.executeForLong(string2, objectArray, cancellationSignal);
            return l;
        }
        finally {
            this.releaseConnection();
        }
    }

    public String executeForString(String string2, Object[] objectArray, int n, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (this.executeSpecial(string2, objectArray, n, cancellationSignal)) {
            return null;
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            String string3 = this.mConnection.executeForString(string2, objectArray, cancellationSignal);
            return string3;
        }
        finally {
            this.releaseConnection();
        }
    }

    public boolean hasConnection() {
        return this.mConnection != null;
    }

    public boolean hasNestedTransaction() {
        return this.mTransactionStack != null && this.mTransactionStack.mParent != null;
    }

    public boolean hasTransaction() {
        return this.mTransactionStack != null;
    }

    public void prepare(String string2, int n, CancellationSignal cancellationSignal, SQLiteStatementInfo sQLiteStatementInfo) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        this.acquireConnection(string2, n, cancellationSignal);
        try {
            this.mConnection.prepare(string2, sQLiteStatementInfo);
            return;
        }
        finally {
            this.releaseConnection();
        }
    }

    public void setTransactionSuccessful() {
        this.throwIfNoTransaction();
        this.throwIfTransactionMarkedSuccessful();
        this.mTransactionStack.mMarkedSuccessful = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean yieldTransaction(long l, boolean bl, CancellationSignal cancellationSignal) {
        block7: {
            block6: {
                block5: {
                    block4: {
                        if (!bl) break block4;
                        this.throwIfNoTransaction();
                        this.throwIfTransactionMarkedSuccessful();
                        this.throwIfNestedTransaction();
                        break block5;
                    }
                    if (this.mTransactionStack == null || this.mTransactionStack.mMarkedSuccessful || this.mTransactionStack.mParent != null) break block6;
                }
                if (!$assertionsDisabled && this.mConnection == null) {
                    throw new AssertionError();
                }
                if (!this.mTransactionStack.mChildFailed) break block7;
            }
            return false;
        }
        return this.yieldTransactionUnchecked(l, cancellationSignal);
    }

    private static final class Transaction {
        public boolean mChildFailed;
        public SQLiteTransactionListener mListener;
        public boolean mMarkedSuccessful;
        public int mMode;
        public Transaction mParent;

        private Transaction() {
        }
    }
}

