/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import java.util.HashMap;
import java.util.Iterator;

public class DrmInfoRequest {
    public static final String ACCOUNT_ID = "account_id";
    public static final String SUBSCRIPTION_ID = "subscription_id";
    public static final int TYPE_REGISTRATION_INFO = 1;
    public static final int TYPE_RIGHTS_ACQUISITION_INFO = 3;
    public static final int TYPE_RIGHTS_ACQUISITION_PROGRESS_INFO = 4;
    public static final int TYPE_UNREGISTRATION_INFO = 2;
    private final int mInfoType;
    private final String mMimeType;
    private final HashMap<String, Object> mRequestInformation = new HashMap();

    public DrmInfoRequest(int n, String string2) {
        this.mInfoType = n;
        this.mMimeType = string2;
        if (!this.isValid()) {
            throw new IllegalArgumentException("infoType: " + n + "," + "mimeType: " + string2);
        }
    }

    static boolean isValidType(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
        }
        return true;
    }

    public Object get(String string2) {
        return this.mRequestInformation.get(string2);
    }

    public int getInfoType() {
        return this.mInfoType;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    boolean isValid() {
        return this.mMimeType != null && !this.mMimeType.equals("") && this.mRequestInformation != null && DrmInfoRequest.isValidType(this.mInfoType);
    }

    public Iterator<Object> iterator() {
        return this.mRequestInformation.values().iterator();
    }

    public Iterator<String> keyIterator() {
        return this.mRequestInformation.keySet().iterator();
    }

    public void put(String string2, Object object) {
        this.mRequestInformation.put(string2, object);
    }
}

