/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;

public class DrmUtils {
    public static ExtendedMetadataParser getExtendedMetadataParser(byte[] byArray) {
        return new ExtendedMetadataParser(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void quietlyDispose(InputStream inputStream) {
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void quietlyDispose(OutputStream outputStream) {
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        BufferedInputStream bufferedInputStream;
        FileInputStream fileInputStream;
        block4: {
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n = bufferedInputStream.available();
            byArray = null;
            if (n <= 0) break block4;
            byArray = new byte[n];
            bufferedInputStream.read(byArray);
        }
        return byArray;
        finally {
            DrmUtils.quietlyDispose(bufferedInputStream);
            DrmUtils.quietlyDispose(fileInputStream);
        }
    }

    static byte[] readBytes(String string2) throws IOException {
        return DrmUtils.readBytes(new File(string2));
    }

    static void removeFile(String string2) throws IOException {
        new File(string2).delete();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static void writeToFile(String string2, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream;
        FileOutputStream fileOutputStream2 = null;
        if (string2 == null) return;
        if (byArray == null) return;
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (Throwable throwable) {}
        try {
            fileOutputStream.write(byArray);
        }
        catch (Throwable throwable) {
            fileOutputStream2 = fileOutputStream;
        }
        DrmUtils.quietlyDispose(fileOutputStream);
        return;
        {
            void var4_5;
            DrmUtils.quietlyDispose(fileOutputStream2);
            throw var4_5;
        }
    }

    public static class ExtendedMetadataParser {
        HashMap<String, String> mMap = new HashMap();

        private ExtendedMetadataParser(byte[] byArray) {
            int n = 0;
            while (n < byArray.length) {
                int n2 = this.readByte(byArray, n);
                int n3 = n + 1;
                int n4 = this.readByte(byArray, n3);
                int n5 = n3 + 1;
                String string2 = this.readMultipleBytes(byArray, n2, n5);
                int n6 = n5 + n2;
                String string3 = this.readMultipleBytes(byArray, n4, n6);
                if (string3.equals(" ")) {
                    string3 = "";
                }
                n = n6 + n4;
                this.mMap.put(string2, string3);
            }
        }

        private int readByte(byte[] byArray, int n) {
            return byArray[n];
        }

        private String readMultipleBytes(byte[] byArray, int n, int n2) {
            byte[] byArray2 = new byte[n];
            int n3 = n2;
            int n4 = 0;
            while (n3 < n2 + n) {
                byArray2[n4] = byArray[n3];
                ++n3;
                ++n4;
            }
            return new String(byArray2);
        }

        public String get(String string2) {
            return this.mMap.get(string2);
        }

        public Iterator<String> iterator() {
            return this.mMap.values().iterator();
        }

        public Iterator<String> keyIterator() {
            return this.mMap.keySet().iterator();
        }
    }
}

