/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.util.Log;

public abstract class FilterPort {
    private static final String TAG = "FilterPort";
    protected boolean mChecksType = false;
    protected Filter mFilter;
    protected boolean mIsBlocking = true;
    protected boolean mIsOpen = false;
    private boolean mLogVerbose;
    protected String mName;
    protected FrameFormat mPortFormat;

    public FilterPort(Filter filter, String string2) {
        this.mName = string2;
        this.mFilter = filter;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    protected void assertPortIsOpen() {
        if (!this.isOpen()) {
            throw new RuntimeException("Illegal operation on closed " + this + "!");
        }
    }

    protected void checkFrameManager(Frame frame, FilterContext filterContext) {
        if (frame.getFrameManager() != null && frame.getFrameManager() != filterContext.getFrameManager()) {
            throw new RuntimeException("Frame " + frame + " is managed by foreign FrameManager! ");
        }
    }

    protected void checkFrameType(Frame frame, boolean bl) {
        if ((this.mChecksType || bl) && this.mPortFormat != null && !frame.getFormat().isCompatibleWith(this.mPortFormat)) {
            throw new RuntimeException("Frame passed to " + this + " is of incorrect type! " + "Expected " + this.mPortFormat + " but got " + frame.getFormat());
        }
    }

    public abstract void clear();

    public void close() {
        if (this.mIsOpen && this.mLogVerbose) {
            Log.v(TAG, "Closing " + this);
        }
        this.mIsOpen = false;
    }

    public abstract boolean filterMustClose();

    public Filter getFilter() {
        return this.mFilter;
    }

    public String getName() {
        return this.mName;
    }

    public FrameFormat getPortFormat() {
        return this.mPortFormat;
    }

    public abstract boolean hasFrame();

    public boolean isAttached() {
        return this.mFilter != null;
    }

    public boolean isBlocking() {
        return this.mIsBlocking;
    }

    public boolean isOpen() {
        return this.mIsOpen;
    }

    public abstract boolean isReady();

    public void open() {
        if (!this.mIsOpen && this.mLogVerbose) {
            Log.v(TAG, "Opening " + this);
        }
        this.mIsOpen = true;
    }

    public abstract Frame pullFrame();

    public abstract void pushFrame(Frame var1);

    public void setBlocking(boolean bl) {
        this.mIsBlocking = bl;
    }

    public void setChecksType(boolean bl) {
        this.mChecksType = bl;
    }

    public abstract void setFrame(Frame var1);

    public void setPortFormat(FrameFormat frameFormat) {
        this.mPortFormat = frameFormat;
    }

    public String toString() {
        return "port '" + this.mName + "' of " + this.mFilter;
    }
}

