/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.io;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterFactory;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.KeyValueMap;
import android.filterfw.core.ProtocolException;
import android.filterfw.io.GraphIOException;
import android.filterfw.io.GraphReader;
import android.filterfw.io.PatternScanner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;

public class TextGraphReader
extends GraphReader {
    private KeyValueMap mBoundReferences;
    private ArrayList<Command> mCommands = new ArrayList();
    private Filter mCurrentFilter;
    private FilterGraph mCurrentGraph;
    private FilterFactory mFactory;
    private KeyValueMap mSettings;

    static /* synthetic */ Filter access$102(TextGraphReader textGraphReader, Filter filter) {
        textGraphReader.mCurrentFilter = filter;
        return filter;
    }

    private void applySettings() throws GraphIOException {
        for (String string2 : this.mSettings.keySet()) {
            Object v = this.mSettings.get(string2);
            if (string2.equals("autoBranch")) {
                this.expectSettingClass(string2, v, String.class);
                if (v.equals("synced")) {
                    this.mCurrentGraph.setAutoBranchMode(1);
                    continue;
                }
                if (v.equals("unsynced")) {
                    this.mCurrentGraph.setAutoBranchMode(2);
                    continue;
                }
                if (v.equals("off")) {
                    this.mCurrentGraph.setAutoBranchMode(0);
                    continue;
                }
                throw new GraphIOException("Unknown autobranch setting: " + v + "!");
            }
            if (string2.equals("discardUnconnectedOutputs")) {
                this.expectSettingClass(string2, v, Boolean.class);
                this.mCurrentGraph.setDiscardUnconnectedOutputs((Boolean)v);
                continue;
            }
            throw new GraphIOException("Unknown @setting '" + string2 + "'!");
        }
    }

    private void bindExternal(String string2) throws GraphIOException {
        if (this.mReferences.containsKey(string2)) {
            Object v = this.mReferences.get(string2);
            this.mBoundReferences.put(string2, v);
            return;
        }
        throw new GraphIOException("Unknown external variable '" + string2 + "'! " + "You must add a reference to this external in the host program using " + "addReference(...)!");
    }

    private void checkReferences() throws GraphIOException {
        for (String string2 : this.mReferences.keySet()) {
            if (this.mBoundReferences.containsKey(string2)) continue;
            throw new GraphIOException("Host program specifies reference to '" + string2 + "', which is not " + "declared @external in graph file!");
        }
    }

    private void executeCommands() throws GraphIOException {
        Iterator<Command> iterator = this.mCommands.iterator();
        while (iterator.hasNext()) {
            iterator.next().execute(this);
        }
    }

    private void expectSettingClass(String string2, Object object, Class clazz) throws GraphIOException {
        if (object.getClass() != clazz) {
            throw new GraphIOException("Setting '" + string2 + "' must have a value of type " + clazz.getSimpleName() + ", but found a value of type " + object.getClass().getSimpleName() + "!");
        }
    }

    private void parseString(String string2) throws GraphIOException {
        Pattern pattern = Pattern.compile("@[a-zA-Z]+");
        Pattern pattern2 = Pattern.compile("\\}");
        Pattern pattern3 = Pattern.compile("\\{");
        Pattern pattern4 = Pattern.compile("(\\s+|//[^\\n]*\\n)+");
        Pattern pattern5 = Pattern.compile("[a-zA-Z\\.]+");
        Pattern pattern6 = Pattern.compile("[a-zA-Z\\./:]+");
        Pattern pattern7 = Pattern.compile("\\[[a-zA-Z0-9\\-_]+\\]");
        Pattern pattern8 = Pattern.compile("=>");
        Pattern pattern9 = Pattern.compile(";");
        Pattern pattern10 = Pattern.compile("[a-zA-Z0-9\\-_]+");
        int n = 0;
        PatternScanner patternScanner = new PatternScanner(string2, pattern4);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        block19: while (!patternScanner.atEnd()) {
            switch (n) {
                default: {
                    continue block19;
                }
                case 0: {
                    String string7 = patternScanner.eat(pattern, "<command>");
                    if (string7.equals("@import")) {
                        n = 1;
                        continue block19;
                    }
                    if (string7.equals("@library")) {
                        n = 2;
                        continue block19;
                    }
                    if (string7.equals("@filter")) {
                        n = 3;
                        continue block19;
                    }
                    if (string7.equals("@connect")) {
                        n = 8;
                        continue block19;
                    }
                    if (string7.equals("@set")) {
                        n = 13;
                        continue block19;
                    }
                    if (string7.equals("@external")) {
                        n = 14;
                        continue block19;
                    }
                    if (string7.equals("@setting")) {
                        n = 15;
                        continue block19;
                    }
                    throw new GraphIOException("Unknown command '" + string7 + "'!");
                }
                case 1: {
                    String string8 = patternScanner.eat(pattern5, "<package-name>");
                    this.mCommands.add(new ImportPackageCommand(string8));
                    n = 16;
                    continue block19;
                }
                case 2: {
                    String string9 = patternScanner.eat(pattern6, "<library-name>");
                    this.mCommands.add(new AddLibraryCommand(string9));
                    n = 16;
                    continue block19;
                }
                case 3: {
                    string3 = patternScanner.eat(pattern10, "<class-name>");
                    n = 4;
                    continue block19;
                }
                case 4: {
                    String string10 = patternScanner.eat(pattern10, "<filter-name>");
                    this.mCommands.add(new AllocateFilterCommand(string3, string10));
                    n = 5;
                    continue block19;
                }
                case 5: {
                    patternScanner.eat(pattern3, "{");
                    n = 6;
                    continue block19;
                }
                case 6: {
                    KeyValueMap keyValueMap = this.readKeyValueAssignments(patternScanner, pattern2);
                    this.mCommands.add(new InitFilterCommand(keyValueMap));
                    n = 7;
                    continue block19;
                }
                case 7: {
                    patternScanner.eat(pattern2, "}");
                    n = 0;
                    continue block19;
                }
                case 8: {
                    string4 = patternScanner.eat(pattern10, "<source-filter-name>");
                    n = 9;
                    continue block19;
                }
                case 9: {
                    String string11 = patternScanner.eat(pattern7, "[<source-port-name>]");
                    string5 = string11.substring(1, -1 + string11.length());
                    n = 10;
                    continue block19;
                }
                case 10: {
                    patternScanner.eat(pattern8, "=>");
                    n = 11;
                    continue block19;
                }
                case 11: {
                    string6 = patternScanner.eat(pattern10, "<target-filter-name>");
                    n = 12;
                    continue block19;
                }
                case 12: {
                    String string12 = patternScanner.eat(pattern7, "[<target-port-name>]");
                    String string13 = string12.substring(1, -1 + string12.length());
                    this.mCommands.add(new ConnectCommand(string4, string5, string6, string13));
                    n = 16;
                    continue block19;
                }
                case 13: {
                    KeyValueMap keyValueMap = this.readKeyValueAssignments(patternScanner, pattern9);
                    this.mBoundReferences.putAll(keyValueMap);
                    n = 16;
                    continue block19;
                }
                case 14: {
                    this.bindExternal(patternScanner.eat(pattern10, "<external-identifier>"));
                    n = 16;
                    continue block19;
                }
                case 15: {
                    KeyValueMap keyValueMap = this.readKeyValueAssignments(patternScanner, pattern9);
                    this.mSettings.putAll(keyValueMap);
                    n = 16;
                    continue block19;
                }
                case 16: 
            }
            patternScanner.eat(pattern9, ";");
            n = 0;
        }
        if (n != 16 && n != 0) {
            throw new GraphIOException("Unexpected end of input!");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private KeyValueMap readKeyValueAssignments(PatternScanner patternScanner, Pattern pattern) throws GraphIOException {
        Pattern pattern2 = Pattern.compile("=");
        Pattern pattern3 = Pattern.compile(";");
        Pattern pattern4 = Pattern.compile("[a-zA-Z]+[a-zA-Z0-9]*");
        Pattern pattern5 = Pattern.compile("'[^']*'|\\\"[^\\\"]*\\\"");
        Pattern pattern6 = Pattern.compile("[0-9]+");
        Pattern pattern7 = Pattern.compile("[0-9]*\\.[0-9]+f?");
        Pattern pattern8 = Pattern.compile("\\$[a-zA-Z]+[a-zA-Z0-9]");
        Pattern pattern9 = Pattern.compile("true|false");
        int n = 0;
        KeyValueMap keyValueMap = new KeyValueMap();
        String string2 = null;
        block6: while (!(patternScanner.atEnd() || pattern != null && patternScanner.peek(pattern))) {
            switch (n) {
                default: {
                    continue block6;
                }
                case 0: {
                    string2 = patternScanner.eat(pattern4, "<identifier>");
                    n = 1;
                    continue block6;
                }
                case 1: {
                    patternScanner.eat(pattern2, "=");
                    n = 2;
                    continue block6;
                }
                case 2: {
                    String string3 = patternScanner.tryEat(pattern5);
                    if (string3 != null) {
                        keyValueMap.put(string2, string3.substring(1, -1 + string3.length()));
                    } else {
                        String string4 = patternScanner.tryEat(pattern8);
                        if (string4 != null) {
                            String string5 = string4.substring(1, string4.length());
                            Object v = this.mBoundReferences != null ? (Object)this.mBoundReferences.get(string5) : null;
                            if (v == null) {
                                throw new GraphIOException("Unknown object reference to '" + string5 + "'!");
                            }
                            keyValueMap.put(string2, v);
                        } else {
                            String string6 = patternScanner.tryEat(pattern9);
                            if (string6 != null) {
                                keyValueMap.put(string2, Boolean.parseBoolean(string6));
                            } else {
                                String string7 = patternScanner.tryEat(pattern7);
                                if (string7 != null) {
                                    keyValueMap.put(string2, Float.valueOf(Float.parseFloat(string7)));
                                } else {
                                    String string8 = patternScanner.tryEat(pattern6);
                                    if (string8 == null) {
                                        throw new GraphIOException(patternScanner.unexpectedTokenMessage("<value>"));
                                    }
                                    keyValueMap.put(string2, Integer.parseInt(string8));
                                }
                            }
                        }
                    }
                    n = 3;
                    continue block6;
                }
                case 3: 
            }
            patternScanner.eat(pattern3, ";");
            n = 0;
        }
        if (n != 0 && n != 3) {
            throw new GraphIOException("Unexpected end of assignments on line " + patternScanner.lineNo() + "!");
        }
        return keyValueMap;
    }

    private void reset() {
        this.mCurrentGraph = null;
        this.mCurrentFilter = null;
        this.mCommands.clear();
        this.mBoundReferences = new KeyValueMap();
        this.mSettings = new KeyValueMap();
        this.mFactory = new FilterFactory();
    }

    @Override
    public FilterGraph readGraphString(String string2) throws GraphIOException {
        FilterGraph filterGraph = new FilterGraph();
        this.reset();
        this.mCurrentGraph = filterGraph;
        this.parseString(string2);
        this.applySettings();
        this.executeCommands();
        this.reset();
        return filterGraph;
    }

    @Override
    public KeyValueMap readKeyValueAssignments(String string2) throws GraphIOException {
        return this.readKeyValueAssignments(new PatternScanner(string2, Pattern.compile("\\s+")), null);
    }

    private class AddLibraryCommand
    implements Command {
        private String mLibraryName;

        public AddLibraryCommand(String string2) {
            this.mLibraryName = string2;
        }

        @Override
        public void execute(TextGraphReader textGraphReader) {
            textGraphReader.mFactory;
            FilterFactory.addFilterLibrary(this.mLibraryName);
        }
    }

    private class AllocateFilterCommand
    implements Command {
        private String mClassName;
        private String mFilterName;

        public AllocateFilterCommand(String string2, String string3) {
            this.mClassName = string2;
            this.mFilterName = string3;
        }

        @Override
        public void execute(TextGraphReader textGraphReader) throws GraphIOException {
            Filter filter;
            try {
                filter = textGraphReader.mFactory.createFilterByClassName(this.mClassName, this.mFilterName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new GraphIOException(illegalArgumentException.getMessage());
            }
            TextGraphReader.access$102(textGraphReader, filter);
        }
    }

    private static interface Command {
        public void execute(TextGraphReader var1) throws GraphIOException;
    }

    private class ConnectCommand
    implements Command {
        private String mSourceFilter;
        private String mSourcePort;
        private String mTargetFilter;
        private String mTargetName;

        public ConnectCommand(String string2, String string3, String string4, String string5) {
            this.mSourceFilter = string2;
            this.mSourcePort = string3;
            this.mTargetFilter = string4;
            this.mTargetName = string5;
        }

        @Override
        public void execute(TextGraphReader textGraphReader) {
            textGraphReader.mCurrentGraph.connect(this.mSourceFilter, this.mSourcePort, this.mTargetFilter, this.mTargetName);
        }
    }

    private class ImportPackageCommand
    implements Command {
        private String mPackageName;

        public ImportPackageCommand(String string2) {
            this.mPackageName = string2;
        }

        @Override
        public void execute(TextGraphReader textGraphReader) throws GraphIOException {
            try {
                textGraphReader.mFactory.addPackage(this.mPackageName);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new GraphIOException(illegalArgumentException.getMessage());
            }
        }
    }

    private class InitFilterCommand
    implements Command {
        private KeyValueMap mParams;

        public InitFilterCommand(KeyValueMap keyValueMap) {
            this.mParams = keyValueMap;
        }

        @Override
        public void execute(TextGraphReader textGraphReader) throws GraphIOException {
            Filter filter = textGraphReader.mCurrentFilter;
            try {
                filter.initWithValueMap(this.mParams);
            }
            catch (ProtocolException protocolException) {
                throw new GraphIOException(protocolException.getMessage());
            }
            textGraphReader.mCurrentGraph.addFilter(TextGraphReader.this.mCurrentFilter);
        }
    }
}

