/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    public static final int ALL_SAVE_FLAG = 31;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int MATRIX_SAVE_FLAG = 1;
    private static final int MAXMIMUM_BITMAP_SIZE = 32766;
    private Bitmap mBitmap;
    protected int mDensity = 0;
    private DrawFilter mDrawFilter;
    private final CanvasFinalizer mFinalizer;
    private long mNativeCanvasWrapper;
    protected int mScreenDensity = 0;
    private int mSurfaceFormat;

    public Canvas() {
        if (!this.isHardwareAccelerated()) {
            this.mNativeCanvasWrapper = Canvas.initRaster(0L);
            this.mFinalizer = new CanvasFinalizer(this.mNativeCanvasWrapper);
            return;
        }
        this.mFinalizer = null;
    }

    public Canvas(long l) {
        if (l == 0L) {
            throw new IllegalStateException();
        }
        this.mNativeCanvasWrapper = l;
        this.mFinalizer = new CanvasFinalizer(this.mNativeCanvasWrapper);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfCannotDraw(bitmap);
        this.mNativeCanvasWrapper = Canvas.initRaster(bitmap.ni());
        this.mFinalizer = new CanvasFinalizer(this.mNativeCanvasWrapper);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    protected static void checkRange(int n, int n2, int n3) {
        if ((n2 | n3) < 0 || n2 + n3 > n) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static native void finalizer(long var0);

    public static native void freeCaches();

    public static native void freeTextLayoutCaches();

    private static native long initRaster(long var0);

    private static native void nativeDrawBitmapMatrix(long var0, long var2, long var4, long var6);

    private static native void nativeDrawBitmapMesh(long var0, long var2, int var4, int var5, float[] var6, int var7, int[] var8, int var9, long var10);

    private static native void nativeDrawVertices(long var0, int var2, int var3, float[] var4, int var5, float[] var6, int var7, int[] var8, int var9, short[] var10, int var11, int var12, long var13);

    private static native void nativeSetDrawFilter(long var0, long var2);

    private static native boolean native_clipPath(long var0, long var2, int var4);

    private static native boolean native_clipRect(long var0, float var2, float var3, float var4, float var5, int var6);

    private static native boolean native_clipRegion(long var0, long var2, int var4);

    private static native void native_concat(long var0, long var2);

    private static native void native_drawArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, long var9);

    private native void native_drawBitmap(long var1, long var3, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, long var13, int var15, int var16);

    private native void native_drawBitmap(long var1, long var3, float var5, float var6, long var7, int var9, int var10, int var11);

    private static native void native_drawBitmap(long var0, int[] var2, int var3, int var4, float var5, float var6, int var7, int var8, boolean var9, long var10);

    private static native void native_drawCircle(long var0, float var2, float var3, float var4, long var5);

    private static native void native_drawColor(long var0, int var2, int var3);

    private static native void native_drawLine(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void native_drawLines(long var0, float[] var2, int var3, int var4, long var5);

    private static native void native_drawOval(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void native_drawPaint(long var0, long var2);

    private static native void native_drawPath(long var0, long var2, long var4);

    private static native void native_drawPoint(long var0, float var2, float var3, long var4);

    private static native void native_drawPoints(long var0, float[] var2, int var3, int var4, long var5);

    private static native void native_drawRect(long var0, float var2, float var3, float var4, float var5, long var6);

    private static native void native_drawRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, long var8);

    private static native void native_drawText(long var0, String var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    private static native void native_drawText(long var0, char[] var2, int var3, int var4, float var5, float var6, int var7, long var8, long var10);

    private static native void native_drawTextOnPath(long var0, String var2, long var3, float var5, float var6, int var7, long var8, long var10);

    private static native void native_drawTextOnPath(long var0, char[] var2, int var3, int var4, long var5, float var7, float var8, int var9, long var10, long var12);

    private static native void native_drawTextRun(long var0, String var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static native void native_drawTextRun(long var0, char[] var2, int var3, int var4, int var5, int var6, float var7, float var8, boolean var9, long var10, long var12);

    private static native void native_getCTM(long var0, long var2);

    private static native boolean native_getClipBounds(long var0, Rect var2);

    private static native int native_getHeight(long var0);

    private static native int native_getSaveCount(long var0);

    private static native int native_getWidth(long var0);

    private static native boolean native_isOpaque(long var0);

    private static native boolean native_quickReject(long var0, float var2, float var3, float var4, float var5);

    private static native boolean native_quickReject(long var0, long var2);

    private static native void native_restore(long var0);

    private static native void native_restoreToCount(long var0, int var2);

    private static native void native_rotate(long var0, float var2);

    private static native int native_save(long var0, int var2);

    private static native int native_saveLayer(long var0, float var2, float var3, float var4, float var5, long var6, int var8);

    private static native int native_saveLayerAlpha(long var0, float var2, float var3, float var4, float var5, int var6, int var7);

    private static native void native_scale(long var0, float var2, float var3);

    private static native void native_setBitmap(long var0, long var2, boolean var4);

    private static native void native_setMatrix(long var0, long var2);

    private static native void native_skew(long var0, float var2, float var3);

    private static native void native_translate(long var0, float var2, float var3);

    private void setNativeBitmap(long l) {
        Canvas.native_setBitmap(this.mNativeCanvasWrapper, l, false);
    }

    protected static void throwIfCannotDraw(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
        if (!bitmap.isPremultiplied() && bitmap.getConfig() == Bitmap.Config.ARGB_8888 && bitmap.hasAlpha()) {
            throw new RuntimeException("Canvas: trying to use a non-premultiplied bitmap " + bitmap);
        }
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvasWrapper, path.ni(), op.nativeInt);
    }

    public boolean clipRect(float f, float f2, float f3, float f4) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, f, f2, f3, f4, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(float f, float f2, float f3, float f4, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, f, f2, f3, f4, op.nativeInt);
    }

    public boolean clipRect(int n, int n2, int n3, int n4) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, n, n2, n3, n4, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(RectF rectF) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rectF.left, rectF.top, rectF.right, rectF.bottom, Region.Op.INTERSECT.nativeInt);
    }

    public boolean clipRect(RectF rectF, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvasWrapper, rectF.left, rectF.top, rectF.right, rectF.bottom, op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvasWrapper, region.ni(), op.nativeInt);
    }

    public void concat(Matrix matrix) {
        if (matrix != null) {
            Canvas.native_concat(this.mNativeCanvasWrapper, matrix.native_instance);
        }
    }

    public void drawARGB(int n, int n2, int n3, int n4) {
        this.drawColor(Color.argb(n, n2, n3, n4));
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, Paint paint) {
        Canvas.native_drawArc(this.mNativeCanvasWrapper, f, f2, f3, f4, f5, f6, bl, paint.mNativePaint);
    }

    public void drawArc(RectF rectF, float f, float f2, boolean bl, Paint paint) {
        this.drawArc(rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2, bl, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, float f, float f2, Paint paint) {
        Canvas.throwIfCannotDraw(bitmap);
        long l = this.mNativeCanvasWrapper;
        long l2 = bitmap.ni();
        long l3 = paint != null ? paint.mNativePaint : 0L;
        this.native_drawBitmap(l, l2, f, f2, l3, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        long l = this.mNativeCanvasWrapper;
        long l2 = bitmap.ni();
        long l3 = matrix.ni();
        long l4 = paint != null ? paint.mNativePaint : 0L;
        Canvas.nativeDrawBitmapMatrix(l, l2, l3, l4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, Rect rect, Rect rect2, Paint paint) {
        int n;
        int n2;
        int n3;
        int n4;
        if (rect2 == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        if (rect == null) {
            n4 = 0;
            n3 = 0;
            n2 = bitmap.getWidth();
            n = bitmap.getHeight();
        } else {
            n3 = rect.left;
            n2 = rect.right;
            n4 = rect.top;
            n = rect.bottom;
        }
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap.ni(), n3, n4, n2, n, rect2.left, rect2.top, rect2.right, rect2.bottom, l, this.mScreenDensity, bitmap.mDensity);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmap(Bitmap bitmap, Rect rect, RectF rectF, Paint paint) {
        float f;
        float f2;
        float f3;
        float f4;
        if (rectF == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfCannotDraw(bitmap);
        long l = paint == null ? 0L : paint.mNativePaint;
        if (rect == null) {
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = bitmap.getWidth();
            f = bitmap.getHeight();
        } else {
            f3 = rect.left;
            f2 = rect.right;
            f4 = rect.top;
            f = rect.bottom;
        }
        this.native_drawBitmap(this.mNativeCanvasWrapper, bitmap.ni(), f3, f4, f2, f, rectF.left, rectF.top, rectF.right, rectF.bottom, l, this.mScreenDensity, bitmap.mDensity);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, float f, float f2, int n3, int n4, boolean bl, Paint paint) {
        if (n3 < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(n2) < n3) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n5 = n + n2 * (n4 - 1);
        int n6 = nArray.length;
        if (n < 0 || n + n3 > n6 || n5 < 0 || n5 + n3 > n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        long l = this.mNativeCanvasWrapper;
        long l2 = paint != null ? paint.mNativePaint : 0L;
        Canvas.native_drawBitmap(l, nArray, n, n2, f, f2, n3, n4, bl, l2);
    }

    @Deprecated
    public void drawBitmap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Paint paint) {
        this.drawBitmap(nArray, n, n2, (float)n3, (float)n4, n5, n6, bl, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBitmapMesh(Bitmap bitmap, int n, int n2, float[] fArray, int n3, int[] nArray, int n4, Paint paint) {
        if ((n4 | (n3 | (n | n2))) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n == 0 || n2 == 0) {
            return;
        }
        int n5 = (n + 1) * (n2 + 1);
        Canvas.checkRange(fArray.length, n3, n5 * 2);
        if (nArray != null) {
            Canvas.checkRange(nArray.length, n4, n5);
        }
        long l = this.mNativeCanvasWrapper;
        long l2 = bitmap.ni();
        long l3 = paint != null ? paint.mNativePaint : 0L;
        Canvas.nativeDrawBitmapMesh(l, l2, n, n2, fArray, n3, nArray, n4, l3);
    }

    public void drawCircle(float f, float f2, float f3, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvasWrapper, f, f2, f3, paint.mNativePaint);
    }

    public void drawColor(int n) {
        Canvas.native_drawColor(this.mNativeCanvasWrapper, n, PorterDuff.Mode.SRC_OVER.nativeInt);
    }

    public void drawColor(int n, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvasWrapper, n, mode.nativeInt);
    }

    public void drawLine(float f, float f2, float f3, float f4, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvasWrapper, f, f2, f3, f4, paint.mNativePaint);
    }

    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        Canvas.native_drawLines(this.mNativeCanvasWrapper, fArray, n, n2, paint.mNativePaint);
    }

    public void drawLines(float[] fArray, Paint paint) {
        this.drawLines(fArray, 0, fArray.length, paint);
    }

    public void drawOval(float f, float f2, float f3, float f4, Paint paint) {
        Canvas.native_drawOval(this.mNativeCanvasWrapper, f, f2, f3, f4, paint.mNativePaint);
    }

    public void drawOval(RectF rectF, Paint paint) {
        if (rectF == null) {
            throw new NullPointerException();
        }
        this.drawOval(rectF.left, rectF.top, rectF.right, rectF.bottom, paint);
    }

    public void drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvasWrapper, paint.mNativePaint);
    }

    public void drawPatch(NinePatch ninePatch, Rect rect, Paint paint) {
        ninePatch.drawSoftware(this, rect, paint);
    }

    public void drawPatch(NinePatch ninePatch, RectF rectF, Paint paint) {
        ninePatch.drawSoftware(this, rectF, paint);
    }

    public void drawPath(Path path, Paint paint) {
        Canvas.native_drawPath(this.mNativeCanvasWrapper, path.ni(), paint.mNativePaint);
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        int n = this.save();
        picture.draw(this);
        this.restoreToCount(n);
    }

    public void drawPicture(Picture picture, Rect rect) {
        this.save();
        this.translate(rect.left, rect.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)rect.width() / (float)picture.getWidth(), (float)rect.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, RectF rectF) {
        this.save();
        this.translate(rectF.left, rectF.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(rectF.width() / (float)picture.getWidth(), rectF.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPoint(float f, float f2, Paint paint) {
        Canvas.native_drawPoint(this.mNativeCanvasWrapper, f, f2, paint.mNativePaint);
    }

    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        Canvas.native_drawPoints(this.mNativeCanvasWrapper, fArray, n, n2, paint.mNativePaint);
    }

    public void drawPoints(float[] fArray, Paint paint) {
        this.drawPoints(fArray, 0, fArray.length, paint);
    }

    @Deprecated
    public void drawPosText(String string2, float[] fArray, Paint paint) {
        paint.set(paint);
        this.drawPosText(string2.toCharArray(), 0, string2.length(), fArray, paint);
    }

    @Deprecated
    public void drawPosText(char[] cArray, int n, int n2, float[] fArray, Paint paint) {
        if (n < 0 || n + n2 > cArray.length || n2 * 2 > fArray.length) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        for (int i = 0; i < n2; ++i) {
            this.drawText(cArray, n + i, 1, fArray[i * 2], fArray[1 + i * 2], paint);
        }
    }

    public void drawRGB(int n, int n2, int n3) {
        this.drawColor(Color.rgb(n, n2, n3));
    }

    public void drawRect(float f, float f2, float f3, float f4, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvasWrapper, f, f2, f3, f4, paint.mNativePaint);
    }

    public void drawRect(Rect rect, Paint paint) {
        this.drawRect(rect.left, rect.top, rect.right, rect.bottom, paint);
    }

    public void drawRect(RectF rectF, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvasWrapper, rectF.left, rectF.top, rectF.right, rectF.bottom, paint.mNativePaint);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Paint paint) {
        Canvas.native_drawRoundRect(this.mNativeCanvasWrapper, f, f2, f3, f4, f5, f6, paint.mNativePaint);
    }

    public void drawRoundRect(RectF rectF, float f, float f2, Paint paint) {
        this.drawRoundRect(rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2, paint);
    }

    public void drawText(CharSequence charSequence, int n, int n2, float f, float f2, Paint paint) {
        paint.set(paint);
        if (charSequence instanceof String || charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvasWrapper, charSequence.toString(), n, n2, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
            return;
        }
        if (charSequence instanceof GraphicsOperations) {
            ((GraphicsOperations)charSequence).drawText(this, n, n2, f, f2, paint);
            return;
        }
        char[] cArray = TemporaryBuffer.obtain(n2 - n);
        TextUtils.getChars(charSequence, n, n2, cArray, 0);
        Canvas.native_drawText(this.mNativeCanvasWrapper, cArray, 0, n2 - n, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        TemporaryBuffer.recycle(cArray);
    }

    public void drawText(String string2, float f, float f2, Paint paint) {
        paint.set(paint);
        Canvas.native_drawText(this.mNativeCanvasWrapper, string2, 0, string2.length(), f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawText(String string2, int n, int n2, float f, float f2, Paint paint) {
        if ((n | n2 | n2 - n | string2.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        Canvas.native_drawText(this.mNativeCanvasWrapper, string2, n, n2, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawText(char[] cArray, int n, int n2, float f, float f2, Paint paint) {
        if ((n | n2 | n + n2 | cArray.length - n - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        Canvas.native_drawText(this.mNativeCanvasWrapper, cArray, n, n2, f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawTextOnPath(String string2, Path path, float f, float f2, Paint paint) {
        paint.set(paint);
        if (string2.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvasWrapper, string2, path.ni(), f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
        }
    }

    public void drawTextOnPath(char[] cArray, int n, int n2, Path path, float f, float f2, Paint paint) {
        if (n < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        paint.set(paint);
        Canvas.native_drawTextOnPath(this.mNativeCanvasWrapper, cArray, n, n2, path.ni(), f, f2, paint.mBidiFlags, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawTextRun(CharSequence charSequence, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        if (charSequence == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((n | n2 | n2 - n | charSequence.length() - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        if (charSequence instanceof String || charSequence instanceof SpannedString || charSequence instanceof SpannableString) {
            Canvas.native_drawTextRun(this.mNativeCanvasWrapper, charSequence.toString(), n, n2, n3, n4, f, f2, bl, paint.mNativePaint, paint.mNativeTypeface);
            return;
        }
        if (charSequence instanceof GraphicsOperations) {
            ((GraphicsOperations)charSequence).drawTextRun(this, n, n2, n3, n4, f, f2, bl, paint);
            return;
        }
        int n5 = n4 - n3;
        int n6 = n2 - n;
        char[] cArray = TemporaryBuffer.obtain(n5);
        TextUtils.getChars(charSequence, n3, n4, cArray, 0);
        Canvas.native_drawTextRun(this.mNativeCanvasWrapper, cArray, n - n3, n6, 0, n5, f, f2, bl, paint.mNativePaint, paint.mNativeTypeface);
        TemporaryBuffer.recycle(cArray);
    }

    public void drawTextRun(char[] cArray, int n, int n2, int n3, int n4, float f, float f2, boolean bl, Paint paint) {
        if (cArray == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((n | n2 | cArray.length - n - n2) < 0) {
            throw new IndexOutOfBoundsException();
        }
        paint.set(paint);
        Canvas.native_drawTextRun(this.mNativeCanvasWrapper, cArray, n, n2, n3, n4, f, f2, bl, paint.mNativePaint, paint.mNativeTypeface);
    }

    public void drawVertices(VertexMode vertexMode, int n, float[] fArray, int n2, float[] fArray2, int n3, int[] nArray, int n4, short[] sArray, int n5, int n6, Paint paint) {
        Canvas.checkRange(fArray.length, n2, n);
        if (fArray2 != null) {
            Canvas.checkRange(fArray2.length, n3, n);
        }
        if (nArray != null) {
            Canvas.checkRange(nArray.length, n4, n / 2);
        }
        if (sArray != null) {
            Canvas.checkRange(sArray.length, n5, n6);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvasWrapper, vertexMode.nativeInt, n, fArray, n2, fArray2, n3, nArray, n4, sArray, n5, n6, paint.mNativePaint);
    }

    public final Rect getClipBounds() {
        Rect rect = new Rect();
        this.getClipBounds(rect);
        return rect;
    }

    public boolean getClipBounds(Rect rect) {
        return Canvas.native_getClipBounds(this.mNativeCanvasWrapper, rect);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    @Deprecated
    protected GL getGL() {
        return null;
    }

    public int getHeight() {
        return Canvas.native_getHeight(this.mNativeCanvasWrapper);
    }

    @Deprecated
    public final Matrix getMatrix() {
        Matrix matrix = new Matrix();
        this.getMatrix(matrix);
        return matrix;
    }

    @Deprecated
    public void getMatrix(Matrix matrix) {
        Canvas.native_getCTM(this.mNativeCanvasWrapper, matrix.native_instance);
    }

    public int getMaximumBitmapHeight() {
        return 32766;
    }

    public int getMaximumBitmapWidth() {
        return 32766;
    }

    public long getNativeCanvasWrapper() {
        return this.mNativeCanvasWrapper;
    }

    public int getSaveCount() {
        return Canvas.native_getSaveCount(this.mNativeCanvasWrapper);
    }

    public int getWidth() {
        return Canvas.native_getWidth(this.mNativeCanvasWrapper);
    }

    public void insertInorderBarrier() {
    }

    public void insertReorderBarrier() {
    }

    public boolean isHardwareAccelerated() {
        return false;
    }

    public boolean isOpaque() {
        return Canvas.native_isOpaque(this.mNativeCanvasWrapper);
    }

    public boolean isRecordingFor(Object object) {
        return false;
    }

    public boolean quickReject(float f, float f2, float f3, float f4, EdgeType edgeType) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, f, f2, f3, f4);
    }

    public boolean quickReject(Path path, EdgeType edgeType) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, path.ni());
    }

    public boolean quickReject(RectF rectF, EdgeType edgeType) {
        return Canvas.native_quickReject(this.mNativeCanvasWrapper, rectF.left, rectF.top, rectF.right, rectF.bottom);
    }

    public void release() {
        this.mFinalizer.dispose();
    }

    public void restore() {
        Canvas.native_restore(this.mNativeCanvasWrapper);
    }

    public void restoreToCount(int n) {
        Canvas.native_restoreToCount(this.mNativeCanvasWrapper, n);
    }

    public void rotate(float f) {
        Canvas.native_rotate(this.mNativeCanvasWrapper, f);
    }

    public final void rotate(float f, float f2, float f3) {
        this.translate(f2, f3);
        this.rotate(f);
        this.translate(-f2, -f3);
    }

    public int save() {
        return Canvas.native_save(this.mNativeCanvasWrapper, 3);
    }

    public int save(int n) {
        return Canvas.native_save(this.mNativeCanvasWrapper, n);
    }

    public int saveLayer(float f, float f2, float f3, float f4, Paint paint) {
        return this.saveLayer(f, f2, f3, f4, paint, 31);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int saveLayer(float f, float f2, float f3, float f4, Paint paint, int n) {
        long l;
        long l2 = this.mNativeCanvasWrapper;
        if (paint != null) {
            l = paint.mNativePaint;
            return Canvas.native_saveLayer(l2, f, f2, f3, f4, l, n);
        }
        l = 0L;
        return Canvas.native_saveLayer(l2, f, f2, f3, f4, l, n);
    }

    public int saveLayer(RectF rectF, Paint paint) {
        return this.saveLayer(rectF, paint, 31);
    }

    public int saveLayer(RectF rectF, Paint paint, int n) {
        if (rectF == null) {
            rectF = new RectF(this.getClipBounds());
        }
        return this.saveLayer(rectF.left, rectF.top, rectF.right, rectF.bottom, paint, n);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n) {
        return this.saveLayerAlpha(f, f2, f3, f4, n, 31);
    }

    public int saveLayerAlpha(float f, float f2, float f3, float f4, int n, int n2) {
        int n3 = Math.min(255, Math.max(0, n));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvasWrapper, f, f2, f3, f4, n3, n2);
    }

    public int saveLayerAlpha(RectF rectF, int n) {
        return this.saveLayerAlpha(rectF, n, 31);
    }

    public int saveLayerAlpha(RectF rectF, int n, int n2) {
        if (rectF == null) {
            rectF = new RectF(this.getClipBounds());
        }
        return this.saveLayerAlpha(rectF.left, rectF.top, rectF.right, rectF.bottom, n, n2);
    }

    public void scale(float f, float f2) {
        Canvas.native_scale(this.mNativeCanvasWrapper, f, f2);
    }

    public final void scale(float f, float f2, float f3, float f4) {
        this.translate(f3, f4);
        this.scale(f, f2);
        this.translate(-f3, -f4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBitmap(Bitmap bitmap) {
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a HW accelerated canvas");
        }
        if (bitmap == null) {
            Canvas.native_setBitmap(this.mNativeCanvasWrapper, 0L, false);
            this.mDensity = 0;
        } else {
            if (!bitmap.isMutable()) {
                throw new IllegalStateException();
            }
            Canvas.throwIfCannotDraw(bitmap);
            Canvas.native_setBitmap(this.mNativeCanvasWrapper, bitmap.ni(), true);
            this.mDensity = bitmap.mDensity;
        }
        this.mBitmap = bitmap;
    }

    public void setDensity(int n) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(n);
        }
        this.mDensity = n;
    }

    public void setDrawFilter(DrawFilter drawFilter) {
        long l = 0L;
        if (drawFilter != null) {
            l = drawFilter.mNativeInt;
        }
        this.mDrawFilter = drawFilter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvasWrapper, l);
    }

    public void setHighContrastText(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMatrix(Matrix matrix) {
        long l = this.mNativeCanvasWrapper;
        long l2 = matrix == null ? 0L : matrix.native_instance;
        Canvas.native_setMatrix(l, l2);
    }

    public void setScreenDensity(int n) {
        this.mScreenDensity = n;
    }

    public void setViewport(int n, int n2) {
    }

    public void skew(float f, float f2) {
        Canvas.native_skew(this.mNativeCanvasWrapper, f, f2);
    }

    public void translate(float f, float f2) {
        Canvas.native_translate(this.mNativeCanvasWrapper, f, f2);
    }

    private static final class CanvasFinalizer {
        private long mNativeCanvasWrapper;

        public CanvasFinalizer(long l) {
            this.mNativeCanvasWrapper = l;
        }

        public void dispose() {
            if (this.mNativeCanvasWrapper != 0L) {
                Canvas.finalizer(this.mNativeCanvasWrapper);
                this.mNativeCanvasWrapper = 0L;
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.dispose();
                return;
            }
            finally {
                super.finalize();
            }
        }
    }

    public static final class EdgeType
    extends Enum<EdgeType> {
        private static final /* synthetic */ EdgeType[] $VALUES;
        public static final /* enum */ EdgeType AA;
        public static final /* enum */ EdgeType BW;
        public final int nativeInt;

        static {
            BW = new EdgeType(0);
            AA = new EdgeType(1);
            EdgeType[] edgeTypeArray = new EdgeType[]{BW, AA};
            $VALUES = edgeTypeArray;
        }

        private EdgeType(int n2) {
            this.nativeInt = n2;
        }

        public static EdgeType valueOf(String string2) {
            return Enum.valueOf(EdgeType.class, string2);
        }

        public static EdgeType[] values() {
            return (EdgeType[])$VALUES.clone();
        }
    }

    public static final class VertexMode
    extends Enum<VertexMode> {
        private static final /* synthetic */ VertexMode[] $VALUES;
        public static final /* enum */ VertexMode TRIANGLES = new VertexMode(0);
        public static final /* enum */ VertexMode TRIANGLE_FAN;
        public static final /* enum */ VertexMode TRIANGLE_STRIP;
        public final int nativeInt;

        static {
            TRIANGLE_STRIP = new VertexMode(1);
            TRIANGLE_FAN = new VertexMode(2);
            VertexMode[] vertexModeArray = new VertexMode[]{TRIANGLES, TRIANGLE_STRIP, TRIANGLE_FAN};
            $VALUES = vertexModeArray;
        }

        private VertexMode(int n2) {
            this.nativeInt = n2;
        }

        public static VertexMode valueOf(String string2) {
            return Enum.valueOf(VertexMode.class, string2);
        }

        public static VertexMode[] values() {
            return (VertexMode[])$VALUES.clone();
        }
    }
}

