/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Path;
import android.graphics.Rect;

public final class Outline {
    public float mAlpha;
    public Path mPath;
    public float mRadius;
    public Rect mRect;

    public Outline() {
    }

    public Outline(Outline outline) {
        this.set(outline);
    }

    public boolean canClip() {
        return !this.isEmpty() && this.mRect != null;
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public boolean isEmpty() {
        return this.mRect == null && this.mPath == null;
    }

    public void set(Outline outline) {
        if (outline.mPath != null) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            this.mPath.set(outline.mPath);
            this.mRect = null;
        }
        if (outline.mRect != null) {
            if (this.mRect == null) {
                this.mRect = new Rect();
            }
            this.mRect.set(outline.mRect);
        }
        this.mRadius = outline.mRadius;
        this.mAlpha = outline.mAlpha;
    }

    public void setAlpha(float f) {
        this.mAlpha = f;
    }

    public void setConvexPath(Path path) {
        if (path.isEmpty()) {
            this.setEmpty();
            return;
        }
        if (!path.isConvex()) {
            throw new IllegalArgumentException("path must be convex");
        }
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        this.mPath.set(path);
        this.mRect = null;
        this.mRadius = -1.0f;
    }

    public void setEmpty() {
        this.mPath = null;
        this.mRect = null;
        this.mRadius = 0.0f;
    }

    public void setOval(int n, int n2, int n3, int n4) {
        if (n >= n3 || n2 >= n4) {
            this.setEmpty();
            return;
        }
        if (n4 - n2 == n3 - n) {
            this.setRoundRect(n, n2, n3, n4, (float)(n4 - n2) / 2.0f);
            return;
        }
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        this.mPath.reset();
        this.mPath.addOval(n, n2, n3, n4, Path.Direction.CW);
        this.mRect = null;
    }

    public void setOval(Rect rect) {
        this.setOval(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setRect(int n, int n2, int n3, int n4) {
        this.setRoundRect(n, n2, n3, n4, 0.0f);
    }

    public void setRect(Rect rect) {
        this.setRect(rect.left, rect.top, rect.right, rect.bottom);
    }

    public void setRoundRect(int n, int n2, int n3, int n4, float f) {
        if (n >= n3 || n2 >= n4) {
            this.setEmpty();
            return;
        }
        if (this.mRect == null) {
            this.mRect = new Rect();
        }
        this.mRect.set(n, n2, n3, n4);
        this.mRadius = f;
        this.mPath = null;
    }

    public void setRoundRect(Rect rect, float f) {
        this.setRoundRect(rect.left, rect.top, rect.right, rect.bottom, f);
    }
}

