/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.RippleDrawable;
import android.util.MathUtils;
import android.view.HardwareCanvas;
import android.view.RenderNodeAnimator;
import android.view.animation.LinearInterpolator;
import java.util.ArrayList;

class RippleBackground {
    private static final float GLOBAL_SPEED = 1.0f;
    private static final TimeInterpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final float WAVE_OPACITY_DECAY_VELOCITY = 3.0f;
    private static final float WAVE_OUTER_OPACITY_ENTER_VELOCITY = 10.0f;
    private static final float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MAX = 4.5f;
    private static final float WAVE_OUTER_OPACITY_EXIT_VELOCITY_MIN = 1.5f;
    private static final float WAVE_OUTER_SIZE_INFLUENCE_MAX = 200.0f;
    private static final float WAVE_OUTER_SIZE_INFLUENCE_MIN = 40.0f;
    private ObjectAnimator mAnimOuterOpacity;
    private final AnimatorListenerAdapter mAnimationListener;
    private final Rect mBounds;
    private boolean mCanUseHardware;
    private int mColorAlpha;
    private int mColorOpaque;
    private float mDensity;
    private boolean mHardwareAnimating;
    private boolean mHasMaxRadius;
    private float mOuterOpacity = 0.0f;
    private float mOuterRadius;
    private float mOuterX;
    private float mOuterY;
    private final RippleDrawable mOwner;
    private final ArrayList<RenderNodeAnimator> mPendingAnimations;
    private CanvasProperty<Paint> mPropOuterPaint;
    private CanvasProperty<Float> mPropOuterRadius;
    private CanvasProperty<Float> mPropOuterX;
    private CanvasProperty<Float> mPropOuterY;
    private final ArrayList<RenderNodeAnimator> mRunningAnimations = new ArrayList();
    private Paint mTempPaint;

    public RippleBackground(RippleDrawable rippleDrawable, Rect rect) {
        this.mPendingAnimations = new ArrayList();
        this.mAnimationListener = new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animator2) {
                RippleBackground.access$302(RippleBackground.this, false);
            }
        };
        this.mOwner = rippleDrawable;
        this.mBounds = rect;
    }

    static /* synthetic */ ObjectAnimator access$202(RippleBackground rippleBackground, ObjectAnimator objectAnimator) {
        rippleBackground.mAnimOuterOpacity = objectAnimator;
        return objectAnimator;
    }

    static /* synthetic */ boolean access$302(RippleBackground rippleBackground, boolean bl) {
        rippleBackground.mHardwareAnimating = bl;
        return bl;
    }

    private void cancelHardwareAnimations(boolean bl) {
        ArrayList<RenderNodeAnimator> arrayList = this.mRunningAnimations;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).cancel();
        }
        arrayList.clear();
        if (bl && !this.mPendingAnimations.isEmpty()) {
            this.mPendingAnimations.clear();
        }
        this.mHardwareAnimating = false;
    }

    private void cancelSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.cancel();
            this.mAnimOuterOpacity = null;
        }
    }

    private boolean drawHardware(HardwareCanvas hardwareCanvas) {
        ArrayList<RenderNodeAnimator> arrayList = this.mPendingAnimations;
        int n = arrayList.size();
        if (n > 0) {
            this.cancelHardwareAnimations(false);
            this.mHardwareAnimating = true;
            for (int i = 0; i < n; ++i) {
                arrayList.get(i).setTarget(hardwareCanvas);
                arrayList.get(i).start();
            }
            this.mRunningAnimations.addAll(arrayList);
            arrayList.clear();
        }
        hardwareCanvas.drawCircle(this.mPropOuterX, this.mPropOuterY, this.mPropOuterRadius, this.mPropOuterPaint);
        return true;
    }

    private boolean drawSoftware(Canvas canvas, Paint paint) {
        paint.setColor(this.mColorOpaque);
        int n = (int)(0.5f + (float)this.mColorAlpha * this.mOuterOpacity);
        boolean bl = false;
        if (n > 0) {
            float f = this.mOuterRadius - 0.0f;
            float f2 = f == 0.0f ? 0 : (f > 0.0f ? 1 : -1);
            bl = false;
            if (f2 > 0) {
                paint.setAlpha(n);
                paint.setStyle(Paint.Style.FILL);
                canvas.drawCircle(this.mOuterX, this.mOuterY, this.mOuterRadius, paint);
                bl = true;
            }
        }
        return bl;
    }

    private void endSoftwareAnimations() {
        if (this.mAnimOuterOpacity != null) {
            this.mAnimOuterOpacity.end();
            this.mAnimOuterOpacity = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void exitHardware(int n, int n2, int n3) {
        RenderNodeAnimator renderNodeAnimator;
        this.mPendingAnimations.clear();
        Paint paint = this.getTempPaint();
        paint.setAntiAlias(true);
        paint.setColor(this.mColorOpaque);
        paint.setAlpha((int)(0.5f + (float)this.mColorAlpha * this.mOuterOpacity));
        paint.setStyle(Paint.Style.FILL);
        this.mPropOuterPaint = CanvasProperty.createPaint(paint);
        this.mPropOuterRadius = CanvasProperty.createFloat(this.mOuterRadius);
        this.mPropOuterX = CanvasProperty.createFloat(this.mOuterX);
        this.mPropOuterY = CanvasProperty.createFloat(this.mOuterY);
        if (n2 > 0) {
            renderNodeAnimator = new RenderNodeAnimator(this.mPropOuterPaint, 1, n3);
            renderNodeAnimator.setDuration(n2);
            renderNodeAnimator.setInterpolator(LINEAR_INTERPOLATOR);
            int n4 = n - n2;
            if (n4 > 0) {
                RenderNodeAnimator renderNodeAnimator2 = new RenderNodeAnimator(this.mPropOuterPaint, 1, 0.0f);
                renderNodeAnimator2.setDuration(n4);
                renderNodeAnimator2.setInterpolator(LINEAR_INTERPOLATOR);
                renderNodeAnimator2.setStartDelay(n2);
                renderNodeAnimator2.setStartValue(n3);
                renderNodeAnimator2.addListener(this.mAnimationListener);
                this.mPendingAnimations.add(renderNodeAnimator2);
            } else {
                renderNodeAnimator.addListener(this.mAnimationListener);
            }
        } else {
            renderNodeAnimator = new RenderNodeAnimator(this.mPropOuterPaint, 1, 0.0f);
            renderNodeAnimator.setInterpolator(LINEAR_INTERPOLATOR);
            renderNodeAnimator.setDuration(n);
            renderNodeAnimator.addListener(this.mAnimationListener);
        }
        this.mPendingAnimations.add(renderNodeAnimator);
        this.mHardwareAnimating = true;
        this.mOuterOpacity = 0.0f;
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void exitSoftware(int n, int n2, int n3) {
        ObjectAnimator objectAnimator;
        if (n2 > 0) {
            float[] fArray = new float[]{(float)n3 / 255.0f};
            objectAnimator = ObjectAnimator.ofFloat((Object)this, "outerOpacity", fArray);
            objectAnimator.setAutoCancel(true);
            objectAnimator.setDuration(n2);
            objectAnimator.setInterpolator(LINEAR_INTERPOLATOR);
            final int n4 = n - n2;
            if (n4 > 0) {
                objectAnimator.addListener(new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationCancel(Animator animator2) {
                        animator2.removeListener(this);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)RippleBackground.this, "outerOpacity", 0.0f);
                        objectAnimator.setAutoCancel(true);
                        objectAnimator.setDuration(n4);
                        objectAnimator.setInterpolator(LINEAR_INTERPOLATOR);
                        objectAnimator.addListener(RippleBackground.this.mAnimationListener);
                        RippleBackground.access$202(RippleBackground.this, objectAnimator);
                        objectAnimator.start();
                    }
                });
            } else {
                objectAnimator.addListener(this.mAnimationListener);
            }
        } else {
            objectAnimator = ObjectAnimator.ofFloat((Object)this, "outerOpacity", 0.0f);
            objectAnimator.setAutoCancel(true);
            objectAnimator.setDuration(n);
            objectAnimator.addListener(this.mAnimationListener);
        }
        this.mAnimOuterOpacity = objectAnimator;
        objectAnimator.start();
    }

    private Paint getTempPaint() {
        if (this.mTempPaint == null) {
            this.mTempPaint = new Paint();
        }
        return this.mTempPaint;
    }

    private void invalidateSelf() {
        this.mOwner.invalidateSelf();
    }

    public void cancel() {
        this.cancelSoftwareAnimations();
        this.cancelHardwareAnimations(true);
    }

    public boolean draw(Canvas canvas, Paint paint) {
        boolean bl = canvas.isHardwareAccelerated();
        if (this.mCanUseHardware != bl && this.mCanUseHardware) {
            this.cancelHardwareAnimations(true);
        }
        this.mCanUseHardware = bl;
        if (bl && this.mHardwareAnimating) {
            return this.drawHardware((HardwareCanvas)canvas);
        }
        return this.drawSoftware(canvas, paint);
    }

    public void enter() {
        this.cancel();
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this, "outerOpacity", 0.0f, 1.0f);
        objectAnimator.setAutoCancel(true);
        objectAnimator.setDuration(100L);
        objectAnimator.setInterpolator(LINEAR_INTERPOLATOR);
        this.mAnimOuterOpacity = objectAnimator;
        objectAnimator.start();
    }

    public void exit() {
        this.cancel();
        float f = MathUtils.constrain((this.mOuterRadius - 40.0f * this.mDensity) / (200.0f * this.mDensity), 0.0f, 1.0f);
        float f2 = MathUtils.lerp(1.5f, 4.5f, f);
        int n = Math.max(0, (int)(0.5f + 1000.0f * (1.0f - this.mOuterOpacity) / (3.0f + f2)));
        int n2 = (int)(0.5f + (float)this.mColorAlpha * (this.mOuterOpacity + f * (f2 * (float)n) / 1000.0f));
        if (this.mCanUseHardware) {
            this.exitHardware(333, n, n2);
            return;
        }
        this.exitSoftware(333, n, n2);
    }

    public void getBounds(Rect rect) {
        int n = (int)this.mOuterX;
        int n2 = (int)this.mOuterY;
        int n3 = 1 + (int)this.mOuterRadius;
        rect.set(n - n3, n2 - n3, n + n3, n2 + n3);
    }

    public float getOuterOpacity() {
        return this.mOuterOpacity;
    }

    public boolean isHardwareAnimating() {
        return this.mHardwareAnimating;
    }

    public void jump() {
        this.endSoftwareAnimations();
        this.cancelHardwareAnimations(true);
    }

    public void onHotspotBoundsChanged() {
        if (!this.mHasMaxRadius) {
            float f = (float)this.mBounds.width() / 2.0f;
            float f2 = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(f * f + f2 * f2);
        }
    }

    public void setOuterOpacity(float f) {
        this.mOuterOpacity = f;
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setup(int n, int n2, float f) {
        this.mColorOpaque = 0xFF000000 | n2;
        this.mColorAlpha = Color.alpha(n2) / 2;
        if (n != -1) {
            this.mHasMaxRadius = true;
            this.mOuterRadius = n;
        } else {
            float f2 = (float)this.mBounds.width() / 2.0f;
            float f3 = (float)this.mBounds.height() / 2.0f;
            this.mOuterRadius = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        this.mOuterX = 0.0f;
        this.mOuterY = 0.0f;
        this.mDensity = f;
    }

    public boolean shouldDraw() {
        int n = (int)(0.5f + (float)this.mColorAlpha * this.mOuterOpacity);
        return this.mCanUseHardware && this.mHardwareAnimating || n > 0 && this.mOuterRadius > 0.0f;
    }
}

