/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraDeviceCallbacks
extends IInterface {
    public void onCaptureStarted(CaptureResultExtras var1, long var2) throws RemoteException;

    public void onDeviceError(int var1, CaptureResultExtras var2) throws RemoteException;

    public void onDeviceIdle() throws RemoteException;

    public void onResultReceived(CameraMetadataNative var1, CaptureResultExtras var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraDeviceCallbacks {
        private static final String DESCRIPTOR = "android.hardware.camera2.ICameraDeviceCallbacks";
        static final int TRANSACTION_onCaptureStarted = 3;
        static final int TRANSACTION_onDeviceError = 1;
        static final int TRANSACTION_onDeviceIdle = 2;
        static final int TRANSACTION_onResultReceived = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraDeviceCallbacks asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ICameraDeviceCallbacks) {
                return (ICameraDeviceCallbacks)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n3 = parcel.readInt();
                    CaptureResultExtras captureResultExtras = parcel.readInt() != 0 ? CaptureResultExtras.CREATOR.createFromParcel(parcel) : null;
                    this.onDeviceError(n3, captureResultExtras);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.onDeviceIdle();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    CaptureResultExtras captureResultExtras = parcel.readInt() != 0 ? CaptureResultExtras.CREATOR.createFromParcel(parcel) : null;
                    this.onCaptureStarted(captureResultExtras, parcel.readLong());
                    return true;
                }
                case 4: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            CameraMetadataNative cameraMetadataNative = parcel.readInt() != 0 ? CameraMetadataNative.CREATOR.createFromParcel(parcel) : null;
            CaptureResultExtras captureResultExtras = parcel.readInt() != 0 ? CaptureResultExtras.CREATOR.createFromParcel(parcel) : null;
            this.onResultReceived(cameraMetadataNative, captureResultExtras);
            return true;
        }

        private static class Proxy
        implements ICameraDeviceCallbacks {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onCaptureStarted(CaptureResultExtras captureResultExtras, long l) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (captureResultExtras != null) {
                        parcel.writeInt(1);
                        captureResultExtras.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeLong(l);
                    this.mRemote.transact(3, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onDeviceError(int n, CaptureResultExtras captureResultExtras) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    if (captureResultExtras != null) {
                        parcel.writeInt(1);
                        captureResultExtras.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(1, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void onDeviceIdle() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onResultReceived(CameraMetadataNative cameraMetadataNative, CaptureResultExtras captureResultExtras) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (cameraMetadataNative != null) {
                        parcel.writeInt(1);
                        cameraMetadataNative.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    if (captureResultExtras != null) {
                        parcel.writeInt(1);
                        captureResultExtras.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(4, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }
        }
    }
}

