/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class MarshalQueryableEnum<T extends Enum<T>>
implements MarshalQueryable<T> {
    private static final String TAG = MarshalQueryableEnum.class.getSimpleName();
    private static final int UINT8_MASK = 255;
    private static final int UINT8_MAX = 255;
    private static final int UINT8_MIN;
    private static final boolean VERBOSE;
    private static final HashMap<Class<? extends Enum>, int[]> sEnumValues;

    static {
        VERBOSE = Log.isLoggable(TAG, 2);
        sEnumValues = new HashMap();
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends Enum<T>> T getEnumFromValue(Class<T> var0, int var1_1) {
        block5: {
            block6: {
                block7: {
                    var2_2 = true;
                    var3_3 = MarshalQueryableEnum.sEnumValues.get(var0);
                    if (var3_3 == null) break block7;
                    var4_4 = -1;
                    var7_5 = 0;
                    while (true) {
                        block9: {
                            block8: {
                                if (var7_5 >= var3_3.length) break block8;
                                if (var3_3[var7_5] != var1_1) break block9;
                                var4_4 = var7_5;
                            }
lbl11:
                            // 2 sources

                            while (true) {
                                var5_6 = (Enum[])var0.getEnumConstants();
                                if (var4_4 >= 0 && var4_4 < var5_6.length) break block5;
                                var6_7 = new Object[3];
                                var6_7[0] = var1_1;
                                var6_7[var2_2] = var0;
                                if (var3_3 != null) lbl-1000:
                                // 2 sources

                                {
                                    while (true) {
                                        var6_7[2] = var2_2;
                                        throw new IllegalArgumentException(String.format("Argument 'value' (%d) was not a valid enum value for type %s (registered? %b)", var6_7));
                                    }
                                }
                                break block6;
                                break;
                            }
                        }
                        ++var7_5;
                    }
                }
                var4_4 = var1_1;
                ** while (true)
            }
            var2_2 = false;
            ** while (true)
        }
        return (T)var5_6[var4_4];
    }

    private static <T extends Enum<T>> int getEnumValue(T t) {
        int[] nArray = sEnumValues.get(t.getClass());
        int n = t.ordinal();
        if (nArray != null) {
            n = nArray[n];
        }
        return n;
    }

    public static <T extends Enum<T>> void registerEnumValues(Class<T> clazz, int[] nArray) {
        if (((Enum[])clazz.getEnumConstants()).length != nArray.length) {
            throw new IllegalArgumentException("Expected values array to be the same size as the enumTypes values " + nArray.length + " for type " + clazz);
        }
        if (VERBOSE) {
            Log.v(TAG, "Registered enum values for type " + clazz + " values");
        }
        sEnumValues.put(clazz, nArray);
    }

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> typeReference, int n) {
        return new MarshalerEnum(typeReference, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isTypeMappingSupported(TypeReference<T> typeReference, int n) {
        if (n != 1) {
            if (n != 0) return false;
        }
        if (!(typeReference.getType() instanceof Class)) return false;
        Class clazz = (Class)typeReference.getType();
        if (!clazz.isEnum()) return false;
        if (VERBOSE) {
            Log.v(TAG, "possible enum detected for " + clazz);
        }
        try {
            Class[] classArray = new Class[]{String.class, Integer.TYPE};
            clazz.getDeclaredConstructor(classArray);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e(TAG, "Can't marshal class " + clazz + "; no default constructor");
            return false;
        }
        catch (SecurityException securityException) {
            Log.e(TAG, "Can't marshal class " + clazz + "; not accessible");
            return false;
        }
    }

    private class MarshalerEnum
    extends Marshaler<T> {
        private final Class<T> mClass;

        protected MarshalerEnum(TypeReference<T> typeReference, int n) {
            super(MarshalQueryableEnum.this, typeReference, n);
            this.mClass = typeReference.getRawType();
        }

        @Override
        public int getNativeSize() {
            return MarshalHelpers.getPrimitiveTypeSize(this.mNativeType);
        }

        @Override
        public void marshal(T t, ByteBuffer byteBuffer) {
            int n = MarshalQueryableEnum.getEnumValue(t);
            if (this.mNativeType == 1) {
                byteBuffer.putInt(n);
                return;
            }
            if (this.mNativeType == 0) {
                if (n < 0 || n > 255) {
                    Object[] objectArray = new Object[]{n};
                    throw new UnsupportedOperationException(String.format("Enum value %x too large to fit into unsigned byte", objectArray));
                }
                byteBuffer.put((byte)n);
                return;
            }
            throw new AssertionError();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public T unmarshal(ByteBuffer byteBuffer) {
            int n;
            switch (this.mNativeType) {
                default: {
                    throw new AssertionError((Object)"Unexpected native type; impossible since its not supported");
                }
                case 1: {
                    n = byteBuffer.getInt();
                    return MarshalQueryableEnum.getEnumFromValue(this.mClass, n);
                }
                case 0: 
            }
            n = 0xFF & byteBuffer.get();
            return MarshalQueryableEnum.getEnumFromValue(this.mClass, n);
        }
    }
}

